<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Brand;
use App\Helpers\Helper;

class BrandController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Brand::orderBy('id','DESC')->paginate(10);
        return view('admin.brands.index',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.brands.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'image' => 'required',
        ]);

        $slug = Helper::getBlogUrl($request->name);
        if (Brand::where('slug', '=', $slug)->count() > 0)
        {
            return back()->with('flash_error', 'Brand Already Exits');
        }
        else{
            $data = new Brand;
            $data->name = $request->name;
            $data->status = $request->status;
            $data->slug = $slug;
            if($request->hasfile('image'))
            {
                $file = $request->file('image');
                $filename1 = uniqid() . '.' . $file->getClientOriginalExtension($file);
                $file->move(public_path('uploads/images'),$filename1); 
                $data->image = $filename1;  
            }
            $data->save();
            return back()->with('flash_success', 'Brand Created successfully');
        }

        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Brand::find($id);
        return view('admin.brands.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //dd($_REQUEST);
        $this->validate($request, [
            'name' => 'required',
        ]);

        $data = Brand::find($id);
        $data->name = $request->name;
        $data->status = $request->status;
        if($request->hasfile('image'))
        {
            @unlink(public_path('uploads/images/'.$data->image));
            $file = $request->file('image');
            $filename = uniqid() . '.' . $file->getClientOriginalExtension($file);
            $file->move(public_path('uploads/images'),$filename); 
            $data->image = $filename;  
        }
        $data->save();
        return back()->with('flash_success', 'Brand Updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Brand::find($id);
        @unlink(public_path('uploads/images/'.$data->image));
        $data->delete();
        return back()->with('flash_success', 'Brand Deleted  Successfully!');
    }
}
