<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Contact;
use App\Models\Order;
use App\Models\Category;
use App\Models\Brand;
use App\Models\Product;
use App\User;

class HomeController extends Controller
{
    public function index(Request $request)
    {
        $OrderPlaced = Order::where('status','OrderPlaced')->count('id');
        $OrderDelivered = Order::where('status','OrderDelivered')->count('id');
        $TotalCategory = Category::whereNull('parent_id')->count('id');
        $TotalSubcategory = Category::wherenotNull('parent_id')->count('id');
        $TotalProduct = Brand::count('id');
        $TotalCustomer = User::where('role_id',2)->count('id');
    	return view('admin.home',compact('OrderPlaced','OrderDelivered','TotalCategory','TotalSubcategory','TotalProduct','TotalCustomer'));
    }

    public function contacts(Request $request)
    {
        $data = Contact::orderBy('id','desc')->paginate(10);
        return view('admin.contacts.index',compact('data'));
    }

    public function deleteContacts(Request $request)
    {
        $data = Contact::find($request->id);
        $data->delete();
        return back()->with('flash_success', 'Contact Message deleted successfully');
    }
}
