<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\OrderList;

class OrderController extends Controller
{
    public function orders(Request $request)
    {
    	$orders = Order::orderBy('id','desc')->paginate(20);
    	return view('admin.orders.index',compact('orders'));
    }

    public function changeOrderStatus(Request $request)
    {
        $order = Order::where('order_id',$request->order_id)->first();
        if ($order) {
            $order->status = $request->order_status;
        if ($request->order_status == "OrderDelivered") {
          $order->delivered_date = \Carbon\Carbon::now();
        }
            $order->save();
            return back()->with('flash_success', 'Status updated successfully');
        }
    }

    public function orderDetail(Request $request)
    {
        $order = Order::where('order_id',$request->order_id)->first();
        if ($order) {
            $orderitems = OrderList::where('order_id',$request->order_id)->get();
            return view('admin.orders.order-details',compact('order','orderitems'));
        }
    }
}
