<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\Cart;
use App\Models\Wishlist;
use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\Category;
use App\Models\ProductImage;
use App\Helpers\Helper;
use App\Models\Brand;
use App\Models\Review;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Product::orderBy('id','DESC')->paginate(10);
        return view('admin.products.index',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $firstcategory = Category::whereNull('parent_id')->first();
        $subcategory_id = Category::wherenotNull('parent_id')->get();
        $categories = Category::whereNull('parent_id')->get();
      
        if (isset($request->category_id) && $request->category_id !='') {
            $subcategories = Category::wherenotNull('parent_id')->where('parent_id',$request->category_id)->get();
        }
        else{ 
            $subcategories = Category::wherenotNull('parent_id')->where('parent_id',@$firstcategory->id)->get();
        }
        
        return view('admin.products.create',compact('categories','subcategories','subcategory_id','firstcategory'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // echo "<pre>";
        // print_r($_REQUEST);
        // exit();

        $this->validate($request, [
            'parent_category_id' => 'required',
            'subcategory_id' => 'required',
            'productname' => 'required',
            'description'=> 'required',
            'mrp_price' => 'required',
            'selling_price' => 'required',
            'images' => 'required',
            'productstatus' => 'required',
            'producttype' => 'required',
            'stock_quantity' => 'required',
			'quantity' => 'required'
        ]);

        $slug = Helper::getBlogUrl($request->productname);
        $product = new Product;
        $product->category_id = $request->parent_category_id;
        $product->subcategory_id = $request->subcategory_id;
        $product->name = $request->productname;
        $product->description = $request->description;
        $product->mrp_price = $request->mrp_price;
        $product->selling_price = $request->selling_price;
        $product->status = $request->productstatus;
        $product->product_type = $request->producttype;
        $product->stock_quantity = $request->stock_quantity;
		$product->quantity = $request->quantity;
        $product->slug = $slug;
        $product->save();

        if($request->hasfile('images'))
        {
            $imgCount = 0;
            foreach($request->file('images') as $image)
            {
                $imgCount++;
                $name=time().uniqid(). '.' . $image->getClientOriginalName();
                $image->move(public_path().'/uploads/images/', $name);  
                $data[] = $name;

                $product_images= new ProductImage();
                $product_images->product_id = $product->id;
                $product_images->image = $name;
                if ($imgCount == 1) {
                    $product_images->is_featured = 1;
                }
                else{
                    $product_images->is_featured = 0;
                }
                $product_images->save();  
            }
        } 
        return redirect('admin/products')->with('flash_success', 'Product Created Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function addMoreImages(Request $request)
    {
        if($request->hasfile('images'))
        {
            foreach($request->file('images') as $image)
            {
                $name=time().uniqid(). '.' . $image->getClientOriginalName();
                $image->move(public_path().'/uploads/images/', $name);  
                //$data[] = $name;
                $product_images= new ProductImage();
                $product_images->product_id = $request->product_id;
                $product_images->image = $name;
                $product_images->is_featured = 1;
                $product_images->save();  
            }
        } 
        return back()->with('flash_success', 'Images Uploaded successfully');
    }


    public function edit(Request $request,$id)
    {
        $brands = Brand::where('status','Active')->get();
        $images = ProductImage::where('product_id',$id)->get();
        $data = Product::findOrFail($id);
        $firstcategory = Category::whereNull('parent_id')->first();
        $categories = Category::whereNull('parent_id')->get();
        if (isset($request->category_id) && $request->category_id !='') {
            $subcategories = Category::wherenotNull('parent_id')->where('parent_id',$request->category_id)->get();
        }
        else{
            $subcategories = Category::wherenotNull('parent_id')->where('parent_id',$data->category_id)->get();
        }
        
        return view('admin.products.edit',compact('data','categories','subcategories','firstcategory','images','brands'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //dd($_REQUEST);
        $this->validate($request, [
            'parent_category_id' => 'required',
            'subcategory_id' => 'required',
            'productname' => 'required',
            'description'=> 'required',
            'mrp_price' => 'required',
            'selling_price' => 'required',
            'productstatus' => 'required',
            'producttype' => 'required',
            'stock_quantity' => 'required',
			'quantity' => 'required'
        ]);
        
        $slug = Helper::getBlogUrl($request->productname);
        $product = Product::find($id);
        $product->stock_quantity = $request->stock_quantity;
        $product->category_id = $request->parent_category_id;
        $product->subcategory_id = $request->subcategory_id;
        $product->name = $request->productname;
        $product->description = $request->description;
        $product->mrp_price = $request->mrp_price;
        $product->selling_price = $request->selling_price;
        $product->status = $request->productstatus;
        $product->product_type = $request->producttype;
        $product->slug = $slug;
		$product->quantity = $request->quantity;
        $product->save();

        return redirect('admin/products')->with('flash_success', 'Product Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Product::findOrFail($id);
        $product_images = ProductImage::where('product_id',$id)->get();
        foreach ($product_images as $product_image) {
            @unlink(public_path('uploads/images/'.$product_image->image));
            $product_image->delete();
        }
		$carts=Cart::where('product_id',$id)->delete();
        $lists=Wishlist::where('product_id',$id)->delete();
        $data->delete();
        return back()->with('flash_success', 'Product Deleted  Successfully!');
    }

    public function makeFeatureImage(Request $request)
    {
        $arr['succ'] = 0;
        $id = $request->id;
        $imageId = $request->imageId;

        ProductImage::where('product_id', $id)->update([
            'is_featured' => 0
        ]);

        $data = ProductImage::where('product_id',$id)->where('id',$imageId)->first();
        $data->is_featured = 1;
        if ($data->save()) {
            $arr['id'] = $id;
            $arr['succ'] = 1;
        }
        echo json_encode($arr); 

    }

    public function deleteMultipleImages(Request $request)
    {
        $id = $_REQUEST['id'];
        $data = ProductImage::find($id);
        $makeFeatureImage = ProductImage::where('id',$id)->first();
        $makeFeatureImage->is_featured = 1;
        $makeFeatureImage->save();
		if($data->delete())
		return back()->with('flash_success', 'Image Deleted Successfully!');
        $delete = @unlink(public_path('uploads/images/'.$data->image));
        if ($delete = true) {
            if ($data->delete()) {
                return back()->with('flash_success', 'Image Deleted Successfully!');
            }
        }
    }

    public function productReviews()
    {
        $data = Review::orderBy('id','DESC')->paginate(20);
        return view('admin.products.product-reviews',compact('data'));
    }

    public function deleteReviews(Request $request)
    {
        $data = Review::find($request->id);
        $data->delete();
        return back()->with('flash_success', 'Review deleted successfully');
    }
}
