<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Helpers\Helper;

class SubcategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) 
    {
        $category = Category::where('slug',$request->parent)->first();
        $data = Category::where('parent_id',$category->id)->orderBy('id','DESC')->get();
        return view('admin.subcategory.index',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Category::whereNull('parent_id')->get();
        return view('admin.subcategory.create',compact('categories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'parent_id' => 'required'
        ]);

        $slug = Helper::getBlogUrl($request->name);
        if (Category::where('slug', '=', $slug)->count() > 0)
        {
            return back()->with('flash_error', 'Subcategory Already Exits');
        }

        $data = new Category;
        $data->name = $request->name;
        $data->parent_id = $request->parent_id;
        $data->status = $request->status;
        $data->slug = $slug;
        if($request->hasfile('images'))
        {
            $file = $request->file('images');
            $filename = uniqid() . '.' . $file->getClientOriginalExtension($file);
            $file->move(public_path('uploads/images'),$filename); 
            $data->image = $filename;  
        }
        $data->save();
        return redirect('admin/subcategory?parent='.$request->parent_slug)->with('flash_success', 'Subcategory Created Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $categories = Category::whereNull('parent_id')->get();
        $data = Category::find($id);
        return view('admin.subcategory.edit',compact('data','categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $slug = Helper::getBlogUrl($request->name);
        if (Category::where('slug', '=', $slug)->where('id', '!=', $id)->count() > 0)
        {
            return back()->with('flash_error', 'Subcategory Already Exits');
        }

        $data = Category::find($id);
        $parent = Category::find($request->parent_id);


        $data->name = $request->name;
        $data->parent_id = $request->parent_id;
        $data->status = $request->status;
        $data->slug = $slug;
        if($request->hasfile('images'))
        {
            @unlink(public_path('uploads/images/'.$data->image));
            $file = $request->file('images');
            $filename = uniqid() . '.' . $file->getClientOriginalExtension($file);
            $file->move(public_path('uploads/images'),$filename); 
            $data->image = $filename;  
        }
        $data->save();
        return redirect('admin/subcategory?parent='.$parent->slug)->with('flash_success', 'Subcategory Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Category::find($id);
        @unlink(public_path('uploads/images/'.$data->image));
        $data->delete();
        return back()->with('flash_success', 'Subcategory Deleted Successfully!');
    }
}
