<?php

namespace App\Http\Controllers\Api;

use App\Mail\OrderMail;
use App\Models\Cart;
use App\Models\Coupon;
use App\Models\Order;
use App\Http\Controllers\Controller;
use App\Models\OrderList;
use App\Models\Pincode;
use App\Models\Product;
use App\Models\Wallet;
use App\Models\State;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class OrderController extends Controller
{
    //pincode and coupon check for order
    public function orderCheck(Request $request)
    {
        $user = Auth::user();
        $carts = Cart::where('user_id', $user->id)->get();
        $sub_total = 0;

        foreach ($carts as $cart) {
            $product = Product::find($cart->product_id);
            $selling_price = $product->selling_price;
            $total = $selling_price * $cart->quantity;
            $cart->total = $total;
            $sub_total += $total;
        }
        if ($request->pincode) {
            $pincode = $request->pincode;
            $pincodes = Pincode::where('pincode', $pincode)->get()->first();
            $count = count($pincodes);
            if ($count == 0) {
                return response()->json([
                    'message' => 'Given Pincode Not Available', 'sub_total' => $sub_total, 'total' => $sub_total
                ]);
            } else {
                $totalWithAllTheCharges = $sub_total;
                $shipping = $pincodes->delivery_charge;
                $totalWithAllTheCharges += $shipping;

                return response()->json([
                    'success' => true,
                    'statusCode' => 200,
                    'message' => 'Pincode Applied',
                    'shipping' => $shipping, 'sub_total' => $sub_total, 'total' => $totalWithAllTheCharges
                ]);
            }
        } elseif ($request->coupon_id) {

        } else {
            return response()->json([
                'message' => 'Given Pin Code Not Available', 'sub_total' => $sub_total, 'total' => $sub_total
            ]);

        }


    }

    //pincode
    public function pinCodeCheck(Request $request)
    {
        if ($request->pincode) {
            $pincode = $request->pincode;
            $pins = Pincode::where('pincode', $pincode)->get()->first();

            if ($pins == null) {
                return response()->json([
                    'message' => 'Given Pin code Not Available'
                ]);
            } else {
					$carts=Cart::where('user_id',Auth::id())->get();
					foreach($carts as $cart){
					$cart->pincode_id=$pins->id;
					$cart->save();
		}
                $shipping = $pins->delivery_charge;
                return response()->json([
                    'success' => true,
                    'statusCode' => 200,
                    'message' => 'Pin code Applied',
                    'shipping' => $shipping,
                ]);
            }
        }else{
		 return response()->json([
                    'success' => false,
                    'statusCode' => 401,
                    'message' => 'Pin code Required',
                    
                ]);
		}
    }

    //couponcode
    public function couponCodeCheck(Request $request)
    {

        $this->validate($request, [
            'couponcode' => 'required|string',
        ]);

        $carts = Cart::where('user_id', Auth::user()->id)->get();

        foreach ($carts as $cart) {
            $subtotal[] = $cart->product->selling_price * $cart->quantity;
        }
        $couponcode = Coupon::where('coupon_code', $request->couponcode)
            ->where('validity_till', '>=', date("Y-m-d"))
            ->where('minimum_order', '<=', array_sum($subtotal))
            ->where('status', 'Active')
            ->first();

        if ($couponcode) {
            if (isset($couponcode->id) && $couponcode->coupon_code === $request->couponcode) {
                Cart::where('user_id', Auth::user()->id)
                    ->update(['coupon_id' => $couponcode->id]);
                return response()->json([
                    'success' => true,
                    'statusCode' => 200,
                    'message' => 'Coupon Applied',

                ]);
            } else {
                return response()->json([
                    'message' => 'Given Coupon Not Available'
                ]);
            }
        } else {
            return response()->json([
                'message' => 'Given Coupon Not Available'
            ]);
        }


    }
	//get coupon discount
 public static function getDiscount($total_amount)
    {
        $discount_amount = 0;
        $cart = Cart::where('user_id', Auth::id())->first();
        if ($cart) {
            $couponcode = Coupon::find($cart->coupon_id);
            if ($couponcode) {
                if ($couponcode->discount_type == 'Percentage') {
                    $discount_amount = ($total_amount * $couponcode->discount_amount)/100;
                    $payable_amount = $total_amount - $discount_amount;
                }
                if ($couponcode->discount_type == 'Flat') {
                    $discount_amount = $couponcode->discount_amount;
                    $payable_amount = $total_amount - $discount_amount;
                }
                $discount_amount = round($discount_amount);
                $discount_type = $couponcode->discount_type;
                $payable_amount = round($payable_amount);
            }
        }
        
         return response()->json([
            'message' => 'Discount', 'discount' => $discount_amount, 'success' => true, 'statusCode' => 200
        ]);
    }
	//get sub total price
	public static function getSubTotalPrice($discount_amount,$wallet)
    {
        $carts = Cart::where('user_id', Auth::Id())->get();
        foreach ($carts as $cart) {
            $subtotal[] = $cart->product->selling_price*$cart->quantity;
        }
        $cartfirst = Cart::where('user_id',Auth::Id())->first();
        $pincode = Pincode::find($cartfirst->pincode_id);
        if ($pincode && array_sum($subtotal) < 500) {
            $payable_amount = (array_sum($subtotal) - $discount_amount - $wallet) + $pincode->delivery_charge;
        } 
        else{
            $payable_amount = array_sum($subtotal) - $discount_amount - $wallet;
        }
       return response()->json([
            'message' => 'Payable Amount', 'amount' => $payable_amount, 'success' => true, 'statusCode' => 200
        ]); 
    }
         //order
    public function confirmOrder(Request $request)
    {
        $user = Auth::user();
 $hash= '';
		$parameters=[];
        $getlastId = Order::orderBy('id', 'desc')->first();
        $carts = Cart::where('user_id', $user->id)->get();
        $getCart = Cart::where('user_id', $user->id)->first();
        $pincode = Pincode::find($getCart->pincode_id);
        if ($getlastId) {
            $order_id = "Nakoda" . time() . $getlastId->id;
        } else {
            $order_id = "Nakoda" . time() . "1";
        }
        foreach ($carts as $cart) {
            $subtotal[] = $cart->product->selling_price * $cart->quantity;
            $product = Product::find($cart->product_id);
            $orderList = new OrderList;
            $orderList->order_id = $order_id;
            $orderList->product_id = $cart->product_id;
            $orderList->mrp_price = $product->mrp_price;
            $orderList->selling_price = $product->selling_price;
            $orderList->quantity = $cart->quantity;
            $orderList->save();
            if($product->stock_quantity>0){
                $product->stock_quantity=$product->stock_quantity-$orderList->quantity;
                $product->save();
            }


        }
        $order = new Order;
        $order->user_id = $user->id;
        $order->name = $request->shipping_name;
        $order->email = $request->shipping_email;
        $order->phone = $request->shipping_phone;
        $order->state = $request->shipping_state;
        $order->city = $request->shipping_city;
        $order->pincode = $request->shipping_pincode;
        $order->address = $request->shipping_address;
        $order->order_id = $order_id;
        $order->order_price = array_sum($subtotal);
        $order->payment_id = $request->payment_id;
        $order->status = "OrderPlaced";
        $order->payment_type = $request->payment_type;
        if($request->payment_type=='Online'){

            //payumoney order create

            $merchant_key="9ZVZ7gaI";
            $txnid = uniqid();
            $totalCost = $request->payable_price;
            $firstName= $request->shipping_name;
            $email = $request->shipping_email;
            $SALT = "Poxz98fRZj";
            $lastname = '';
            $state = $request->shipping_state;
            $phone = $request->shipping_phone;
            $zipcode = $request->shipping_pincode;
            $address1 = $request->shipping_street;
            $address2 = $request->shipping_city;

           // $hash= '';
            $hash_string = $merchant_key."|".$txnid."|".$totalCost."|"."productinfo|".$firstName."|".$email."|||||||||||".$SALT;
            $hash = strtolower(hash('sha512', $hash_string));


            $parameters = [
                'txnid' => $txnid,
                'order_id' => $order->order_id,
                'amount' => $totalCost,
                'email' => $email,
                'key' => "9ZVZ7gaI",
                'firstname' =>$firstName,
                'lastname' => $lastname,
                'phone' =>$phone ,
                'productinfo' => 'Mobile Accessories',
                'service_provider' => 'payu_paisa',
                'zipcode' =>$zipcode,
                'city' => $request->shipping_city,
                'state'	 => $state,
                'country' => "India",
                'address1' => $address1,
                'address2' => $address2,
                'hash' => $hash,

            ];


        }
        $order->payable_price = $request->payable_price;
        $order->wallet_amount = $request->wallet_amount;
        $order->delivered_date = $request->delivered_date;
        $order->coupon_id = $request->coupon_id;
        $order->coupon_amount = $request->coupon_amount;
        $order->delivery_charge = $request->delivery_charge;
        $order->save();
        if ($request->wallet_amount > 0) {
            $order->wallet_amount = $request->wallet_amount;
            $ref_wallet = new Wallet;
            $ref_wallet->user_id = Auth::user()->id;
            $ref_wallet->amount = $request->wallet_amount;
            $ref_wallet->status = "Active";
            $ref_wallet->debit_credit_type = "MINUS";
            $ref_wallet->save();
        }
        try {
        $data = ['order_id' => $order->order_id];
       Mail::to($user->email)->send(new OrderMail($data));
        } catch (Exception $e) {
        }
        foreach ($carts as $cart) {
            $cart->delete();
        }
        return response()->json([
            'message' => 'Order Placed', 'order' => $order, 'success' => true, 'statusCode' => 200,'hash'=>$hash,'parameters'=>$parameters
        ]);

    }
	//remove pinCode
	public function removePincode(){
		$carts=Cart::where('user_id',Auth::id())->get();
		foreach($carts as $cart){
		$cart->pincode_id=null;
			$cart->save();
		}
		return response()->json(['success'=>true,'statusCode'=>200,'message'=>'Pincode removed']);
	}
	//remove coupon Code
	public function removeCoupon(){
		$carts=Cart::where('user_id',Auth::id())->get();
		foreach($carts as $cart){
		$cart->coupon_id=null;
			$cart->save();
		}
		return response()->json(['success'=>true,'statusCode'=>200,'message'=>'Coupon removed']);
	}

    //order details By order
    public function orderDetailsByOrder($id)
    {
        $orderDetails = OrderList::where('order_id', $id)->get();
		$user=Auth::user();
		foreach($orderDetails as $orderDetail){
		$product=Product::find($orderDetail->product_id);
		$orderDetail->product_id=$product;	
		}
        return response()->json(['success' => true, 'statusCode' => 200,'user'=>$user ,'orderList' => $orderDetails]);
    }

}
