<?php

namespace App\Http\Controllers\Api;

use App\Models\Banner;
use App\Models\Brand;
use App\Models\Cart;
use App\Models\Category;
use App\Models\Coupon;
use App\Models\Order;
use App\Models\OrderList;
use App\Models\Pincode;
use App\Models\Product;
use App\Models\ProductImage;
use App\Models\Review;
use App\Models\Wallet;
use App\Models\Wishlist;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;

class ProductController extends Controller
{
    //get all active categories
    public function getAllActiveCategory()
    {
        $categories = Category::where('status', 'Active')->get();
        return response()->json([
            'success' => true, 'statusCode' => 200, 'message' => 'Active Category', 'activeCategory' => $categories
        ]);
    }

//productBySingleCategory
    public function productBySingleCategory($id)
    {
        $products = Product::where('category_id', $id)->get();

        foreach ($products as $product) {
            $totalReviews = [];
            $reviews = Review::where('product_id', $product->id)->get();
            $reviewCount = count($reviews);
            $reviewList = Review::where('product_id', $product->id)->pluck('review');
            if ($reviewCount != 0) {
                $product->reviewList = $reviewList;
            }
            foreach ($reviews as $review) {
                $totalReviews[] = $review->rating;
            }
            if ($reviewCount == 0) {
                $reviewCount = 1;
            }
            $data = round(array_sum($totalReviews) / $reviewCount);
            $product->ratingAverage = $data;
            $productImages = ProductImage::where('product_id', $product->id)->get();
            $product->images = $productImages;
        }
        return response()->json(['success' => true, 'statusCode' => 200, 'message' => 'product by single category', 'productsBySingleCategory' => $products]);
    }

//home

    public function getHome()
    {
        $categoriesForMenu = Category::whereNull('parent_id')->where('status', 'Active')->orderBy('id', 'ASC')->get();
        foreach ($categoriesForMenu as $categoryForMenu) {
            $subCategories = Category::where('parent_id', $categoryForMenu->id)->where('status', 'Active')->get();
            $categoryForMenu->SubCategories = $subCategories;
        }
        $categories = Category::whereNull('parent_id')->where('status', 'Active')->orderBy('id', 'ASC')->get();
        foreach ($categories as $category) {
            $products = Product::where('category_id', $category->id)->get();

            foreach ($products as $product) {
                $totalReviews = [];
                $reviews = Review::where('product_id', $product->id)->get();
                $reviewList = Review::where('product_id', $product->id)->pluck('review');
                $reviewCount = count($reviews);
                if ($reviewCount != 0) {
                    $product->reviewList = $reviewList;
                }
                foreach ($reviews as $review) {
                    $totalReviews[] = $review->rating;
                }
                if ($reviewCount == 0) {
                    $reviewCount = 1;
                }
                $data = round(array_sum($totalReviews) / $reviewCount);
                $product->ratingAverage = $data;
                $productImages = ProductImage::where('product_id', $product->id)->get();
                $product->images = $productImages;
            }
            $category->products = $products;
        }
        $top_sellers = Product::where('status', 'Active')->where('product_type', 'TopSellers')->orderBy('id', 'desc')->get();

        foreach ($top_sellers as $top_seller) {
            $totalProductReviews = [];
            $reviews = Review::where('product_id', $top_seller->id)->get();
            $reviewCount = count($reviews);
            $reviewList = Review::where('product_id', $top_seller->id)->pluck('review');
            if ($reviewCount != 0) {
                $top_seller->reviewList = $reviewList;
            }
            foreach ($reviews as $review) {
                $totalProductReviews[] = $review->rating;
            }
            if ($reviewCount == 0) {
                $reviewCount = 1;
            }
            $data = round(array_sum($totalProductReviews) / $reviewCount);
            $top_seller->ratingAverage = $data;
            $productImages = ProductImage::where('product_id', $top_seller->id)->get();
            $top_seller->images = $productImages;
        }

        $newProducts = Product::where('status', 'active')->orderBy('id', 'desc')->limit(9)->get();
        foreach ($newProducts as $newProduct) {
            $totalNewProductReviews = [];
            $reviews = Review::where('product_id', $newProduct->id)->get();
            $reviewCount = count($reviews);
            $reviewList = Review::where('product_id', $newProduct->id)->pluck('review');

            if ($reviewCount != 0) {
                $newProduct->reviewList = $reviewList;
            }
            foreach ($reviews as $review) {
                $totalNewProductReviews[] = $review->rating;
            }
            if ($reviewCount == 0) {
                $reviewCount = 1;
            }
            $data = round(array_sum($totalNewProductReviews) / $reviewCount);
            $newProduct->ratingAverage = $data;
            $productImages = ProductImage::where('product_id', $newProduct->id)->get();
            $newProduct->images = $productImages;
        }
        $brands = Brand::where('status', 'Active')->orderBy('id', 'ASC')->get();
        $banners = Banner::where('status', 'Active')->orderBy('id', 'ASC')->get();
        return response()->json(['success' => true, 'statusCode' => 200,
            'message' => 'Home', 'categoriesForMenu' => $categoriesForMenu, 'shopByCategory' => $categories, 'latestProducts' => $newProducts, 'brands' => $brands, 'topSellers' => $top_sellers, 'banners' => $banners
        ]);

    }

    //product by id
    public function productById($id)
    {
        $product = Product::find($id);
        $similar_products = Product::with('productImage')->where('status', 'Active')->where('category_id', $product->category_id)->orderBy('id', 'desc')->get();
		foreach ($similar_products as $similar_product){
           $tReviews = [];
           $sreviews = Review::where('product_id', $similar_product->id)->get();
           $sreviewCount = count($sreviews);
           $sreviewList = Review::where('product_id', $similar_product->id)->pluck('review');
           if ($sreviewCount != 0) {
               $similar_product->reviewList = $sreviewList;
           }else{
		   $similar_product->reviewList = null;
		   }
           foreach ($sreviews as $sreview) {
               $tReviews[] = $sreview->rating;
           }
           if ($sreviewCount == 0) {
               $sreviewCount = 1;
           }
           $sdata = round(array_sum($tReviews) / $sreviewCount);
           $similar_product->ratingAverage = $sdata;
       }
        $new_products = Product::with('productImage')->where('status', 'Active')->where('product_type', 'NewProducts')->orderBy('id', 'desc')->get();
		foreach ($new_products as $new_product){
           $tnReviews = [];
           $nreviews = Review::where('product_id', $new_product->id)->get();
           $nreviewCount = count($nreviews);
           $nreviewList = Review::where('product_id', $new_product->id)->pluck('review');
           if ($nreviewCount != 0) {
               $new_product->reviewList = $nreviewList;
           }else{
               $new_product->reviewList = null;
           }
           foreach ($nreviews as $nreview) {
               $tnReviews[] = $nreview->rating;
           }
           if ($nreviewCount == 0) {
               $nreviewCount = 1;
           }
           $ndata = round(array_sum($tnReviews) / $nreviewCount);
           $new_product->ratingAverage = $ndata;
       }
        $totalReviews = [];
        $reviews = Review::where('product_id', $product->id)->get();
        $reviewCount = count($reviews);
        $reviewList = Review::where('product_id', $product->id)->pluck('review');
        if ($reviewCount != 0) {
            $product->reviewList = $reviewList;
        }else{
		$product->reviewList = null;
		}
        foreach ($reviews as $review) {
            $totalReviews[] = $review->rating;
        }
        if ($reviewCount == 0) {
            $reviewCount = 1;
        }
        $data = round(array_sum($totalReviews) / $reviewCount);
        $product->ratingAverage = $data;
        $productImages = ProductImage::where('product_id', $product->id)->get();
        $product->images = $productImages;
        $category = Category::find($product->category_id);
        $product->category_id = $category;
        return response()->json(['statusCode' => 200, 'success' => true, 'product' => $product, 'similar' => $similar_products, 'latest' => $new_products]);
    }

    //our brands
    public function ourBrands()
    {
        $brands = Brand::where('status', 'Active')->orderBy('id', 'ASC')->get();
        return response()->json([
            'success' => true, 'statusCode' => 200,
            'message' => 'Our Brands',
            'brands' => $brands
        ]);

    }

    //brand wise products
    public function brandWiseProducts($id)
    {
        $products = Product::where('brand_id', $id)->get();

        foreach ($products as $product) {
            $totalReviews = [];
            $reviews = Review::where('product_id', $product->id)->get();
            $reviewCount = count($reviews);
            $reviewList = Review::where('product_id', $product->id)->pluck('review');
            if ($reviewCount != 0) {
                $product->reviewList = $reviewList;
            }
            foreach ($reviews as $review) {
                $totalReviews[] = $review->rating;
            }
            if ($reviewCount == 0) {
                $reviewCount = 1;
            }
            $data = round(array_sum($totalReviews) / $reviewCount);
            $product->ratingAverage = $data;
            $productImages = ProductImage::where('product_id', $product->id)->get();
            $product->images = $productImages;
        }
        return response()->json([
            'success' => true, 'statusCode' => 200,
            'message' => 'Brand Wise Products',
            'products' => $products
        ]);
    }

    //search route
    public function searchByProductName($name)
    {
        $products = Product::where('name', 'Like', "%{$name}%")->get();
		if($products){
foreach($products as $product){
        
            $totalReviews = [];
            $reviews = Review::where('product_id', $product->id)->get();
            $reviewCount = count($reviews);
            $reviewList = Review::where('product_id', $product->id)->pluck('review');
            if ($reviewCount != 0) {
                $product->reviewList = $reviewList;
            }
            foreach ($reviews as $review) {
                $totalReviews[] = $review->rating;
            }
            if ($reviewCount == 0) {
                $reviewCount = 1;
            }
            $data = round(array_sum($totalReviews) / $reviewCount);
            $product->ratingAverage = $data;
            $productImages = ProductImage::where('product_id', $product->id)->get();
            $product->images = $productImages;
}
            return response()->json(['success' => true, 'statusCode' => 200, 'message' => 'Product Found', 'products' => $products]);
		}else{
		 return response()->json(['success' => false, 'statusCode' => 200, 'message' => 'Product Not Found']);
		}       
    }

    //more product details
    public function productDetailsWithRelatedAndRecent($slug)
    {
        $product = Product::where('slug', $slug)->where('status', 'Active')->first();
        $similar_products = Product::where('status', 'Active')->where('category_id', $product->category_id)->orderBy('id', 'desc')->get();
        $new_products = Product::where('status', 'Active')->where('product_type', 'NewProducts')->orderBy('id', 'desc')->get();
        $totalReviews = [];
        $reviews = Review::where('product_id', $product->id)->get();
        $reviewCount = count($reviews);
        $reviewList = Review::where('product_id', $product->id)->pluck('review');
        if ($reviewCount != 0) {
            $product->reviewList = $reviewList;
        }
        foreach ($reviews as $review) {
            $totalReviews[] = $review->rating;
        }
        if ($reviewCount == 0) {
            $reviewCount = 1;
        }
        $data = round(array_sum($totalReviews) / $reviewCount);
        $product->ratingAverage = $data;
        $productImages = ProductImage::where('product_id', $product->id)->get();
        $product->images = $productImages;
        $category = Category::find($product->category_id);
        $product->category_id = $category;
        return response()->json(['statusCode' => 200, 'success' => true, 'product' => $product, 'similar' => $similar_products, 'latest' => $new_products]);
    }

    //cart


    //add in cart
    public function store(Request $request)
    {
        $cart = new Cart();
        // $cart->session_id = $request->session_id;
        $cart->product_id = $request->product_id;
        $cart->user_id = Auth::user()->id;
        $cart->quantity = $request->quantity;
        $cart->coupon_id = $request->coupon_id;
        $cart->pincode_id = $request->pincode_id;
        $cart->save();
        return response()->json(['success' => true, 'statusCode' => 200, 'message' => 'Successfully Posted Cart Product', 'cart' => $cart]);
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $cart = Cart::find($id);
        $product = Product::find($cart->product_id);
        $reviews = Review::where('product_id', $product->id)->get();
        $reviewCount = count($reviews);
        $reviewList = Review::where('product_id', $product->id)->pluck('review');
        if ($reviewCount != 0) {
            $product->reviewList = $reviewList;
        }
        foreach ($reviews as $review) {
            $totalReviews[] = $review->rating;
        }
        if ($reviewCount == 0) {
            $reviewCount = 1;
        }
        $data = round(array_sum($totalReviews) / $reviewCount);
        $product->ratingAverage = $data;
        $productImages = ProductImage::where('product_id', $product->id)->get();
        $product->images = $productImages;
        $cart->product_id = $product;
        return response()->json(['success' => true, 'statusCode' => 200, 'cart' => $cart]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $cart = Cart::find($id);
        //$cart->session_id = $request->session_id;
        $cart->product_id = $request->product_id;
        $cart->user_id = Auth::user()->id;
        $cart->quantity = $request->quantity;
        $cart->coupon_id = $request->coupon_id;
        $cart->pincode_id = $request->pincode_id;
        $cart->save();
        return response()->json(['success' => true, 'statusCode' => 200, 'message' => 'Successfully Updated Cart Product', 'cartProduct' => $cart]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $cart = Cart::find($id);
        $cart->delete();
        return response()->json(['success' => true, 'statusCode' => 200, 'message' => 'Successfully Deleted Cart Product']);
    }

//view cart products by user
    public function cartProducts()
    {
        $delivery_charge = 0;
        $pincode = "";
        $subTotal = [];
        $cartProducts = Cart::where('user_id', Auth::user()->id)->get();
		$count=count($cartProducts);
		if($count==0){
			 return response()->json([
            'success' => true, 'statusCode' => 200,
            'message' => 'Cart is empty'
        ]);
		}else{
        $isCouponCheck = Cart::where('user_id', Auth::user()->id)->wherenotNull('coupon_id')->first();
        $checkpincode = Cart::where('user_id', Auth::user()->id)->wherenotNull('pincode_id')->first();

        if ($checkpincode) {
            $isPincode = 1;
            $pincode = Pincode::find($checkpincode->pincode_id);
        } else {
            $isPincode = 0;
			$pincode=null;
        }

        if ($isCouponCheck) {
            $isCoupon = 1;
            $coupon = Coupon::find($isCouponCheck->coupon_id);
        } else {
            $isCoupon = 0;
            $coupon = null;
        }
        foreach ($cartProducts as $cartProduct) {
            $totalReviews = [];
			$total=0;
            $product = Product::find($cartProduct->product_id);
            $reviews = Review::where('product_id', $product->id)->get();
            $reviewCount = count($reviews);
            $reviewList = Review::where('product_id', $product->id)->pluck('review');
            if ($reviewCount != 0) {
                $product->reviewList = $reviewList;
            }
            foreach ($reviews as $review) {
                $totalReviews[] = $review->rating;
            }
            if ($reviewCount == 0) {
                $reviewCount = 1;
            }
            $data = round(array_sum($totalReviews) / $reviewCount);
            $product->ratingAverage = $data;
            $productImages = ProductImage::where('product_id', $product->id)->get();
            $product->images = $productImages;
            $cartProduct->product_id = $product;
            $subTotal[] = $product->selling_price * $cartProduct->quantity;
			//$cartProduct->total=$total;

        }
			//$subTotal+=$total;
			//$cartProducts->subTotal=$subTotal;
        $pluswallet = Wallet::where('user_id', Auth::user()->id)
            ->where('status', 'Active')
            ->where('debit_credit_type', 'PLUS')->sum('amount');

        $minuswallet = Wallet::where('user_id', Auth::user()->id)
            ->where('status', 'Active')
            ->where('debit_credit_type', 'MINUS')->sum('amount');
        if (($pluswallet - $minuswallet) > array_sum($subTotal)) {
            if (array_sum($subTotal) > 500) {
                $delivery_charge = 0;
            } else {
                if ($pincode) {
                    $delivery_charge = $pincode->delivery_charge;
                }

            }
            $wallet = (array_sum($subTotal) - $this->getDiscount(array_sum($subTotal))) + $delivery_charge;
        } else {
            $wallet = $pluswallet - $minuswallet;
        }


        return response()->json([
            'success' => true, 'statusCode' => 200,
            'message' => 'Cart', 'cart' => $cartProducts, 'coupon' => $coupon, 'wallet' => $wallet, 'pincode' => $pincode
        ]);}
    }

    public static function getDiscount($total_amount)
    {
        $discount_amount = 0;
        $cart = Cart::where('user_id', Auth::user()->id)->first();
        if ($cart) {
            $couponcode = Coupon::find($cart->coupon_id);
            if ($couponcode) {
                if ($couponcode->discount_type == 'Percentage') {
                    $discount_amount = ($total_amount * $couponcode->discount_amount) / 100;
                    $payable_amount = $total_amount - $discount_amount;
                }
                if ($couponcode->discount_type == 'Flat') {
                    $discount_amount = $couponcode->discount_amount;
                    $payable_amount = $total_amount - $discount_amount;
                }
                $discount_amount = round($discount_amount);
                $discount_type = $couponcode->discount_type;
                $payable_amount = round($payable_amount);
            }
        }

        return ($discount_amount);
    }

// add in wishlist
    public
    function addWishList(Request $request)
    {
        $wishList = new Wishlist();
        // $wishList->session_id = $request->session_id;
        $wishList->product_id = $request->product_id;
        $wishList->user_id = Auth::user()->id;
        $wishList->save();
        return response()->json(['success' => true, 'statusCode' => 200, 'message' => 'Successfully Posted Wish list Product', 'wishlist' => $wishList]);
    }

//view wishlist
    public
    function viewWishlist()
    {
        $wishlists = Wishlist::where('user_id', Auth::user()->id)->get();
        foreach ($wishlists as $wishlist) {
            $totalReviews = [];
            $product = Product::find($wishlist->product_id);
            $reviews = Review::where('product_id', $product->id)->get();
            $reviewCount = count($reviews);
            $reviewList = Review::where('product_id', $product->id)->pluck('review');
            if ($reviewCount != 0) {
                $product->reviewList = $reviewList;
            }
            foreach ($reviews as $review) {
                $totalReviews[] = $review->rating;
            }
            if ($reviewCount == 0) {
                $reviewCount = 1;
            }
            $data = round(array_sum($totalReviews) / $reviewCount);
            $product->ratingAverage = $data;
            $productImages = ProductImage::where('product_id', $product->id)->get();
            $product->images = $productImages;
            $wishlist->product_id = $product;
        }
        return response()->json([
            'success' => true, 'statusCode' => 200,
            'message' => 'Wishlist', 'wishlist' => $wishlists
        ]);

    }

//delete wishlist
    public
    function deleteWishlist($id)
    {
        $wishList = Wishlist::find($id);
        $wishList->delete();
        return response()->json(['success' => true, 'statusCode' => 200, 'message' => 'Successfully Deleted Wish List Product']);
    }
	//cartCount
	public function cartCount(){
	$cart=Cart::where('user_id',Auth::id())->get();
		$count=count($cart);
		return response()->json(['success'=>true,'statusCode'=>200,'message'=>'cart count','count'=>$count]);
	}
//wishlistCount
	public function listCount(){
	$list=Wishlist::where('user_id',Auth::id())->get();
		$count=count($list);
		return response()->json(['success'=>true,'statusCode'=>200,'message'=>'wishlist count','count'=>$count]);
	}

}
