<?php

namespace App\Http\Controllers\Api;

use App\Models\Contact;
use App\Models\Faq;
use App\Models\Order;
use App\Models\OrderList;
use App\Models\Product;
use App\Models\Review;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ReviewController extends Controller
{
    //contact
    public function addContact(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|string',
            'email' => 'required|email|string',
            'subject' => 'required|string',
            'message' => 'required|string',
            'phone' => 'required',
        ]);

        $contact = new Contact;
        $contact->name = $request->name;
        $contact->email = $request->email;
        $contact->subject = $request->subject;
        $contact->message = $request->message;
        $contact->phone = $request->phone;
        $contact->save();
        return response()->json(['success' => true, 'statusCode' => 200, 'message' => 'Added Contact Information ', 'contact' => $contact]);
    }

    //post reviews
    public function postReviews(Request $request, $pid)
    {
        $user = Auth::user()->id;
        $count = 0;
        $product = Product::find($pid);
        $orders = Order::where('user_id', $user)->get();
        foreach ($orders as $order) {
            $list = OrderList::where('product_id', $product)->where('order_id', $order->id)->get();
            $count = count($list);
        }
        if ($count == 0) {
            return response()->json([
                'success' => false, 'message' => 'sorry,You Cannot Post Reviews '
            ]);
        } else {
            $review = new Review;
            $review->user_id = $user;
            $review->product_id = $pid;
            $review->review = $request->review;
            $review->rating = $request->rating;
            $review->save();
            return response()->json([
                'success' => true, 'statusCode' => 200, 'message' => 'Thank you For Review ', 'review' => $review
            ]);
        }

    }


    //faq
    public function viewFaqs()
    {
        $faqs = Faq::all();
        return response()->json([
            'success' => true, 'statusCode' => 200, 'message' => 'FAQS', 'faqs' => $faqs
        ]);
    }
}
