<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Auth;
use Illuminate\Http\Request;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        //dd($data);
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'phone' => ['required', 'string', 'min:10','max:10', 'unique:users,phone,'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
            'state_id' => ['required', 'string', 'max:255'],
            'city' => ['required', 'string', 'max:255'],
            'pincode' => ['required', 'string', 'min:6','max:6',],
            'address' => ['required', 'string', 'max:255'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(array $data)
    {
        return User::create([ 
            'name' => $data['name'],
            'phone' => $data['phone'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
            'role_id' => 2,
            'state_id' => $data['state_id'],
            'city' => $data['city'],
            'pincode' => $data['pincode'],
            'address' => $data['address'],
        ]);
    }

    public function checkEmail(Request $request)
    {
      $arr = array();
      $checkEmail = User::where('email',$request->email)->first();
      if ($checkEmail) {
        $arr['email_message'] = "Email Already Taken";
      }
      else{
        $arr['email_message'] = 1;
      }
      return response()->json($arr);
    }

    public function checkPhone(Request $request)
    {
      $arr = array();
      if (isset($request->phone) && $request->phone !='') {
          $checkPhone = User::where('phone',$request->phone)->first();
          if ($checkPhone) {
            $arr['email_phone'] = "Phone Number Already Taken";
          }
          else{
            $arr['email_phone'] = 1;
          }
      }
      
      return response()->json($arr);
    }
}
