<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Session;
use App\Models\Cart;
use Auth;
use App\Models\Coupon;
use App\Models\Pincode;
use App\Models\Wishlist;
use App\Models\Wallet;
use App\Models\State;
use App\Models\Brand;

class CartController extends Controller
{
    public function index(Request $request)
    {
        $delivery_charge = 0;
        $subtotal = [];
        $pincode = "";
        $title = "Cart | Nakoda";
        $desc = "Cart | Nakoda";
        $session_id = Session::getId();
        $carts = Cart::where('session_id',$session_id)->get();
        $isCouponCheck = Cart::where('session_id',$session_id)->wherenotNull('coupon_id')->first();
        $checkpincode = Cart::where('session_id',$session_id)->wherenotNull('pincode_id')->first();

        if ($checkpincode) {
            $isPincode = 1;
            $pincode = Pincode::find($checkpincode->pincode_id);
        }
        else{
            $isPincode = 0;
        }

        if ($isCouponCheck) {
            $isCoupon = 1;
            $coupon = Coupon::find($isCouponCheck->coupon_id);
        }
        else{
            $isCoupon = 0;
            $coupon = '';
        }
         if (Auth::check()) {
            foreach($carts as $cart){
                $subtotal[] = $cart->product->selling_price*$cart->quantity;
            }
            $pluswallet = Wallet::where('user_id',Auth::user()->id)
            ->where('status','Active')
            ->where('debit_credit_type','PLUS')->sum('amount');

            $minuswallet = Wallet::where('user_id',Auth::user()->id)
            ->where('status','Active')
            ->where('debit_credit_type','MINUS')->sum('amount');
            if (($pluswallet - $minuswallet) > array_sum($subtotal)) {
                if(array_sum($subtotal) > 500){
                    $delivery_charge = 0;
                }
                else{
                    if ($pincode) {
                        $delivery_charge = $pincode->delivery_charge;
                    }
                    
                }
                $wallet = (array_sum($subtotal) - $this->getCouponDiscount(array_sum($subtotal))) + $delivery_charge;
            }
            else{
                $wallet = $pluswallet - $minuswallet;
            }
        }
        else{
            $wallet = 0;
        }
		$brands = Brand::where('status','Active')->orderBy('id','ASC')->get();
        return view('cart',compact('carts','isCoupon','coupon','isPincode','pincode','title','desc','wallet','brands'));
    }

    public function increaseCartQuantity(Request $request,$id,$session_id)
    {
       $cart = Cart::where('session_id',$session_id)->where('id',$id)->first();
       if ($cart) {
           $cart->quantity = $cart->quantity+1;
           $cart->save();
           return back()->with('flash_success', 'Cart Updated');
       }
       else{
            abort(404);
       }
    }

    public function decreaseCartQuantity(Request $request,$id,$session_id)
    {
       $cart = Cart::where('session_id',$session_id)->where('id',$id)->first();
       if ($cart) {
        if ($cart->quantity == 1) {
            $cart->delete();
            return back();
        }
        else{
            $cart->quantity = $cart->quantity-1;
            $cart->save();
        }
        $cart_arrs = Cart::where('session_id',Session::getId())->get();
        foreach ($cart_arrs as $cart_arr) {
            $subtotal[] = $cart_arr->product->selling_price*$cart_arr->quantity;
        }
        $coupon = Coupon::where('id',$cart->coupon_id)
        ->where('validity_till','>=',date("Y-m-d"))
        ->where('minimum_order','<=',array_sum($subtotal))
        ->where('status','Active')
        ->first();

        if (!$coupon) {
            foreach ($cart_arrs as $cart_arr) {
                $cart_arr->coupon_id = NULL;
                $cart_arr->save();
            }
        }
        return back()->with('flash_success', 'Cart Updated');
       }
       else{
            abort(404);
       }
    }

    public function addToCart(Request $request)
    {
        $cart = Cart::where('session_id',Session::getId())
        ->where('product_id',$request->product_id)
        ->first();
        if ($cart) {
            $cart->quantity = $cart->quantity+1;
        }
        else{
            $cart = new Cart;
            $cart->session_id = Session::getId();
            if (!Auth::check()) {
                $cart->user_id = 0;
            }
            else{
                $cart->user_id = Auth::user()->id;
            }
            $cart->product_id = $request->product_id;
            $cart->quantity = 1;
        }
        $cart->save();
        $htmlCart = view('includes.cart')->render(); 
        return response()->json(['msg' => 'Product Added successfully', 'data' => $htmlCart]);
    }

    public function addtoCartWishlist(Request $request,$id)
    {
        $wishlist = Wishlist::where('session_id',Session::getId())->where('id',$id)->first();
        if ($wishlist) {
            $cart = Cart::where('session_id',Session::getId())
            ->where('product_id',$wishlist->product_id)
            ->first();
            if ($cart) {
            }
            else{
                $cart = new Cart;
                $cart->session_id = Session::getId();
                if (!Auth::check()) {
                    $cart->user_id = 0;
                }
                else{
                    $cart->user_id = Auth::user()->id;
                }
                $cart->quantity = 1;
                $cart->product_id = $wishlist->product_id;
                $cart->save();
            }
            
            $wishlist->delete();
            return back()->with('flash_success', 'Added to Cart');
        }
        else{
            abort(404);
        }
    }

    public function addToWishList(Request $request)
    {
        $wishlist = Wishlist::where('session_id',Session::getId())
        ->where('product_id',$request->product_id)->first();
        
        if ($wishlist) {
            //$cart->quantity = $cart->quantity+1;
        }
        else{
            $wishlist = new Wishlist;
            $wishlist->session_id = Session::getId();
            $wishlist->product_id = $request->product_id;
            if (!Auth::check()) {
                $wishlist->user_id = 0;
            }
            else{
                $wishlist->user_id = Auth::user()->id;
            }
        }
        $wishlist->save();
        $wishlist_counter = Wishlist::where('session_id',Session::getId())->count('id');
        return response()->json(['msg' => 'Product Added successfully','wishlist_counter' => $wishlist_counter]);
    }

    public function deleteWishList(Request $request,$id,$session_id)
    {
       $cart = Wishlist::where('session_id',$session_id)->where('id',$id)->first();
       if ($cart) {
           $cart->delete();
           return back()->with('flash_success', 'Removed from Wishlist');
       }
       else{
            abort(404);
       }
    }

    public function deleteCartQuantity(Request $request,$id,$session_id)
    {
       $cart = Cart::where('session_id',$session_id)->where('id',$id)->first();
       if ($cart) {
           $cart->delete();
           return back()->with('flash_success', 'Cart Updated');
       }
       else{
            abort(404);
       }
    }

    public function applyCoupon(Request $request)
    {
        $this->validate($request, [
            'couponcode' => 'required|string',
        ]);

        $carts = Cart::where('session_id',Session::getId())->get();

        foreach ($carts as $cart) {
            $subtotal[] = $cart->product->selling_price*$cart->quantity;
        }
        $couponcode = Coupon::where('coupon_code',$request->couponcode)
        ->where('validity_till','>=',date("Y-m-d"))
        ->where('minimum_order','<=',array_sum($subtotal))
        ->where('status','Active')
        ->first();

        if ($couponcode) {
            if (isset($couponcode->id) && $couponcode->coupon_code === $request->couponcode) {
                Cart::where('session_id',Session::getId())
                ->update(['coupon_id'=>$couponcode->id]);
                return back()->with('coupon_success', 'Coupon Applied');
            }
            else
            {
                return back()->with('coupon_danger', 'Not a valid Coupon');
            }
        }
        else
        {
            return back()->with('coupon_danger', 'Not a valid Coupon');
        }
    }

    public static function getCouponDiscount($total_amount)
    {
        $discount_amount = 0;
        $cart = Cart::where('session_id',Session::getId())->first();
        if ($cart) {
            $couponcode = Coupon::find($cart->coupon_id);
            if ($couponcode) {
                if ($couponcode->discount_type == 'Percentage') {
                    $discount_amount = ($total_amount * $couponcode->discount_amount)/100;
                    $payable_amount = $total_amount - $discount_amount;
                }
                if ($couponcode->discount_type == 'Flat') {
                    $discount_amount = $couponcode->discount_amount;
                    $payable_amount = $total_amount - $discount_amount;
                }
                $discount_amount = round($discount_amount);
                $discount_type = $couponcode->discount_type;
                $payable_amount = round($payable_amount);
            }
        }
        
        return $discount_amount;
    }

     public function removeCoupon(Request $request,$session_id)
     {
        Cart::where('session_id',Session::getId())
                ->update(['coupon_id'=>NULL]);
        return back()->with('coupon_removed', 'Coupon Removed');
     }

    public function checkPincode(Request $request)
    {
        $this->validate($request, [
            'pincode' => 'required|string',
        ]);

        $pincode = Pincode::where('pincode',$request->pincode)->first();
        if ($pincode) {
            Cart::where('session_id',Session::getId())
                ->update(['pincode_id'=>$pincode->id]);
            return back()->with('pincode_found', 'Avilable');
        }
        else{
            return back()->with('pincode_notfound', 'Given Pincode Not Avilable');
        }
    }

    public function delPincode(Request $request,$session_id)
    {
        Cart::where('session_id',Session::getId())
                ->update(['pincode_id'=>NULL]);
        return back()->with('pincode_found', 'Pincode Removed');
    }

    public function showCheckout(Request $request)
    {
        $title = "Checkout | Nakoda";
        $desc = "Checkout | Nakoda";
        $states = State::get();
        $session_id = Session::getId();
        $carts = Cart::where('session_id',$session_id)->get();
        $isCouponCheck = Cart::where('session_id',$session_id)->wherenotNull('coupon_id')->first();
        $checkpincode = Cart::where('session_id',$session_id)->wherenotNull('pincode_id')->first();

        if ($checkpincode) {
            $isPincode = 1;
            $pincode = Pincode::find($checkpincode->pincode_id);
        }
        else{
            $isPincode = 0;
        }

        if ($isCouponCheck) {
            $isCoupon = 1;
            $coupon = Coupon::find($isCouponCheck->coupon_id);
        }
        else{
            $isCoupon = 0;
            $coupon = '';
        }
        foreach($carts as $cart){
            $subtotal[] = $cart->product->selling_price*$cart->quantity;
        }
        if (Auth::check()) {
            $pluswallet = Wallet::where('user_id',Auth::user()->id)
            ->where('status','Active')
            ->where('debit_credit_type','PLUS')->sum('amount');

            $minuswallet = Wallet::where('user_id',Auth::user()->id)
            ->where('status','Active')
            ->where('debit_credit_type','MINUS')->sum('amount');
            if (($pluswallet - $minuswallet) > array_sum($subtotal)) {
                if(array_sum($subtotal) > 500){
                    $delivery_charge = 0;
                }
                else{
                    $delivery_charge = $pincode->delivery_charge;
                }
                $wallet = (array_sum($subtotal) - $this->getCouponDiscount(array_sum($subtotal))) + $delivery_charge;
            }
            else{
                $wallet = $pluswallet - $minuswallet;
            }
        }
        else{
            $wallet = 0;
        }
        if ($isPincode == 1) {
            if (Auth::check()) {
                $total_payable_amount = $this->getSubTotalPrice(\Session::getId(),$this->getCouponDiscount(array_sum($subtotal)),$wallet );
            }
            else{
                $total_payable_amount = $this->getSubTotalPrice(\Session::getId(),$this->getCouponDiscount(array_sum($subtotal)),$wallet );
            }
            return view('checkout',compact('carts','isCoupon','coupon','isPincode','pincode','title','desc','wallet','states','total_payable_amount'));
        }
        else{
            return redirect('cart')->with('pinode_not_filled', 'Please Enter Pincode First to proceed to checkout');
        }
        
    }

    public static function getSubTotalPrice($session_id,$discount_amount,$wallet)
    {
        $carts = Cart::where('session_id',Session::getId())->get();
        foreach ($carts as $cart) {
            $subtotal[] = $cart->product->selling_price*$cart->quantity;
        }
        $cartfirst = Cart::where('session_id',Session::getId())->first();
        $pincode = Pincode::find($cartfirst->pincode_id);
        if ($pincode && array_sum($subtotal) < 500) {
            $payable_amount = (array_sum($subtotal) - $discount_amount - $wallet) + $pincode->delivery_charge;
        } 
        else{
            $payable_amount = array_sum($subtotal) - $discount_amount - $wallet;
        }
        return $payable_amount;  
    }
}
