<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Banner;
use App\Models\Product;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $title = "Home | Naaribotitue";
        $desc = "Home | Naaribotitue";
        $products = Product::where('status','Active')->orderBy('id','desc')->get();
        $banners = Banner::where('status','Active')->orderBy('id','ASC')->get();
        $categories = Category::whereNull('parent_id')->where('status','Active')->orderBy('id','ASC')->get();
        return view('home',compact('categories','banners','products','title','desc'));
    }
}
