<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Facades\Validator;
use Hash;
use Auth;
use Carbon\Carbon;
use Twilio\Rest\Client;
use Mail;
use App\Mail\OrderMail;
use Softon\Indipay\Facades\Indipay;
use Session;
use App\Models\Cart;
use App\Models\OrderList;
use App\Models\Order;
use App\Models\Pincode;
use App\Models\Wallet;
use App\Models\State;
use DB;

class PaymentController extends Controller
{
    public function thankyou(Request $request)
    {
      $title = "Thank You | Nakoda";
      $desc = "Thank You | Nakoda";
    	return view('thankyou',compact('title','desc'));
    }
	
	 public function addToWallet(Request $request)
    {
          //  return $request;
//        $wallet = new Wallet;
//        $wallet->user_id = Auth::user()->id;
//        $wallet->amount = $request->amount;
//        $wallet->status = "Active";
//        $wallet->debit_credit_type = "PLUS";
//        $wallet->payment_id = $request->razorpay_payment_id;
//        $wallet->save();
        request()->validate([
            'money' => ['required'] 
        ]);

        $amount = request("money");
        $user = User::find(Auth::id());

        $merchant_key = "9ZVZ7gaI";
        $txnid = uniqid();
        $totalCost = $amount;
        $firstName = $user->name;
        $email = $user->email;
        $SALT = "Poxz98fRZj";
        $lastname = 'abcd';
        $user_id = Auth::id();
        $state = $user->state;
        $phone = $user->phone;
        $zipcode = $user->pincode;
        $address1 = $user->city;
        $address2 = $user->street;


        $hash = '';
        $hash_string = $merchant_key . "|" . $txnid . "|" . $totalCost . "|" . "productinfo|" . $firstName . "|" . $email . "|||||||||||" . $SALT;
        $hash = strtolower(hash('sha512', $hash_string));


        $parameters = [
            'txnid' => $txnid,
            'amount' => $amount,
            'email' => $user->email,
            'key' => "9ZVZ7gaI",
            'furl' => url('/') . '/payumoney/response',
            'surl' => url('/') . '/payumoney/response',
            'firstname' => $user->name,
            'lastname' => $user->name,
            'phone' => $user->phone,
            'productinfo' => 'wallet_' . Auth::id(),
            'service_provider' => 'payu_paisa',
            'zipcode' => $zipcode,
            'city' => $user->city,
            'state' => $user->state,
            'country' => $user->country,
            'address1' => $address1,
            'address2' => $address1,
            'curl' => url('payu/response'),
            'hash' => $hash,

        ];

        $order = Indipay::prepare($parameters);
        return Indipay::process($order);


//        $wallets = view('includes.wallet')->render();
//        $arr = array('msg' => 'Payment successful.', 'status' => true,'wallet' => $wallets);
//        return Response()->json($arr);
    }
    public function newPaymentForm(Request $request)
    {
	    $user_email = User::where('email', $request->email)->first();
        $user_phone = User::where('phone', $request->phone)->first();
        if ($user_email) {
            return back()->with('flash_failure', 'Email Already Taken');
        } elseif ($user_phone) {
            return back()->with('flash_failure', 'Phone Already Taken');
        } elseif (strlen($request->password) < 8) {
            return back()->with('flash_failure', 'Password length should be atleast Eight');
        } elseif ($request->password !== $request->confirm_password) {
            //return $request;
            return back()->with('flash_failure', 'Password Mismatch');
        } else {

        $user = new User;
        $user->role_id = 2;
        $user->name = $request->name;
        $user->phone = $request->phone;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->state_id = $request->state;
        $user->city = $request->city;
        $user->pincode = $request->pincode;
        $user->address = $request->address;
        $user->save();
		
        $getlastId = Order::orderBy('id', 'desc')->first();
        $session_id = Session::getId();
        $carts = Cart::where('session_id', $session_id)->get();
        $getCart = Cart::where('session_id', $session_id)->first();
	 if($getCart){
        $pincode = Pincode::find($getCart->pincode_id);
        if ($getlastId) {
            $order_id = "Nakoda" . time() . $getlastId->id;
        } else {
            $order_id = "Nakoda" . time() . "1";
        }
        foreach ($carts as $cart) {
            $subtotal[] = $cart->product->selling_price * $cart->quantity;
            $orderList = new OrderList;
            $orderList->order_id = $order_id;
            $orderList->product_id = $cart->product_id;
            $orderList->mrp_price = $cart->product->mrp_price;
            $orderList->selling_price = $cart->product->selling_price;
            $orderList->quantity = $cart->quantity;
            $orderList->save();
        }
        if ($request->check_method == "Online") {
        $order = new Order;
        $order->order_id = $order_id;
        $order->user_id = $user->id;
        // $order->payment_id = $request->razorpay_payment_id;
        $order->order_price = array_sum($subtotal);
        $order->payable_price = $order->order_price-$request->coupon_amount+$request->delivery_charge;
        $order->status = "OrderPlaced";
        $order->payment_type = "online";
        $order->coupon_id = $getCart->coupon_id;
        $order->coupon_amount = $request->coupon_amount;
        $order->delivery_charge = $request->delivery_charge;
        $order->name = $request->name;
        $order->email = $request->email;
        $order->phone = $request->phone;
        $state = State::where('id', $request->state)->first();
        $order->state = $state->name;
        $order->city = $request->city;
        $order->pincode = $request->pincode;
        $order->address = $request->address;
        $order->save();
        $arr = array('msg' => 'Payment successful.', 'status' => true);
        try {
            $data = ['order_id' => $order->order_id];
            Mail::to($user->email)->send(new OrderMail($data));
        } catch (Exception $e) {
        }
        foreach ($carts as $cart) {
            $cart->delete();
        }
            Auth::login($user);
        //payumoney order create

        $merchant_key = "9ZVZ7gaI";
        $txnid = uniqid();
        $totalCost = $order->payable_price;
        $firstName = $order->name;
        $email = $order->email;
        $SALT = "Poxz98fRZj";
        $lastname = '';
        $state = $order->state;
        $phone = $request->phone;
        $zipcode = $request->pincode;
        $address1 = $request->address;
        $address2 = $request->city;

        $hash = '';
        $hash_string = $merchant_key . "|" . $txnid . "|" . $totalCost . "|" . "productinfo|" . $firstName . "|" . $email . "|||||||||||" . $SALT;
        $hash = strtolower(hash('sha512', $hash_string));


        $parameters = [
            'txnid' => $txnid,
            'order_id' => $order->order_id,
            'amount' => $totalCost,
            'email' => $email,
            'key' => "9ZVZ7gaI",
            'furl' => 'https://nakodaherbals.in/payumoney/response',
            'surl' => 'https://nakodaherbals.in/payumoney/response',
            'firstname' => $firstName,
            'lastname' => $lastname,
            'phone' => $phone,
            'productinfo' => $order->order_id,
            'service_provider' => 'payu_paisa',
            'zipcode' => $zipcode,
            'city' => $request->city,
            'state' => $state,
            'country' => $request->country,
            'address1' => $address1,
            'address2' => $address2,
            'curl' => url('payu/response'),
            'hash' => $hash,

        ];
        // return $parameters;
        $order = Indipay::prepare($parameters);
        return Indipay::process($order);
       }
        elseif($request->check_method == "Cod"){
            $order = new Order;
            $order->order_id = $order_id;
            $order->user_id = $user->id;
            // $order->payment_id = $request->razorpay_payment_id;
            $order->order_price = array_sum($subtotal);
            $order->payable_price = $order->order_price-$request->coupon_amount+$request->delivery_charge;
            $order->status = "OrderPlaced";
            $order->payment_type = "cod";
            $order->coupon_id = $getCart->coupon_id;
            $order->coupon_amount = $request->coupon_amount;
            $order->delivery_charge = $request->delivery_charge;
            $order->name = $request->name;
            $order->email = $request->email;
            $order->phone = $request->phone;
            $state = State::where('id', $request->state)->first();
            $order->state = $state->name;
            $order->city = $request->city;
            $order->pincode = $request->pincode;
            $order->address = $request->address;
            $order->save();
            
            $arr = array('msg' => 'Payment successful.', 'status' => true);
        try {
            $data = ['order_id' => $order->order_id];
            Mail::to($user->email)->send(new OrderMail($data));
        } catch (Exception $e) {
        }
            foreach ($carts as $cart) {
                $cart->delete();
            }
            Auth::login($user);
            return redirect()->to('thankyou');
        }else{
            $order = new Order;
            $order->order_id = $order_id;
            $order->user_id = $user->id;
            // $order->payment_id = $request->razorpay_payment_id;
            $order->order_price = array_sum($subtotal);
            $order->payable_price = $order->order_price - $request->coupon_amount + $request->delivery_charge;
            $order->status = "OrderPlaced";
            $order->payment_type = "wallet";
            $order->coupon_id = $getCart->coupon_id;
            $order->coupon_amount = $request->coupon_amount;
            $order->delivery_charge = $request->delivery_charge;
            $order->name = $request->name;
            $order->email = $request->email;
            $order->phone = $request->phone;
            $state = State::where('id', $request->state)->first();
            $order->state = $state->name;
            $order->city = $request->city;
            $order->pincode = $request->pincode;
            $order->address = $request->address;
            $order->save();
            $arr = array('msg' => 'Payment successful.', 'status' => true);
       try {
            $data = ['order_id' => $order->order_id];
            Mail::to($user->email)->send(new OrderMail($data));
        } catch (Exception $e) {
        }
            foreach ($carts as $cart) {
                $cart->delete();
            }
            Auth::login($user);
            return redirect()->to('thankyou');
        }
		  }else{
            return redirect()->back();
        }
		}
       // return Response()->json($arr);
    }

    public function placeOrder(Request $request)
    {
      $user = new User;
      $user->role_id = 2;
      $user->name = $request->shipping_name;
      $user->phone = $request->shipping_phone;
      $user->email = $request->shipping_email;
      $user->password = Hash::make($request->password);
      $user->state_id = $request->shipping_state;
      $user->city = $request->shipping_city;
      $user->pincode = $request->shipping_pincode;
      $user->address = $request->shipping_address;
      $user->save();

      $getlastId = Order::orderBy('id', 'desc')->first();
      $session_id = Session::getId();
      $carts = Cart::where('session_id',$session_id)->get();
      $getCart = Cart::where('session_id',$session_id)->first();
      $pincode = Pincode::find($getCart->pincode_id);
      if ($getlastId) {
        $order_id = "Nakoda".time().$getlastId->id;
      }
      else{
        $order_id = "Nakoda".time()."1";
      }
      foreach ($carts as $cart) {
        $subtotal[] = $cart->product->selling_price*$cart->quantity;
        $orderList = new OrderList;
        $orderList->order_id = $order_id;
        $orderList->product_id = $cart->product_id;
        $orderList->mrp_price = $cart->product->mrp_price;
        $orderList->selling_price = $cart->product->selling_price;
        $orderList->quantity = $cart->quantity;
        $orderList->save();
      }
      $order = new Order;
      $order->order_id = $order_id;
      $order->user_id = $user->id;
      $order->payment_id = $request->razorpay_payment_id;
      $order->order_price = array_sum($subtotal);
      $order->payable_price = $request->amount/100;
      $order->status = "OrderPlaced";
      $order->payment_type = $request->payment_type;
      $order->coupon_id = $getCart->coupon_id;
      $order->coupon_amount = $request->coupon_amount;
      $order->delivery_charge = $request->delivery_charge;
      $order->name = $request->shipping_name;
      $order->email = $request->shipping_email;
      $order->phone = $request->shipping_phone;
      $state = State::where('id',$request->shipping_state)->first();
      $order->state = $state->name;
      $order->city = $request->shipping_city;
      $order->pincode = $request->shipping_pincode;
      $order->address = $request->shipping_address;
      $order->save();
      $arr = array('msg' => 'Payment successful.', 'status' => true);
      try {
          $data = ['order_id' => $order->order_id];
          Mail::to($user->email)->send(new OrderMail($data));
      } catch (Exception $e) {
      }
      foreach ($carts as $cart) {
        $cart->delete();
      }
      Auth::login($user);
      return Response()->json($arr); 
    }
public function paymentForm(Request $request)
    {
       // dd($request->all());
        if ($request->check_method == "Online") {
            $user = User::find(Auth::user()->id);
            $getlastId = Order::orderBy('id', 'desc')->first();
            $session_id = Session::getId();
            $carts = Cart::where('session_id', $session_id)->get();
            $getCart = Cart::where('session_id', $session_id)->first();
			if($getCart){
            $pincode = Pincode::find($getCart->pincode_id);
            if ($getlastId) {
                $order_id = "Nakoda" . time() . $getlastId->id;
            } else {
                $order_id = "Nakoda" . time() . "1";
            }
            foreach ($carts as $cart) {
                $subtotal[] = $cart->product->selling_price * $cart->quantity;
                $orderList = new OrderList;
                $orderList->order_id = $order_id;
                $orderList->product_id = $cart->product_id;
                $orderList->mrp_price = $cart->product->mrp_price;
                $orderList->selling_price = $cart->product->selling_price;
                $orderList->quantity = $cart->quantity;
                $orderList->save();
            }
            $order = new Order;
            $order->order_id = $order_id;
            $order->user_id = $user->id;
            // $order->payment_id = $request->razorpay_payment_id;
            $order->order_price = array_sum($subtotal);
            $order->payable_price = $order->order_price-$request->coupon_amount+$request->delivery_charge;
            //return $order->payable_price;
            $order->status = "OrderPlaced";
            $order->payment_type = "online";
            $order->coupon_id = $getCart->coupon_id;
            $order->coupon_amount = $request->coupon_amount;
            $order->delivery_charge = $request->delivery_charge;
            if ($request->wallet_amount > 0) {
                $order->wallet_amount = $request->wallet_amount;
                $ref_wallet = new Wallet;
                $ref_wallet->user_id = Auth::user()->id;
                $ref_wallet->amount = $request->wallet_amount;
                $ref_wallet->status = "Active";
                $ref_wallet->debit_credit_type = "MINUS";
                $ref_wallet->save();
            }
            $order->name = $request->name;
            $order->email = $request->email;
            $order->phone = $request->phone;
            $order->state = $request->state_id;
            $order->city = $request->city;
            $order->pincode = $request->pincode;
            $order->address = $request->address;
            $order->save();
              $arr = array('msg' => 'Payment successful.', 'status' => true);
            try {
                $data = ['order_id' => $order->order_id];
                Mail::to($user->email)->send(new OrderMail($data));
            } catch (Exception $e) {
            }
            foreach ($carts as $cart) {
                $cart->delete();
            }
            //return Response()->json($arr);
            //payumoney order create

            $merchant_key = "9ZVZ7gaI";
            $txnid = uniqid();
            $totalCost = $order->payable_price;
            $firstName = $order->name;
            $email = $order->email;
            $SALT = "Poxz98fRZj";
            $lastname = '';
            $state = $order->state;
            $phone = $request->phone;
            $zipcode = $request->pincode;
            $address1 = $request->address;
            $address2 = $request->city;

            $hash = '';
            $hash_string = $merchant_key . "|" . $txnid . "|" . $totalCost . "|" . "productinfo|" . $firstName . "|" . $email . "|||||||||||" . $SALT;
            $hash = strtolower(hash('sha512', $hash_string));


            $parameters = [
                'txnid' => $txnid,
                'order_id' => $order->order_id,
                'amount' => $totalCost,
                'email' => $email,
                'key' => "9ZVZ7gaI",
                'furl' => 'https://nakodaherbals.in/payumoney/response',
                'surl' => 'https://nakodaherbals.in/payumoney/response',
                'firstname' => $firstName,
                'lastname' => $lastname,
                'phone' => $phone,
                'productinfo' => $order->order_id,
                'service_provider' => 'payu_paisa',
                'zipcode' => $zipcode,
                'city' => $request->city,
                'state' => $state,
                'country' => $request->country,
                'address1' => $address1,
                'address2' => $address2,
                'curl' => url('payu/response'),
                'hash' => $hash,

            ];
           // return $parameters;
            $order = Indipay::prepare($parameters);
            return Indipay::process($order);
			}else{
		return redirect()->back();
		}
        } elseif($request->check_method == "Cod") {
            $user = User::find(Auth::user()->id);
            $getlastId = Order::orderBy('id', 'desc')->first();
            $session_id = Session::getId();
            $carts = Cart::where('session_id', $session_id)->get();
            $getCart = Cart::where('session_id', $session_id)->first();
            $pincode = Pincode::find($getCart->pincode_id);
            if ($getlastId) {
                $order_id = "Nakoda" . time() . $getlastId->id;
            } else {
                $order_id = "Nakoda" . time() . "1";
            }
            foreach ($carts as $cart) {
                $subtotal[] = $cart->product->selling_price * $cart->quantity;
                $orderList = new OrderList;
                $orderList->order_id = $order_id;
                $orderList->product_id = $cart->product_id;
                $orderList->mrp_price = $cart->product->mrp_price;
                $orderList->selling_price = $cart->product->selling_price;
                $orderList->quantity = $cart->quantity;
                $orderList->save();
            }
            $order = new Order;
            $order->order_id = $order_id;
            $order->user_id = $user->id;
            //$order->payment_id = $request->razorpay_payment_id;
            $order->order_price = array_sum($subtotal);
            $order->payable_price = $order->order_price-$request->coupon_amount+$request->delivery_charge;
            $order->status = "OrderPlaced";
            $order->payment_type = "cod";
            $order->coupon_id = $getCart->coupon_id;
            $order->coupon_amount = $request->coupon_amount;
            $order->delivery_charge = $request->delivery_charge;
            if ($request->wallet_amount > 0) {
                $order->wallet_amount = $request->wallet_amount;
                $ref_wallet = new Wallet;
                $ref_wallet->user_id = Auth::user()->id;
                $ref_wallet->amount = $request->wallet_amount;
                $ref_wallet->status = "Active";
                $ref_wallet->debit_credit_type = "MINUS";
                $ref_wallet->save();
            }
            $order->name = $request->name;
            $order->email = $request->email;
            $order->phone = $request->phone;
            $order->state = $request->state_id;
            $order->city = $request->city;
            $order->pincode = $request->pincode;
            $order->address = $request->address;
            $order->save();
            //$arr = array('msg' => 'Payment successful.', 'status' => true);
            try {
                $data = ['order_id' => $order->order_id];
                Mail::to($user->email)->send(new OrderMail($data));
            } catch (Exception $e) {
            }
            foreach ($carts as $cart) {
                $cart->delete();
            }
            return redirect()->to('thankyou');
        }else{
            $user = User::find(Auth::user()->id);
            $getlastId = Order::orderBy('id', 'desc')->first();
            $session_id = Session::getId();
            $carts = Cart::where('session_id', $session_id)->get();
            $getCart = Cart::where('session_id', $session_id)->first();
            $pincode = Pincode::find($getCart->pincode_id);
            if ($getlastId) {
                $order_id = "Nakoda" . time() . $getlastId->id;
            } else {
                $order_id = "Nakoda" . time() . "1";
            }
            foreach ($carts as $cart) {
                $subtotal[] = $cart->product->selling_price * $cart->quantity;
                $orderList = new OrderList;
                $orderList->order_id = $order_id;
                $orderList->product_id = $cart->product_id;
                $orderList->mrp_price = $cart->product->mrp_price;
                $orderList->selling_price = $cart->product->selling_price;
                $orderList->quantity = $cart->quantity;
                $orderList->save();
            }
            $order = new Order;
            $order->order_id = $order_id;
            $order->user_id = $user->id;
            //$order->payment_id = $request->razorpay_payment_id;
            $order->order_price = array_sum($subtotal);
            $order->payable_price = $order->order_price - $request->coupon_amount + $request->delivery_charge;
            $order->status = "OrderPlaced";
            $order->payment_type = "wallet";
            $order->coupon_id = $getCart->coupon_id;
            $order->coupon_amount = $request->coupon_amount;
            $order->delivery_charge = $request->delivery_charge;
            if ($request->wallet_amount > 0) {
                $order->wallet_amount = $request->wallet_amount;
                $ref_wallet = new Wallet;
                $ref_wallet->user_id = Auth::user()->id;
                $ref_wallet->amount = $request->wallet_amount;
                $ref_wallet->status = "Active";
                $ref_wallet->debit_credit_type = "MINUS";
                $ref_wallet->save();
            }
            $order->name = $request->name;
            $order->email = $request->email;
            $order->phone = $request->phone;
            $order->state = $request->state_id;
            $order->city = $request->city;
            $order->pincode = $request->pincode;
            $order->address = $request->address;
            $order->save();
            //$arr = array('msg' => 'Payment successful.', 'status' => true);
            try {
                $data = ['order_id' => $order->order_id];
                Mail::to($user->email)->send(new OrderMail($data));
            } catch (Exception $e) {
            }
            foreach ($carts as $cart) {
                $cart->delete();
            }
            return redirect()->to('thankyou');
        }
		
			
    }
	     public function response(Request $request)
    {
        $response = Indipay::response($request);

        if ($response['status'] == "success" && $response['unmappedstatus'] == "captured") {
            if (str_contains($response['productinfo'], 'wallet')) {
                $get_user = explode("_", $response['productinfo']);
                $user_info = User::find($get_user[1]);
                Auth::login($user_info);
                $user_amt = $user_info->wallet_amount + $response['amount'];
                $wallet = new Wallet;
                $wallet->user_id = Auth::user()->id;
                $wallet->amount = $response['amount'];
                $wallet->status = "Active";
                $wallet->debit_credit_type = "PLUS";
//        $wallet->payment_id = $request->razorpay_payment_id;
                $wallet->save();

//                $wallets = view('includes.wallet')->render();
//                $arr = array('msg' => 'Wallet added successfully', 'status' => true, $wallets);
//                return Response()->json($arr);
                return view("wallet_success");
            } else {


                return view("order_placed");

            }




        } else {
            if (str_contains($response['productinfo'], 'wallet')) {
            return view('order_rejected');
            }else{
                //return $response;
                $lists=OrderList::where('order_id',$response['productinfo'])->get();
                foreach ($lists as $list){
                    $list->delete();
                }
                $order = Order::where('order_id',$response['productinfo'])->delete();


                return view('order_rejected');
            }
        }
    }
    public function oldPlaceOrder(Request $request)
    {

      $user = User::find(Auth::user()->id);
      $getlastId = Order::orderBy('id', 'desc')->first();
      $session_id = Session::getId();
      $carts = Cart::where('session_id',$session_id)->get();
      $getCart = Cart::where('session_id',$session_id)->first();
      $pincode = Pincode::find($getCart->pincode_id);
      if ($getlastId) {
        $order_id = "Nakoda".time().$getlastId->id;
      }
      else{
        $order_id = "Nakoda".time()."1";
      }
      foreach ($carts as $cart) {
        $subtotal[] = $cart->product->selling_price*$cart->quantity;
        $orderList = new OrderList;
        $orderList->order_id = $order_id;
        $orderList->product_id = $cart->product_id;
        $orderList->mrp_price = $cart->product->mrp_price;
        $orderList->selling_price = $cart->product->selling_price;
        $orderList->quantity = $cart->quantity;
        $orderList->save();
      }
      $order = new Order;
      $order->order_id = $order_id;
      $order->user_id = $user->id;
      $order->payment_id = $request->razorpay_payment_id;
      $order->order_price = array_sum($subtotal);
      $order->payable_price = $request->amount/100;
      $order->status = "OrderPlaced";
      $order->payment_type = $request->payment_type;
      $order->coupon_id = $getCart->coupon_id;
      $order->coupon_amount = $request->coupon_amount;
      $order->delivery_charge = $request->delivery_charge;
      if ($request->wallet_amount > 0) {
        $order->wallet_amount = $request->wallet_amount;
        $ref_wallet = new Wallet;
        $ref_wallet->user_id = Auth::user()->id;
        $ref_wallet->amount = $request->wallet_amount;
        $ref_wallet->status = "Active";
        $ref_wallet->debit_credit_type = "MINUS";
        $ref_wallet->save();
      }
      $order->name = $request->shipping_name;
      $order->email = $request->shipping_email;
      $order->phone = $request->shipping_phone;
      $order->state = $request->shipping_state;
      $order->city = $request->shipping_city;
      $order->pincode = $request->shipping_pincode;
      $order->address = $request->shipping_address;
      $order->save();
      $arr = array('msg' => 'Payment successful.', 'status' => true);
      try {
          $data = ['order_id' => $order->order_id];
          Mail::to($user->email)->send(new OrderMail($data));
      } catch (Exception $e) {
      }
      foreach ($carts as $cart) {
        $cart->delete();
      }
      return Response()->json($arr); 
    }
}
