<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\UserProfile;
use Auth;
use Mail;
use Hash;
use App\Mail\LoginMail;
use App\Mail\PasswordReset;
use App\Models\Order;
use App\Models\OrderList;
use App\Models\State;
use App\Models\Wallet;
use App\Models\Review;

class UserController extends Controller
{
     public function __construct()
    {
        $this->middleware('auth');
    }

    public function myprofile()
    {
        $title = "My Profile | Nakoda";
        $desc = "My Profile | Nakoda";
        $orders = Order::where('user_id',Auth::user()->id)->get();
        $states = State::get();
        $pluswallet = Wallet::where('user_id',Auth::user()->id)
            ->where('status','Active')
            ->where('debit_credit_type','PLUS')->sum('amount');

        $minuswallet = Wallet::where('user_id',Auth::user()->id)
            ->where('status','Active')
            ->where('debit_credit_type','MINUS')->sum('amount');

        $totalWallet = $pluswallet - $minuswallet;
    	return view('user.myprofile',compact('orders','title','desc','states','totalWallet'));
    }

    public function addToWallet(Request $request)
    {
        $wallet = new Wallet;
        $wallet->user_id = Auth::user()->id;
        $wallet->amount = $request->amount;
        $wallet->status = "Active";
        $wallet->debit_credit_type = "PLUS";
        $wallet->payment_id = $request->razorpay_payment_id;
        $wallet->save();
        $wallets = view('includes.wallet')->render();
        $arr = array('msg' => 'Payment successful.', 'status' => true,'wallet' => $wallets);
        return Response()->json($arr); 
    }

    public function updateprofile(Request $request)
    {
        $user = User::find(Auth::user()->id);
    	$this->validate($request, [
            'name' => 'required|string',
            'email' => 'required|unique:users,email,'.$user->id,
            'phone' => 'required|unique:users,phone,'.$user->id,
            'address' => 'required|string',
            'state_id' => 'required|string',
            'city' => 'required|string',
            'pincode' => 'required|string',
        ]);        
        $user->name = $request->name;
        $user->email = $request->email;
        $user->phone = $request->phone;
        $user->address = $request->address;
        $user->state_id = $request->state_id;
        $user->city = $request->city;
        $user->pincode = $request->pincode;
        $user->save();
        return redirect('my-account#edit-profile')->with('flash_success', 'Profile Updated');
    }


    public function orderDetails(Request $request)
    {
        $order = Order::where('order_id',$request->order_id)->first();
        if ($order) {
            $orderitems = OrderList::where('order_id',$request->order_id)->get();
            return view('user.order-details',compact('order','orderitems'));
        }
        else{
            abort(404);
        }
    }

    public function updatePassword(Request $request)
    {
        $this->validate($request, [
            'password' => 'required',
            'confirm_password' => 'required',
        ]);

        if ($request->password != $request->confirm_password) {
            return back()->with('flash_danger', 'Password and Confirm Password Must be same!');
        }
        else{
            $user = User::find(Auth::user()->id);
            $user->password = bcrypt($request->password);
            $user->save();
            return back()->with('flash_success', 'Password Changed');
        }
    }

    public function postReview(Request $request)
    {
        $review = new Review;
        $review->user_id = auth()->id();
        $review->rating = $request->rating;
        $review->review = $request->review;
        $review->product_id = $request->product_id;
        $review->save();
        return back()->with('flash_success_review', 'Review Added');
    }
}
