<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Contact;
use App\Models\Category;
use App\Models\Banner;
use App\Models\Product;
use App\Models\ProductImage;
use App\Models\Wishlist;
use App\Models\Brand;
use Session;
use App\Models\Faq;
use DB;
use Auth;
use App\Models\Order;
use App\Models\Review;

class WelcomeController extends Controller
{

    public function saveContact(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|string',
            'email' => 'required|email|string',
            'subject' => 'required|string',
            'message' => 'required|string',
            'phone' => 'required',
        ]);

        $contact = new Contact;
        $contact->name = $request->name;
        $contact->email = $request->email;
        $contact->subject = $request->subject;
        $contact->message = $request->message;
        $contact->phone = $request->phone;
        $contact->save();
        return back()->with('flash_success_conact', 'Thank You We will get back to you');
    }

    public function shopCategory(Request $request,$slug)
    {

        $category = Category::whereNull('parent_id')->where('slug',$slug)->where('status','Active')->first();
        if ($category) {
            $reports_tbl = Product::where('status','Active')->where('category_id',$category->id);
            $total_categories = Category::whereNull('parent_id')->where('status','Active')->orderBy('id','ASC')->get();
            if (isset($request->price) && $request->price != '') {
                $price = (explode("-",$request->price));
                $reports_tbl->whereBetween('selling_price', [$price[0], $price[1]]);
            }
            if (isset($request->filter) && $request->filter=="low-to-high" && $request->price != 'none') {
                $reports_tbl->orderBy('selling_price','ASC');
            }
            if (isset($request->filter) && $request->filter=="high-to-low" && $request->price != 'none') {
                $reports_tbl->orderBy('selling_price','DESC');
            }
            if (isset($request->filter) && $request->filter=="old-to-new" && $request->price != 'none') {
                $reports_tbl->orderBy('id','DESC');
            }
            if (isset($request->filter) && $request->filter=="high-to-low" && $request->price != 'none') {
                $reports_tbl->orderBy('id','ASC');
            }
            $products = $reports_tbl->paginate(21);
            $new_products = Product::where('status','Active')->where('product_type','NewProducts')->orderBy('id','desc')->get();
			$brands = Brand::where('status','Active')->orderBy('id','ASC')->get();
            $title = $category->name;
            $desc = $category->name;
            return view('listing.category',compact('products','category','title','desc','total_categories','new_products','brands'));
        }
        else{
            abort(404);
        }
        
    }

    public function shopsubCategory(Request $request,$cat,$sub)
    {
        $category = Category::wherenotNull('parent_id')->where('slug',$sub)->where('status','Active')->first();
        if ($category) {
            $reports_tbl = Product::where('status','Active')->where('subcategory_id',$category->id);
            $total_categories = Category::whereNull('parent_id')->where('status','Active')->orderBy('id','ASC')->get();
            if (isset($request->price) && $request->price != '') {
                $price = (explode("-",$request->price));
                $reports_tbl->whereBetween('selling_price', [$price[0], $price[1]]);
            }
            if (isset($request->filter) && $request->filter=="low-to-high" && $request->price != 'none') {
                $reports_tbl->orderBy('selling_price','ASC');
            }
            if (isset($request->filter) && $request->filter=="high-to-low" && $request->price != 'none') {
                $reports_tbl->orderBy('selling_price','DESC');
            }
            if (isset($request->filter) && $request->filter=="old-to-new" && $request->price != 'none') {
                $reports_tbl->orderBy('id','DESC');
            }
            if (isset($request->filter) && $request->filter=="high-to-low" && $request->price != 'none') {
                $reports_tbl->orderBy('id','ASC');
            }
            $products = $reports_tbl->paginate(21);
            $new_products = Product::where('status','Active')->where('product_type','NewProducts')->orderBy('id','desc')->get();
			$brands = Brand::where('status','Active')->orderBy('id','ASC')->get();
            $title = $category->name;
            $desc = $category->name;
            return view('listing.category',compact('products','category','title','desc','total_categories','new_products','brands'));
        }
        else{
            abort(404);
        }
        
    }

    public function shopBrand(Request $request,$slug){
        $brand = Brand::where('slug',$slug)->where('status','Active')->first();
        if ($brand) {
            $reports_tbl = Product::where('status','Active')->where('brand_id',$brand->id);
            $total_categories = Category::whereNull('parent_id')->where('status','Active')->orderBy('id','ASC')->get();
            if (isset($request->price) && $request->price != '') {
                $price = (explode("-",$request->price));
                $reports_tbl->whereBetween('selling_price', [$price[0], $price[1]]);
            }
            if (isset($request->filter) && $request->filter=="low-to-high" && $request->price != 'none') {
                $reports_tbl->orderBy('selling_price','ASC');
            }
            if (isset($request->filter) && $request->filter=="high-to-low" && $request->price != 'none') {
                $reports_tbl->orderBy('selling_price','DESC');
            }
            if (isset($request->filter) && $request->filter=="old-to-new" && $request->price != 'none') {
                $reports_tbl->orderBy('id','DESC');
            }
            if (isset($request->filter) && $request->filter=="high-to-low" && $request->price != 'none') {
                $reports_tbl->orderBy('id','ASC');
            }
            $products = $reports_tbl->paginate(21);
            $new_products = Product::where('status','Active')->where('product_type','NewProducts')->orderBy('id','desc')->get();
            $title = $brand->name;
            $desc = $brand->name;
            return view('listing.brand',compact('products','brand','title','desc','total_categories','new_products'));
        }
        else{
            abort(404);
        }
    }

    public function productDetail(Request $request,$slug)
    {
        $canReview = 0;
        $product = Product::where('slug',$slug)->where('status','Active')->first();
        if ($product) {
            $similar_products = Product::where('status','Active')->where('category_id',$product->category_id)->orderBy('id','desc')->get();
            $new_products = Product::where('status','Active')->where('product_type','NewProducts')->orderBy('id','desc')->get();
            $title = $product->name;
            $desc = $product->name;
            if (auth::check()) {
                $hasalready_review = Review::where('user_id',auth()->id())->first();
                foreach ($product->order_lists as $order_list) {
                    $order = Order::where('order_id',$order_list->order_id)->where('user_id',auth()->id())->first();
                    if ($order) {
                        $canReview = 1; 
                    }
                    if ($hasalready_review) {
                        $canReview = 0;
                    }
                }
            }
			$brands = Brand::where('status','Active')->orderBy('id','ASC')->get();
            
            return view('listing.product-details',compact('product','similar_products','new_products','title','desc','canReview','brands'));
        }
        else{
            abort(404);
        }
        
    }

    public function welcome()
    {
        return view('welcome');
    }

    public function fetchProducts(Request $request)
    {
        if($request->get('query'))
        {
        $query = $request->get('query');
        $searchResults = Product::where('name', 'LIKE', "%{$query}%")->get();
        $output = '<ul>';
        foreach($searchResults as $row)
        {
            $output .= '<li><a href="'.url('/').'/p/'.$row->slug.'">'.$row->name.'</a></li>';
        }
          $output .= '</ul>';
          echo $output; 
        } 
    }

    public function wishlist(Request $request)
    {
        $title = "Wishlist | Nakoda";
        $desc = "Wishlist | Nakoda";
        $session_id = Session::getId();
        $wishlists = Wishlist::where('session_id',$session_id)->get();
        return view('wishlist',compact('wishlists','title','desc'));
    }

    public function faq()
    {
        $title = "Faq | Nakoda";
        $description = "Faq | Nakoda";
        $faqs = Faq::all();
        return view('pages.faq',compact('faqs','title','description'));
    }

    public function category()
    {
        $categories = Category::whereNull('parent_id')->where('status','Active')->orderBy('id','ASC')->get();
        $title = "Faq | Nakoda";
        $desc = "Faq | Nakoda";
        return view('listing.category',compact('title','desc','categories'));
    }

    public static function getProductReview($product_id)
    {
        $total_reviews = [];
        $review_count = Review::where('product_id',$product_id)->count('id');
        $reviews = Review::where('product_id',$product_id)->get();
        foreach ($reviews as $review) {
            $total_reviews[] = $review->rating;
        }
        if ($review_count == 0) {
            $review_count = 1;
        }
        return round(array_sum($total_reviews)/$review_count);
    }
}
