<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $table = "products";
    protected $fillable = [
        'name', 'category_id', 'description', 'slug', 'product_type', 'selling_price', 'mrp_price', 'status','brand_id','subcategory_id'
    ];

    public function productImage()
    {
        return $this->hasOne('App\Models\ProductImage')->where('is_featured', 1);
    }

    public function productImages()
    {
        return $this->hasMany('App\Models\ProductImage');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function subcategory()
    {
        return $this->belongsTo('App\Models\Category', 'subcategory_id');
    }

    public function brand()
    {
        return $this->belongsTo('App\Models\Brand');
    }

    public function ratings()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function order_lists()
    {
        return $this->hasMany('App\Models\OrderList');
    }
}
