@extends('admin.layouts.app')
@section('content')
<script src="https://code.jquery.com/jquery-1.12.4.js"></script>
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
       <div class="row">
        <div class="col-md-12">
          <div class="card">
            @if(Session::has('flash_success'))
                  <div class="alert alert-success">
                      <button type="button" class="close" data-dismiss="alert">×</button>
                  {{ Session::get('flash_success') }}
                  </div>
              @endif
              <!-- /.card-header -->
              <div class="card-body">
                <table class="table table-bordered">
                  <thead>                  
                    <tr>
                      <th>Order ID</th>
                      <th>Order To</th>
                      <th>Payable Price</th>
                      <th>Name</th>
                      <th>Email</th>
                      <th>Phone</th>
                      <th>Order Status</th>
                      <th>Ordered Date</th>
                      <th>Delivered Date</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach($orders as $row)
                    <tr>
                      {{--<td><a href="{{url('admin/order')}}/?order_id={{$row->order_id}}">{{$row->order_id}}</a></td>--}}
                      <td>{{$row->order_id}}</td>
                      <td>{{$row->coupon_id}}</td>
                      <td>&#8377;{{ @$row->payable_price}}</td>
                      <td>{{ @$row->name}}</td>
                      <td>{{ @$row->email}}</td>
                      <td>{{ @$row->phone}}</td>
                      <td>{{@$row->status}}
                         @if($row->status != "OrderDelivered")
                        <button type="button" class="btn btn-info btn-sm" data-toggle="modal" data-target="#modal{{ @$row->id }}">
                        Change Status
                      </button>@endif</td>
                      <td>{{ \Carbon\Carbon::parse($row->created_at)->format('jS M Y') }}</td>
                      <td>{{ $row->delivered_date }}</td>
                    </tr>
                    <div class="modal fade" id="modal{{ @$row->id }}">
                        <div class="modal-dialog modal-sm">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h4 class="modal-title">Change Status</h4>
                              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                              </button>
                            </div>
                            <div class="modal-body">
                              <div class="col-sm-12">
                                <form method="post" action="{{url('/admin/changeOrderStatus')}}">
                                  @csrf
                                  <div class="form-group">
                                    <label>Select Status</label>
                                    <select class="form-control" name="order_status">
                                      <option @if($row->status == "OrderPlaced") selected @endif value="OrderPlaced">OrderPlaced</option>
                                      {{--<option @if($row->status == "OrderPacked") selected @endif value="OrderPacked">OrderPacked</option>
                                      <option @if($row->status == "OrderShipped") selected @endif value="OrderShipped">OrderShipped</option>--}}
                                      <option @if($row->status == "OrderDelivered") selected @endif value="OrderDelivered">OrderCompleted</option>
                                    </select>
                                    <input type="hidden" name="order_id" value="{{ @$row->order_id}}">
                                  </div>
                                  <div class="text-center"> 
                                   <button type="submit" class="btn btn-primary">Submit</button>
                                  </div>
                                </form>
                              </div>
                            </div>
                          </div>
                          <!-- /.modal-content -->
                        </div>
                    </div>
                  <!-- /.modal -->
                    @endforeach
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
              {!! $orders->links() !!}
        </div>
        <!-- /.card -->
        </div>
       </div>
      </div><!-- /.container-fluid -->
    </section>
<script>
  $( function() {
    $( "#txtFromDate" ).datepicker();
    $( "#txtToDate" ).datepicker();
  } );
  </script>
@endsection
