@extends('admin.layouts.app')
@section('content')
<script src="//cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
       <div class="row">
        <div class="col-md-12">
          <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Create Product</h3>
              </div>
              <!-- /.card-header -->
              <!-- form start -->
              @if(Session::has('flash_success'))
                  <div class="alert alert-success">
                      <button type="button" class="close" data-dismiss="alert">×</button>
                  {{ Session::get('flash_success') }}
                  </div>
              @endif
              @if(Session::has('flash_error'))
                  <div class="alert alert-danger">
                      <button type="button" class="close" data-dismiss="alert">×</button>
                  {{ Session::get('flash_error') }}
                  </div>
              @endif
              <form method="get" action="">
                <div class="container">
                  <div class="row">
                    <div class="col-sm-12">
                      <div class="form-group">
                        <label for="category_id">Select Category <span class="required">*</span></label>
                        <select name="category_id" class="form-control" onchange="this.form.submit()">
                          @foreach($categories as $category)
                          <option @if(@$_REQUEST['category_id'] == $category->id) selected @endif value="{{$category->id}}">{{$category->name}}</option>
                          @endforeach
                        </select>
                      </div>
                    </div>
                  </div>
                </div>
              </form>

              <form enctype="multipart/form-data" role="form" id="myform" method="post" action="{{ route('products.store') }}">
                @csrf
                @if(isset($_REQUEST['category_id']) && $_REQUEST['category_id'] != '')
                  <input type="hidden" name="parent_category_id" value="{{@$_REQUEST['category_id']}}">
                @else
                  <input type="hidden" name="parent_category_id" value="{{@$firstcategory->id}}">
                @endif
                <div class="container">
                 <div class="row">

                    <div class="col-sm-12">

                          <div class="form-group mt-2">
                            <label>Select Subcategory <span class="required">*</span></label><br>
                         
                              <select name="subcategory_id" class="form-control" required="">
                                @foreach($subcategories as $subcategory)
                                <option @if(@$_REQUEST['subcategory_id'] == $subcategory->id) selected @endif value="{{$subcategory->id}}">{{$subcategory->name}}</option>
                                @endforeach
                              </select>
                          
                          </div>
                  
                          <div class="form-group">
                            <label for="price">Product Name <span class="required">*</span></label>
                            <input type="text" name="productname" id="productname" class="form-control" value="{{ old('productname') }}" placeholder="Enter Product Name" />
                            @if ($errors->has('productname'))
                                <span class="required">
                                    <strong>{{ $errors->first('productname') }}</strong>
                                </span>
                            @endif  
                          </div>
                          <div class="form-group">
                            <label>Description</label>
                            <textarea name="description" rows="4" placeholder="Enter Description" class="form-control">{{ old('description') }}</textarea>
                             @if ($errors->has('description'))
                                <span class="required">
                                    <strong>{{ $errors->first('description') }}</strong>
                                </span>
                            @endif  
                          </div>
                          <div class="form-group">
                            <label for="price">Mrp Price <span class="required">*</span></label>
                            <input type="number" min="0" name="mrp_price" id="mrp_price" class="form-control" placeholder="Enter Mrp Price" value="{{ old('mrp_price') }}" />
                            @if ($errors->has('mrp_price'))
                                <span class="required">
                                    <strong>{{ $errors->first('mrp_price') }}</strong>
                                </span>
                            @endif  
                          </div>
                          <div class="form-group">
                            <label for="price">Selling Price <span class="required">*</span></label>
                            <input type="number" min="0" name="selling_price" id="selling_price" class="form-control" placeholder="Enter Selling Price" value="{{ old('selling_price') }}" />
                            @if ($errors->has('selling_price'))
                                <span class="required">
                                    <strong>{{ $errors->first('selling_price') }}</strong>
                                </span>
                            @endif  
                          </div>
						 <div class="form-group">
                            <label for="price">Quantity <span class="required">*</span></label>
                            <input type="text" name="quantity" id="quantity" class="form-control" placeholder="Enter Quantity" value="{{ old('quantity') }}" />
                            @if ($errors->has('quantity'))
                                <span class="required">
                                    <strong>{{ $errors->first('quantity') }}</strong>
                                </span>
                            @endif  
                          </div>
                          <div class="form-group">
                            <label for="price">Stock Quantity <span class="required">*</span></label>
                            <input type="number" min="0" name="stock_quantity" id="stock_quantity" class="form-control" placeholder="Enter Stock Quantity" value="{{ old('stock_quantity') }}" />
                            @if ($errors->has('stock_quantity'))
                                <span class="required">
                                    <strong>{{ $errors->first('stock_quantity') }}</strong>
                                </span>
                            @endif  
                          </div>

            

                          <div class="form-group">
                            <label for="image">Image</label>
                            
                                <input type="file" name="images[]" class="form-control" id="image" required multiple>
                                  @if ($errors->has('images'))
                                      <span class="required">
                                          <strong>{{ $errors->first('images') }}</strong>
                                      </span>
                                  @endif  
                          
                          </div>

                          <div>
                            <label for="producttype">Product Type <span class="required">*</span></label><br>
                            <label for="chkYes">
                              <input type="radio" class="producttype" value="TopSellers" name="producttype" checked />
                              @if ($errors->has('producttype'))
                                <span class="required">
                                    <strong>{{ $errors->first('producttype') }}</strong>
                                </span>
                              @endif  
                              TopSellers
                            </label>
                            <label for="chkNo">
                              <input type="radio" class="producttype" value="NewProducts" name="producttype" />
                              @if ($errors->has('producttype'))
                                <span class="required">
                                    <strong>{{ $errors->first('producttype') }}</strong>
                                </span>
                              @endif  
                              NewProducts
                            </label>
                            <label for="chkNo">
                              <input type="radio" class="producttype" value="Other" name="producttype" />
                              @if ($errors->has('producttype'))
                                <span class="required">
                                    <strong>{{ $errors->first('producttype') }}</strong>
                                </span>
                              @endif  
                              Other
                            </label>
                          </div>
                          <div class="form-group">
                            <label for="price">Status <span class="required">*</span></label><br>
                              <label for="chkYes">
                                <input type="radio" class="productstatus" value="Active" name="productstatus" checked="" />
                                @if ($errors->has('productstatus'))
                                  <span class="required">
                                      <strong>{{ $errors->first('productstatus') }}</strong>
                                  </span>
                              @endif  
                                Active
                            </label>
                            <label for="chkNo">
                                <input type="radio" class="productstatus" value="InActive" name="productstatus"/>
                                @if ($errors->has('productstatus'))
                                  <span class="required">
                                      <strong>{{ $errors->first('productstatus') }}</strong>
                                  </span>
                              @endif  
                                Inactive
                            </label>
                          </div>
                           <div class="form-group">
                            <button id="submit" type="submit" class="btn btn-primary">Create Product</button>
                          </div>
                    </div>
                 </div>
                </div>
              </form>
            </div>
          </div>
        </div>
       </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
@endsection
