@extends('admin.layouts.app')
@section('content')
<?php $category = \App\Models\Category::where('slug',$_REQUEST['parent'])->first(); ?>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
       <div class="row">
        <div class="col-md-12">
          <div class="card">
              <div class="card-header">
                <h3 class="card-title">{{@$category->name}} Subcategory</h3>
                <a href="{{url('admin/subcategory/create')}}?parent={{$_REQUEST['parent']}}" class="btn btn-primary float-right">Create</a>
              </div>
              @if(Session::has('flash_success'))
                  <div class="alert alert-success m-2">
                      <button type="button" class="close" data-dismiss="alert">×</button>
                  {{ Session::get('flash_success') }}
                  </div>
              @endif
              <!-- /.card-header -->
              <div class="card-body">
                <table class="table table-bordered">
                  <thead>                  
                    <tr>
                      <th>SrNo</th>
                      <th>Image</th>
                      <th>Name</th>
                      <th>Status</th>
                      <th>Action</th>
                    </tr> 
                  </thead>
                  <tbody>
                    @foreach($data as $key => $row)
                    <tr>
                      <td>{{$key+1}}</td>
                      <td>
                        <img src="{{ URL::to('/') }}/public/uploads/images/{{ @$row->image }}" style="width: 300px;" />
                      </td>
                      <td>{{@$row->name}}</td>
                      <td>{{@$row->status}}</td>
                 
                      <td>
                        <a href="{{ route('subcategory.edit', $row->id) }}" class="btn"><i class="fas fa-edit" style="color: blue;"></i></a>
                         <button form="resource-delete-{{ $row->id }}"><i style="color: red;" class="fas fa-trash-alt"></i></button>
                        <form id="resource-delete-{{ $row->id }}" action="{{ route('subcategory.destroy', $row->id) }}" style="display: inline-block;" onSubmit="return confirm('Are you sure you want to delete this item?');" method="post">
                          @csrf
                          @method('DELETE')
                        </form>
                      </td>
                    </tr>
                    @endforeach
                  </tbody>
                </table>
            
              </div>
              <!-- /.card-body -->
              
        </div>
        <!-- /.card -->
        </div>
       </div>
      </div><!-- /.container-fluid -->
    </section>
@endsection
