@extends('admin.layouts.app')
@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
       <div class="row">
        <div class="col-md-12">
          <div class="card">
              <div class="card-header">
                <h3 class="card-title">Wallet</h3>
              </div>
              @if(Session::has('flash_success'))
                  <div class="alert alert-success">
                      <button type="button" class="close" data-dismiss="alert">×</button>
                  {{ Session::get('flash_success') }}
                  </div>
              @endif
              <!-- /.card-header -->
              <div class="card-body">
                <table class="table table-bordered">
                  <thead>                  
                    <tr>
                      <th>User Name</th>
                      <th>Wallet Amount</th>
                      <th>Action</th>
                    </tr> 
                  </thead>
                  <tbody>
                    @foreach($data as $row)
                    <?php 
                    $pluswallet = \App\Models\Wallet::where('user_id',$row->id)
                        ->where('status','Active')
                        ->where('debit_credit_type','PLUS')->sum('amount');

                    $minuswallet = \App\Models\Wallet::where('user_id',$row->id)
                        ->where('status','Active')
                        ->where('debit_credit_type','MINUS')->sum('amount');
                    ?>
                    <tr>
                      <td>{{$row->name}}</td>
                      <td>&#8377; {{$pluswallet - $minuswallet}}</td>
                      <td>
                        <a href="{{ route('wallets.show', $row->id) }}" class="btn"><i class="fas fa-eye" style="color: black;"></i></i></a>
                      </td>
                    </tr>
                    @endforeach
                  </tbody>
                </table> 
                <br>
                {!! $data->links() !!}
              </div>
              <!-- /.card-body -->
              
        </div>
        <!-- /.card -->
        </div>
       </div>
      </div><!-- /.container-fluid -->
    </section>
@endsection
