@extends('layouts.app')

@section('content')
<style>
   /*** Counter CSS Start ****/
   span {cursor:pointer; }
   .number{
   //   margin:100px; 
   }
   .minus, .plus{
   width:40px;
   //   height:20px;
   background:#f2f2f2;
   border-radius:4px;
   padding:8px 5px 8px 5px;
   border:1px solid #ddd;
   display: inline-block;
   vertical-align: middle;
   text-align: center;
   }
   .inputClass{
   height:30px;
   width: 100px;
   text-align: center;
   font-size: 26px;
   border:1px solid #ddd;
   border-radius:4px;
   display: inline-block;
   vertical-align: middle;
   /*** Counter CSS End ****/
</style>
<!-- entry-header-area start -->
  <div class="entry-header-area">
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <div class="entry-header">
            <h1 class="entry-title">Cart</h1>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- entry-header-area end -->

  <!-- cart-main-area start -->
  <div class="cart-main-area">
    <div class="container">
      @if(Session::has('flash_success'))
          <div class="alert alert-success">
          {{ Session::get('flash_success') }}
          </div>
      @endif
      @if(count($carts))
      <div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12">
          <div class="table-content table-responsive">
            <table>
              <thead>
                <tr>
                  <th class="product-thumbnail">Image</th>
                  <th class="product-name">Product</th>
                  <th class="product-price">Price</th>
                  <th class="product-quantity">Quantity</th>
                  <th class="product-subtotal">Total</th>
                  <th class="product-remove">Remove</th>
                </tr>
              </thead>
              <tbody>
                @foreach($carts as $cart)
				  
                <?php
				 
                                
                                    foreach($brands as $brand)
                                    {   

                                        $bid=$cart->brand_id;
                                        if($brand->id==$bid)
                                        {
                                          $bn=$brand->name;
                                          break;
                                        }

                                    }

                                  
                 $subtotal[] = $cart->product->selling_price*$cart->quantity;
                 ?>
                <tr>
                  <td class="product-thumbnail"><a href="#">
                  <img src="{{ asset('public/uploads/images') }}/{{@$cart->product->productImage->image}}" alt="{{ @$cart->product->name }}" />
                  </a>
                  </td>
                  <td class="product-name"><a href="{{url('/p')}}/{{$cart->product->slug}}">{{ @$cart->product->name }} - {{ @$cart->product->quantity }}</a></td>
                  <td class="product-price"><span class="amount">Rs {{ @$cart->product->selling_price }}</span></td>
                  <td class="product_quantity">
                    <div class="number">
                         <span onclick="productDecreaseCounter(<?php echo $cart->id; ?>)" class="minus">-</span>
                         <input class="<?php echo $cart->quantity; ?> inputClass" readonly="" type="text" value="{{$cart->quantity}}"/>
                         <span onclick="productIncreaseCounter(<?php echo $cart->id; ?>)" class="plus">+</span>
                      </div>
                  </td>
                  <td class="product-subtotal">RS {{ @$cart->product->selling_price * $cart->quantity }}</td>
                  <td class="product-remove"><a href="{{url('del/')}}/{{$cart->id}}/session_id/{{$cart->session_id}}"><i class="fa fa-times"></i></a></td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
          <div class="row">
            <div class="col-md-8 col-sm-12">
              <div class="coupon">
                <h3>Coupon</h3>
                <p>Enter your coupon code if you have one.</p>
                @if ($errors->has('couponcode'))
                <span class="required">
                    <strong>{{ $errors->first('couponcode') }}</strong>
                </span>
                @endif 
                @if(Session::has('coupon_danger'))
                <p style="color: red;">{{ Session::get('coupon_danger') }}</p>
                @endif
                @if(Session::has('coupon_removed'))
                <p style="color: red;">{{ Session::get('coupon_removed') }}</p>
                @endif  
                <form action="{{url('applyCoupon')}}" method="post">
                  @csrf   
                  <input type="text" name="couponcode" class="@error('couponcode') is-invalid @enderror" placeholder="Coupon code" @if($isCoupon == 1) value="{{@$coupon->coupon_code}}" @else value="{{ old('couponcode') }}" @endif>
                  <input type="submit" value="@if($isCoupon == 1) Applied @else Apply Coupon @endif" />
                </form>
                @if($isCoupon == 1)
                <div>
                    <span style="letter-spacing: 1px;"><span style="color: blue;">Coupon Applied Rs
                        {{ \App\Http\Controllers\CartController::getCouponDiscount(@array_sum(@$subtotal)) }} off !!</span> <br><a style="color: red;" class="required" href="{{url('delCoupon/')}}/{{$cart->session_id}}" title="Remove Coupon">Remove Coupon<i class="fa fa-trash-o"></i></a>
                    </span>
                </div>
                @endif
              </div>
              <div class="coupon">
                <h3>Pincode</h3>
                <p>Enter your pincode.[Enter 0 for Take Away]</p>
                @if(Session::has('pinode_not_filled'))
                  <p style="color: red;">{{ Session::get('pinode_not_filled') }}</p>
                @endif 
                @if ($errors->has('pincode'))
                    <span class="required">
                        <strong>{{ $errors->first('pincode') }}</strong>
                    </span>
                @endif 
                @if(Session::has('pincode_notfound'))
                    <p style="color: red;">{{ Session::get('pincode_notfound') }}</p>
                @endif 
                <form action="{{url('checkPincode')}}" method="post">
                  @csrf
                  <input type="text" name="pincode" class="@error('couponcode') is-invalid @enderror" placeholder="Enter your Pincode" @if($isPincode == 1) value="{{$pincode->pincode}}" @else value="{{ old('pincode') }}" @endif>
                <input type="submit" value="Check Pincode" />
              </form>
              @if($isPincode == 1)
                <a class="required" href="{{url('delPincode/')}}/{{$cart->session_id}}" title="Remove Coupon">Remove Pincode <i class="fa fa-trash-o"></i></a><br>
              @endif
              </div>
            </div>
            <div class="col-md-4 col-sm-12">
              <div class="cart_totals">
                <h2>Cart Totals</h2>
                <table>
                  <tbody>
                    <tr class="cart-subtotal">
                      <th>Subtotal</th>
                      <td><span class="amount">RS {{array_sum($subtotal)}}</span></td>
                    </tr>
                    @if(array_sum($subtotal) > 500)
                      <tr class="shipping">
                        <th>Shipping</th>
                        <td><span class="amount">FREE</span></td>
                      </tr>
                    @else
                      @if($isPincode == 1)
                      <tr class="shipping">
                        <th>Shipping</th>
                        <td><span class="amount">+ RS {{$pincode->delivery_charge}}</span></td>
                      </tr>
                      @endif
                    @endif
                    @if($isCoupon == 1)
                    <tr>
                      <th>Coupon Discount</th>
                      <td><span class="amount">- RS {{ \App\Http\Controllers\CartController::getCouponDiscount(@array_sum(@$subtotal)) }}</span></td>
                    </tr>
                    @endif
                    @guest @else
                    @if($wallet > 0)
                    <tr>
                      <th>Wallet</th>
                      <td><span class="amount">- RS {{$wallet}}</span></td>
                    </tr>
                    @endif
                    @endguest
                    <tr class="order-total">
                      <th>Total</th>
                      <td>
                        <strong><span class="amount">Rs {{ \App\Http\Controllers\CartController::getSubTotalPrice(\Session::getId(),\App\Http\Controllers\CartController::getCouponDiscount(array_sum($subtotal)),$wallet ) }}</span></strong>
                      </td>
                    </tr>                     
                  </tbody>
                </table>
                <div class="wc-proceed-to-checkout">
                  <a href="{{ url('checkout') }}">Proceed to Checkout</a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      @endif
    </div>
  </div>
  <!-- cart-main-area end --> 
@endsection