@extends('layouts.app')

@section('content')
<style>
    .fa-star {
        font-size : 20px;
        align-content : center;
    }
    </style>
<!-- breadcrumb-area start -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="breadcrumb">
                        <ul>
                            <li><a href="{{ url('/') }}">Home</a> <i class="fa fa-angle-right"></i></li>
                            <li><a href="shop.html">Shop</a> <i class="fa fa-angle-right"></i></li>
                            <li><a href="#">{{$product->name}} </a></li>
                            
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area end -->
    <!-- product-simple-area start -->
    <div class="product-simple-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                    <div class="single-product-image">
                        <div class="single-product-tab">
                          <!-- Nav tabs -->
                          <ul class="nav nav-tabs" role="tablist">
                            @php $image_counter = 1; @endphp
                            @foreach($product->productImages as $p_image)
                            @php $image_counter++; @endphp
                            <li role="presentation" @if($image_counter == 1) class="active" @endif>
                                <a href="#home{{$p_image->id}}" aria-controls="home{{$p_image->id}}" role="tab" data-toggle="tab">
                                <img alt="" src="{{ asset('public/uploads/images') }}/{{@$p_image->image}}"></a>
                            </li>
                            @endforeach
                          </ul>

                          <!-- Tab panes -->
                          <div class="tab-content">
                            @php $image_counter1 = 0; @endphp
                            @foreach($product->productImages as $p_image)
                            @php $image_counter1++; @endphp
                            <div role="tabpanel" class="tab-pane @if($image_counter1 == 1) active show @endif" id="home{{$p_image->id}}"><img alt="" src="{{ asset('public/uploads/images') }}/{{@$p_image->image}}"></div>
                            @endforeach
                          </div>
                        </div>
                    </div>
                </div>
				@php
                                
                                    foreach($brands as $brand)
                                    {   

                                        $bid=$product->brand_id;
                                        if($brand->id==$bid)
                                        {
                                          $bn=$brand->name;
                                          break;
                                        }

                                    }

                                    @endphp
                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                    <div class="single-product-info">
                        <h1 class="product_title">{{$product->name}} - {{$product->quantity}}</h1>
                        <div class="price-box">
							<small><p class="text-info">{{$bn}}</p></small>
                            <span class="new-price">Rs {{$product->selling_price}}</span>
                            <span class="old-price">Rs {{$product->mrp_price}}</span>
                        </div>
                        <?php $rating = \App\Http\Controllers\WelcomeController::getProductReview($product->id); ?>
                        <div class="pro-rating"> 
                            @if($rating == 0)
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star"></i>           
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star"></i> 
                            @endif
                            @if($rating == 1)
                            <i class="fa fa-star" style="color: #ec4445;"></i>
                            <i class="fa fa-star"></i>           
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star"></i> 
                            @endif
                            @if($rating == 2)
                            <i class="fa fa-star" style="color: #ec4445;"></i>
                            <i class="fa fa-star" style="color: #ec4445;"></i>           
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star"></i> 
                            @endif  
                            @if($rating == 3)
                            <i class="fa fa-star" style="color: #ec4445;"></i>
                            <i class="fa fa-star" style="color: #ec4445;"></i>           
                            <i class="fa fa-star" style="color: #ec4445;"></i>
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star"></i> 
                            @endif  
                            @if($rating == 4)
                            <i class="fa fa-star" style="color: #ec4445;"></i>
                            <i class="fa fa-star" style="color: #ec4445;"></i>           
                            <i class="fa fa-star" style="color: #ec4445;"></i>
                            <i class="fa fa-star" style="color: #ec4445;"></i>
                            <i class="fa fa-star"></i> 
                            @endif  
                            @if($rating == 5)
                            <i class="fa fa-star" style="color: #ec4445;"></i>
                            <i class="fa fa-star" style="color: #ec4445;"></i>           
                            <i class="fa fa-star" style="color: #ec4445;"></i>
                            <i class="fa fa-star" style="color: #ec4445;"></i>
                            <i class="fa fa-star" style="color: #ec4445;"></i> @endif   
                        </div>
                        <div class="short-description">
                            <p> <?php echo $product->description; ?></p>                      
                        </div>
                        @if($product->stock_quantity > 1)
                        <div class="stock-status">
                            <label>Availability</label>: <strong>In stock</strong>
                        </div>
                        @else
                        <div class="stock-status">
                            <label>Availability</label>: <strong>Out Of Stock</strong>
                        </div>
                        @endif
                        <div class="stock-status">
                            <label>Product Type :</label>: <strong>{{$product->category->name}}</strong>
                        </div>
                        @if($product->stock_quantity > 1)
                        <a onclick="addToCart(<?php echo $product->id; ?>)" href="javascript:void(0)" class="submit btn btn-success" type="submit">Buy Now</a>
                        @else
                        <a href="javascript:void(0)" class="submit btn btn-success" type="submit">Out Of Stock</a>
                        @endif
                        <div class="add-to-wishlist">
                            <a  href="javascript:void(0)" onclick="addToWishList(<?php echo $product->id; ?>)" data-toggle="tooltip" title="Add to Wishlist"><i class="fa fa-heart"></i></a>
                        </div>
                        <div class="share_buttons">
                             <ul class="social-links clearfix">
                         <a href="#">
                         <img src="https://convertkit.com/images/social-icons/facebook.png" alt="Facebook"  style="text-decoration: none; width: 38px;">
                         </a>
                        <a href="#">
                        <img src="https://convertkit.com/images/social-icons/twitter.png" alt="Twitter"  style="text-decoration: none; width: 38px;">
                        </a>
                    
                        <a href="#">
                        <img src="https://convertkit.com/images/social-icons/instagram.png" alt="Instagram" style="text-decoration: none; width: 38px;">
                        </a>
                    
                    </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- product-simple-area end -->
    <div class="product-tab-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-9 col-md-12">
                    <div class="product-tabs">
                        <div class="product__tabs_inner">
                          <!-- Nav tabs -->
                          <ul class="nav nav-tabs description-list" role="tablist">
                            <li role="presentation" class="active">
                            <a class="active" href="#tab-desc" aria-controls="tab-desc" role="tab" data-toggle="tab">Description</a></li>
                            <li role="presentation"><a href="#page-comments" aria-controls="page-comments" role="tab" data-toggle="tab">Reviews (1)</a></li>
                          </ul>
                          <!-- Tab panes -->
                          <div class="tab-content">
                            @if(Session::has('flash_success_review'))
                              <div class="alert alert-success">
                                  <button type="button" class="close" data-dismiss="alert">×</button>
                              {{ Session::get('flash_success_review') }}
                              </div>
                          @endif
                            <div role="tabpanel" class="tab-pane active" id="tab-desc">
                                <div class="product-tab-desc">
                                <?php echo $product->description; ?>
                                </div>
                            </div>
                            <div role="tabpanel" class="tab-pane" id="page-comments">
                                <div class="product-tab-desc">
                                    <div class="product-page-comments">
                                        <ul>
                                            @foreach($product->ratings as $rating)
                                            <li> 
                                                <div class="product-comments">
                                                    <div class="product-comments-content">
                                                        <p><strong>{{$rating->user->name}}</strong> -
                                                            <span>{{ \Carbon\Carbon::parse($rating->created_at)->format('jS M Y') }}:</span>
                                                            <span class="pro-comments-rating">
                                                                @if($rating->rating == 1)
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                                <i class="fa fa-star"></i>           
                                                                <i class="fa fa-star"></i>
                                                                <i class="fa fa-star"></i>
                                                                <i class="fa fa-star"></i> 
                                                                @endif
                                                                @if($rating->rating == 2)
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>           
                                                                <i class="fa fa-star"></i>
                                                                <i class="fa fa-star"></i>
                                                                <i class="fa fa-star"></i> 
                                                                @endif  
                                                                @if($rating->rating == 3)
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>           
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                                <i class="fa fa-star"></i>
                                                                <i class="fa fa-star"></i> 
                                                                @endif  
                                                                @if($rating->rating == 4)
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>           
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                                <i class="fa fa-star"></i> 
                                                                @endif  
                                                                @if($rating->rating == 5)
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>           
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                                <i class="fa fa-star" style="color: #ec4445;"></i> @endif                                
                                                            </span>
                                                        </p>
                                                        <div class="desc">
                                                           {{$rating->review}}
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            @endforeach
                                        </ul>
                                        @if($canReview == 1)
                                        <div class="review-form-wrapper">
                                            <h3>Add a review</h3>
                                            <form action="{{ route('postReview') }}" method="post">
                                                @csrf
                                                <div class="your-rating">
                                                    <h5>Your Rating</h5>
                                                    <div class = "container">
                                                       <div class = "con">
                                                        <i class = "fa fa-star" aria-hidden = "true" id = "st1"></i>
                                                       <i class = "fa fa-star" aria-hidden = "true" id = "st2"></i>
                                                       <i class = "fa fa-star" aria-hidden = "true" id = "st3"></i>
                                                       <i class = "fa fa-star" aria-hidden = "true" id = "st4"></i>
                                                       <i class = "fa fa-star" aria-hidden = "true" id = "st5"></i>
                                                       </div>
                                                    </div>
                                                </div>
                                                <input type="hidden" name="product_id" value="{{$product->id}}">
                                                <input type="hidden" class="rating" name="rating">
                                                <textarea required name="review" cols="30" rows="10" placeholder="Your Rating"></textarea>
                                                <input type="submit" value="submit" />
                                            </form>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                          </div>
                        </div>                      
                    </div>
                    <div class="clear"></div>
                    <div class="upsells_products_widget">
                        <div class="section-heading">
                            <h3>Related Products</h3>
                        </div>
                        <div class="row">
                            <div class="top-sells-curosel">
                                <!-- single-product start -->
                                @foreach($similar_products as $similar_product)
                                <div class="col-12">
                                <div class="single-product">
                                    <!-- <span class="sale-text">Sale</span> -->
                                    <div class="product-img">
                                        <a href="{{url('/p')}}/{{$similar_product->slug}}">
                                            <img class="primary-image" src="{{ asset('public/uploads/images') }}/{{@$similar_product->productImage->image}}" alt="{{$similar_product->name}}" />
                                            <img class="secondary-image" src="{{ asset('public/uploads/images') }}/{{@$similar_product->productImage->image}}" alt="{{$similar_product->name}}" />
                                        </a>
                                        <div class="actions">
                                            <div class="action-buttons">
                                                <div class="add-to-cart">
                                                    <a onclick="addToCart(<?php echo $similar_product->id; ?>)" href="javascript:void(0)">Add to cart</a>
                                                </div>
                                                <div class="add-to-links">
                                                    <div class="add-to-wishlist">
                                                        <a href="javascript:void(0)" onclick="addToWishList(<?php echo $similar_product->id; ?>)" data-toggle="tooltip" title="Add to Wishlist"><i class="fa fa-star"></i>
                                                        </a>
                                                    </div>                               
                                                </div>
                                            </div>
                                        </div>                          
                                    </div>
                                    <div class="product-content">
                                        <h2 class="product-name"><a href="{{url('/p')}}/{{$similar_product->slug}}">{{$similar_product->name}}</a></h2>
                                        <?php $rating = \App\Http\Controllers\WelcomeController::getProductReview($similar_product->id); ?>
                                        <div class="pro-rating"> 
                                            @if($rating == 0)
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>           
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i> 
                                            @endif
                                            @if($rating == 1)
                                            <i class="fa fa-star" style="color: #ec4445;"></i>
                                            <i class="fa fa-star"></i>           
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i> 
                                            @endif
                                            @if($rating == 2)
                                            <i class="fa fa-star" style="color: #ec4445;"></i>
                                            <i class="fa fa-star" style="color: #ec4445;"></i>           
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i> 
                                            @endif  
                                            @if($rating == 3)
                                            <i class="fa fa-star" style="color: #ec4445;"></i>
                                            <i class="fa fa-star" style="color: #ec4445;"></i>           
                                            <i class="fa fa-star" style="color: #ec4445;"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i> 
                                            @endif  
                                            @if($rating == 4)
                                            <i class="fa fa-star" style="color: #ec4445;"></i>
                                            <i class="fa fa-star" style="color: #ec4445;"></i>           
                                            <i class="fa fa-star" style="color: #ec4445;"></i>
                                            <i class="fa fa-star" style="color: #ec4445;"></i>
                                            <i class="fa fa-star"></i> 
                                            @endif  
                                            @if($rating == 5)
                                            <i class="fa fa-star" style="color: #ec4445;"></i>
                                            <i class="fa fa-star" style="color: #ec4445;"></i>           
                                            <i class="fa fa-star" style="color: #ec4445;"></i>
                                            <i class="fa fa-star" style="color: #ec4445;"></i>
                                            <i class="fa fa-star" style="color: #ec4445;"></i> @endif   
                                        </div>
                                        <div class="price-box">
                                            <span class="new-price"> Rs {{$similar_product->selling_price}}</span>
                                            <span class="old-price">Rs {{$similar_product->mrp_price}}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                                @endforeach
                                <!-- single-product end -->                       
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-12">
                    <!-- widget-recent start -->
                    <aside class="widget top-product-widget">
                        <h3 class="sidebar-title">Recent</h3>
                        <ul>
                            @foreach($new_products as $new_product)
                            <li>
                                <div class="single-product">
                                    <div class="product-img">
                                        <a href="{{url('/p')}}/{{$new_product->slug}}">
                                             <img class="primary-image" src="{{ asset('public/uploads/images') }}/{{@$new_product->productImage->image}}" alt="{{$new_product->name}}" />
                                            <img class="secondary-image" src="{{ asset('public/uploads/images') }}/{{@$new_product->productImage->image}}" alt="{{$new_product->name}}" />
                                        </a>                        
                                    </div>
                                    <div class="product-content">
                                        <div class="pro-info">
                                            <h2 class="product-name"><a href="{{url('/p')}}/{{$new_product->slug}}">{{$new_product->name}}</a></h2>
                                            <div class="price-box">
                                                <span class="new-price"> RS {{$new_product->selling_price}}</span>
                                                <span class="old-price">Rs {{$new_product->mrp_price}}</span>
                                            </div>                              
                                        </div>                                  
                                    </div>
                                </div>
                            </li>
                            @endforeach
                        </ul>
                    </aside>
                    <!-- widget-recent end -->              
                </div>
            </div>
        </div>
    </div>
@endsection