@extends('layouts.app')

@section('content')
<!-- customer login start -->
<div class="my-account-area">
    <div class="container" style="padding-top: 100px;">
        <div class="row">
            <div class="col-md-3"></div>
            <div class="col-md-6">
                @if(!empty($success))
                    <div class="alert alert-success"> {{ $success }}</div>
                @endif
                    @if(Session::has('success'))
                        <div class="alert alert-success">
                            {{ Session::get('success') }}
                        </div>
                    @endif
                <form action="{{ route('sendOtp') }}" method="post">
                    @csrf
                    <div class="form-fields">
                        <h2>Login With OTP</h2>
                        <p>
                            <label>Mobile<span class="required">*</span></label>
                            <input type="text" name="phone" class="@error('phone') is-invalid @enderror" placeholder="Mobile Number" value="{{ old('phone') }}" required>
                            @error('email')
                            <span class="invalid-feedback" role="alert">
                          <strong>{{ $message }}</strong>
                      </span>
                            @enderror
                        </p>
                    </div>
                        <div class="form-action">
                        <button type="submit" class="btn btn-dark">Login</button>
                    </div>



                </form>
            </div>
            <div class="col-md-3"></div>
        </div>
    </div>
</div>
<!-- customer login end -->
@endsection
