@extends('layouts.app') 
@section('content')
<!-- my-account-area start -->
<div class="my-account-area">
  <div class="container">
    @if(Session::has('flash_success'))
      <div class="alert alert-success">
      {{ Session::get('flash_success') }}
      </div>
    @endif
    @if(Session::has('flash_danger'))
      <div class="alert alert-danger">
      {{ Session::get('flash_danger') }}
      </div>
    @endif
    @if ($errors->any())
       @foreach ($errors->all() as $error)
           <h3 class="invalid-feedback">{{$error}}</h3>
       @endforeach
   @endif
    <h1>My Account Details</h1>
    <hr>
    <div class="row">
      <div class="col-md-3 mb-3">
        <ul class="nav nav-pills flex-column" id="myTab" role="tablist">
          <li class="nav-item" style="border:1px solid grey;"> <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">My Profile</a>
          </li>
          <li class="nav-item" style="border:1px solid grey;"> <a class="nav-link" id="profile-tab" data-toggle="tab" href="#edit-profile" role="tab" aria-controls="profile" aria-selected="false">Edit Profile</a>
          </li>
          <li class="nav-item" style="border:1px solid grey;"> <a class="nav-link" id="contact-tab" data-toggle="tab" href="#contact" role="tab" aria-controls="contact" aria-selected="false">Change Password</a>
          </li>
          <li class="nav-item" style="border:1px solid grey;"> <a class="nav-link" id="profile-tab" data-toggle="tab" href="#Wallet" role="tab" aria-controls="profile" aria-selected="false">My Wallet</a>
          </li>
          <li class="nav-item" style="border:1px solid grey;"> <a class="nav-link" id="profile-tab" data-toggle="tab" href="#Orders" role="tab" aria-controls="profile" aria-selected="false">My Orders</a>
          </li>
          <li class="nav-item" style="border:1px solid grey;"> <a class="nav-link" id="contact-tab" data-toggle="tab" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" href="{{url('logout')}}" role="tab" aria-controls="contact" aria-selected="false">Logout</a>
            <form id="logout-form" action="{{ url('logout') }}" method="POST" style="display: none;">
                {{ csrf_field() }}
            </form>
          </li>
        </ul>
      </div>
      <!-- /.col-md-4 -->
      <div class="col-md-9">
        <div class="tab-content" id="myTabContent">
          <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
            <h2>My Profile</h2>
            <h6>Full Name : <span> {{Auth::user()->name}} </span></h6> 
            <h6>Email : <span> {{Auth::user()->email}} </span> </h6>
            <h6>Phone :<span> {{Auth::user()->phone}} </span></h6>
            <h6>State : <span>{{@Auth::user()->state->name}}  </span> </h6>
            <h6>City : <span>{{Auth::user()->city}}  </span> </h6>
            <h6>Pin Code :<span> {{Auth::user()->pincode}} </span> </h6>
            <h6>Address : <span>  {{Auth::user()->address}} </span> </h6>
          </div>
          <div class="tab-pane fade" id="Orders" role="tabpanel" aria-labelledby="profile-tab">
            <h2>My Orders</h2>
            <div class="col-sm-12" style="overflow-x:auto;">
              <table class="table table-bordered" style="overflow-x:auto;">
                <thead>
                  <tr>
                    <th>Order Id</th>
                    <th>Date</th>
                    <th>Status</th>
                    <th>Total</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody>@foreach($orders as $order)
                  <tr>
                    <td>{{$order->order_id}}</td>
                    <td>{{$order->created_at}}</td>
                    <td>{{$order->status}}</td>
                    <td>&#8377; {{$order->payable_price}}</td>
                    <td><a href="{{url('user/order')}}?order_id={{$order->order_id}}">View</a>
                    </td>
                  </tr>@endforeach</tbody>
              </table>
            </div>
          </div>
          <div class="tab-pane fade" id="Wallet" role="tabpanel" aria-labelledby="profile-tab">
            <h2>My Wallet</h2>
            <img src="{{asset('public/assets')}}/img/logo/wallet.png" width="90px" alt="" />
            <h2> Wallet Amount : <span> Rs {{$totalWallet}} </span></h2>
            <button type="button" class="btn btn-outline-danger" data-toggle="modal" data-target="#exampleModal">Add Amount</button>
            <br>
            <br>
            <div class="col-sm-12" style="overflow-x:auto;">
              <table class="table table-bordered">
                <thead>
                  <tr>
                    <th>Amount</th>
                    <th>Description</th>
                    <th>Transaction Time</th>
                  </tr>
                </thead>
                <tbody>
                @include('includes.wallet')
                </tbody>
    
              </table>
            </div>
            <!-- Add Money Modal Start -->
            <!-- Modal -->
			    <form action="{{url('add-to-wallet')}}" method ="post">@csrf
            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
              <div class="modal-dialog" role="document">
                <div class="modal-content" style="background:#519907">
                  <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel" style="color:white">Add Money</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body">
                    <div class="form-group">
                      <h6 style="color:white">Add Money</h6>
                      <input type="number" min="0" class="form-control"name ="money" id="money" placeholder="Enter Amount" required>
                    </div>
                  </div>
                  <div class="modal-footer">
                    <button  class="btn btn-danger add_money">Add Money</button>
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>
                  </div>
                  
                </div>
              </div>
            </div>
					</form>
            <!-- Add Money Modal End -->
          </div>
          <div class="tab-pane fade" id="edit-profile" role="tabpanel" aria-labelledby="profile-tab">
            <h2>Edit Profile</h2>
            <div class="col-sm-8 container">
              <form method="POST" action="{{url('user/updateprofile')}}" class="form-box" enctype="multipart/form-data">{{csrf_field()}}
              <div class="form-group">
                <label>Name:</label>
                <input type="text" class="form-control" name="name" value="{{Auth::user()->name}}" placeholder="Name" required>
              </div>
              <div class="form-group">
                <label>Email:</label>
                <input type="text" class="form-control" name="email" value="{{Auth::user()->email}}" placeholder="Email" required>
              </div>
              <div class="form-group">
                <label>Phone:</label>
                <input type="text" class="form-control" value="{{Auth::user()->phone}}" placeholder="Your Phone" name="phone" required>
              </div>
              
              <div class="form-group">
                <label>State:</label>
                <select class="form-control" name="state_id">
                  @foreach($states as $state)
                  <option @if(Auth::user()->state_id == $state->id) selected @endif value="{{$state->id}}">{{ $state->name }}</option>
                  @endforeach
                </select>
              </div>
              <div class="form-group">
                <label>City:</label>
                <input type="text" class="form-control" value="{{Auth::user()->city}}" placeholder="Your City" name="city" required>
              </div>
              <div class="form-group">
                <label>Pincode:</label>
                <input type="text" class="form-control" value="{{Auth::user()->pincode}}" placeholder="Your Pincode" name="pincode" required>
              </div>
              <div class="form-group">
                <label>Address:</label>
                <textarea class="form-control" name="address">{{Auth::user()->address}}</textarea>
              </div>
              <div class="form-group">
                <button type="submit" class="btn btn-primary">Update</button>
              </div>
            </form>
            </div>
          </div>
          <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
            <h2> Change Password  </h2>
            <div class="col-sm-8 container">
                <form action="{{url('user/updatePassword')}}" method="post">
                    @csrf
                    <div class="form-group">
                      <label>Password<span class="required">*</span></label>
                      <input type="password" class="form-control" name="password" placeholder="Enter Password">
                    </div>
                    <div class="form-group">
                      <label>Confirm Password<span class="required">*</span></label>
                      <input class="form-control" type="password" name="confirm_password" placeholder="Enter Confirm Password">
                    </div>
                    <div class="save_button primary_btn default_button">
                       <button type="submit" class="btn btn-primary">Update</button>
                    </div>
                </form>
            </div>
          </div>
        </div>
      </div>
      <!-- /.col-md-8 -->
    </div>
  </div>
  <!-- /.container -->
</div>
<!-- my-account-area end -->
{{--    <script src="{{ asset('public/assets') }}/js/vendor/jquery-1.12.4.min.js"></script>--}}
{{--    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>--}}
{{--    <script type="text/javascript">--}}
{{--        $('body').on('click', '.add_money', function(e){--}}
{{--            var amount = $('#money').val();--}}
{{--            var product_id =  1;--}}
{{--            var _token = "{{@csrf_token()}}";--}}
{{--            var options = {--}}
{{--                "key": '<?php echo env('RAZOR_KEY'); ?>',--}}
{{--                "amount": (amount*100), // 2000 paise = INR 20--}}
{{--                "name": "Nakoda",--}}
{{--                "description": "Payment",--}}
{{--                "image": "{{url('public/assets/img/logo/nalogo.jpg')}}",--}}
{{--                "handler": function (response){--}}
{{--                    $.ajax({--}}
{{--                        url: "{{url('add-wallet')}}",--}}
{{--                        type: 'post',--}}
{{--                        dataType: 'json',--}}
{{--                        data: {--}}
{{--                            razorpay_payment_id: response.razorpay_payment_id ,--}}
{{--                            amount : amount,--}}
{{--                            _token:_token--}}
{{--                        },--}}
{{--                        success: function (res) {--}}
{{--                            location.reload();--}}
{{--                            //$('#Wallet').html(response.wallet);--}}
{{--                            //$('#Wallet').addClass('active'); //add--}}
{{--                        }--}}
{{--                    });--}}
{{--                },--}}
{{--                "prefill": {--}}
{{--                    "contact": '<?php echo @Auth::user()->phone; ?>',--}}
{{--                    "email":   '<?php echo @Auth::user()->email; ?>',--}}
{{--                },--}}
{{--                "theme": {--}}
{{--                    "color": "#528FF0"--}}
{{--                }--}}
{{--            };--}}
{{--            var rzp1 = new Razorpay(options);--}}
{{--            rzp1.open();--}}
{{--            e.preventDefault();--}}
{{--        });--}}
{{--    </script>--}}
@endsection
