<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
Route::group([
    'prefix' => 'auth'
], function () {
    Route::post('login', 'Api\AuthController@login');
    Route::post('signup', 'Api\AuthController@signup');
	Route::post('socialLogin', 'Api\AuthController@socialLogin');


    Route::group([
        'middleware' => 'auth:api'
    ], function () {
        Route::get('logout', 'Api\AuthController@logout');

        Route::get('user', 'Api\AuthController@user');
        //change password
        Route::post('changePassword', 'Api\AuthController@changePassword');
        //edit profile
        Route::put('editProfile', 'Api\AuthController@update');
        //my orders
        Route::get('myOrders', 'Api\AuthController@myOrder');
        Route::get('orderList/{id}', 'Api\OrderController@orderDetailsByOrder');
        //my wallet
        Route::post('addMoneyInWallet', 'Api\AuthController@addWalletMoney');
        Route::get('viewWalletMoney', 'Api\AuthController@viewWallet');
        //add in cart, update in cart, delete in cart,single show in cart
        Route::apiResource('cart', 'Api\ProductController');
        //view cart products by user
        Route::get('cartProductsByUser', 'Api\ProductController@cartProducts');
        //add in wishlist
        Route::post('addInWishList', 'Api\ProductController@addWishList');
        //view wishlist
        Route::get('viewWishList', 'Api\ProductController@viewWishList');
        //delete from wishlist
        Route::delete('deleteWishListProduct/{id}', 'Api\ProductController@deleteWishlist');
		//wishlistCount
		Route::get('listCount','Api\ProductController@listCount');
		//cart count
		Route::get('cartCount','Api\ProductController@cartCount');
        //pincode
        Route::get('pinCodeCheck', 'Api\OrderController@pinCodeCheck');
		Route::get('removePincode','Api\OrderController@removePincode');
        //coupon check
        Route::get('couponCodeCheck', 'Api\OrderController@couponCodeCheck');
		Route::get('removeCouponCode', 'Api\OrderController@removeCoupon');
		
        //postReview
        Route::post('addReview/{pid}', 'Api\ReviewController@postReviews');
        //order
        Route::post('confirmOrder', 'Api\OrderController@confirmOrder');
		Route::get('discount/{total_amount}', 'Api\OrderController@getDiscount');
		Route::get('subTotal/{discount_amount}/wallet/{wallet}', 'Api\OrderController@getSubTotalPrice');

    });
});
//open route for home
Route::get('home', 'Api\ProductController@getHome');
//open route for active categories
Route::get('activeCategories', 'Api\ProductController@getAllActiveCategory');
//open route for product by single category
Route::get('productBySingleCategory/{id}', 'Api\ProductController@productBySingleCategory');
//open route for our brands
Route::get('ourBrands', 'Api\ProductController@ourBrands');
//search product by name
Route::get('productByName/{name}', 'Api\ProductController@searchByProductName');
//brand wise products
Route::get('brandWiseProducts/{id}', 'Api\ProductController@brandWiseProducts');
//view single product by id with related and recent products
Route::get('getSingleProduct/{id}', 'Api\ProductController@productById');
//view single product by slug with related and recent products
Route::get('getProduct/{slug}', 'Api\ProductController@productDetailsWithRelatedAndRecent');
//contact
Route::post('addContact', 'Api\ReviewController@addContact');
//faqs
Route::get('viewFaqs', 'Api\ReviewController@viewFaqs');
//state
Route::get('states','Api\AuthController@getAllStates');

//forgot password
Route::group([
    'middleware' => 'api',
    'prefix' => 'password'
], function () {
    Route::post('create', 'Api\PasswordResetController@create');
    Route::get('find/{token}', 'Api\PasswordResetController@find');
    Route::post('reset', 'Api\PasswordResetController@reset');
});
