<?php

use Illuminate\Support\Facades\Route;
Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
    return "Cache is cleared";
});
Route::get('/', 'WelcomeController@welcome');
Route::get('category','WelcomeController@category');
Route::get('wishlist','WelcomeController@wishlist');
Route::get('faq','WelcomeController@faq');
Route::get('about', 'PageController@about');
Route::get('team','PageController@team');
Route::get('privacy-policy', 'PageController@privacyPolicy');
Route::get('terms-condition', 'PageController@termsCondtion');
Route::get('shop', 'WelcomeController@shop');
Route::get('c/{slug}', 'WelcomeController@shopCategory');
Route::get('c/{cat}/s/{sub}', 'WelcomeController@shopsubCategory');
Route::get('p/{slug}', 'WelcomeController@productDetail');
Route::get('brand/{slug}', 'WelcomeController@shopBrand');
Route::get('cart','CartController@index');
Route::post('add-to-cart','CartController@addToCart');
Route::post('add-to-wishlist','CartController@addToWishList');
Route::get('contact', 'PageController@contact');
Route::post('saveContact','WelcomeController@saveContact');

Route::post('fetchProducts','WelcomeController@fetchProducts');
Route::post('postReview','UserController@postReview')->name('postReview');
//Order
Route::post('placeOrder','PaymentController@placeOrder');
Route::post('oldPlaceOrder','PaymentController@oldPlaceOrder');
Route::post('payumoney/response','PaymentController@response');
Route::post('payment/form','PaymentController@paymentForm')->name('payment.form');
Route::post('newPayment/form','PaymentController@newPaymentForm')->name('new.payment.form');
Route::get('thankyou','PaymentController@thankyou');
//Order
Route::get('inc/{id}/session_id/{session_id}','CartController@increaseCartQuantity');
Route::get('dec/{id}/session_id/{session_id}','CartController@decreaseCartQuantity');
Route::get('del/{id}/session_id/{session_id}','CartController@deleteCartQuantity');
Route::get('delWishlist/{id}/session_id/{session_id}','CartController@deleteWishList');
Route::get('addtoCart-wishlist/{id}/session_id/{session_id}','CartController@addtoCartWishlist');
Route::post('applyCoupon','CartController@applyCoupon');
Route::get('delCoupon/{session_id}','CartController@removeCoupon');
Route::post('checkPincode','CartController@checkPincode');
Route::get('delPincode/{session_id}','CartController@delPincode');
Route::get('checkout','CartController@showCheckout');
Route::get('del/{id}/session_id/{session_id}','CartController@deleteCartQuantity');
Route::post('checkEmail','Auth\RegisterController@checkEmail');
Route::post('checkPhone','Auth\RegisterController@checkPhone');
Route::get('admin/login','Admin\LoginController@showLoginForm');
Route::post('admin/login','Admin\LoginController@login');
Route::get('my-account','UserController@myprofile');
Route::post('user/updateprofile','UserController@updateprofile');
Route::post('user/updatePassword','UserController@updatePassword');
Route::get('user/order','UserController@orderDetails');
Route::post('add-wallet','UserController@addToWallet');
Route::post('add-to-wallet','PaymentController@addToWallet');
Route::get('/home', 'HomeController@index')->name('home');
Auth::routes();

Route::group(['prefix'=>'admin'], function(){
	Route::middleware([SuperAdmin::class])->group(function () {
        Route::resources([ 
            'pincodes' => 'Admin\PincodeController',
            'customers' => 'Admin\CustomerController',
            'banners' => 'Admin\BannerController',
            'category' => 'Admin\CategoryController',
            'subcategory' => 'Admin\SubcategoryController',
            'coupons' => 'Admin\CouponsController',
            'products' => 'Admin\ProductController',
            'brands' => 'Admin\BrandController',
            'faqs' => 'Admin\FaqController',
            'bridals' => 'Admin\BridalController',
            'wallets' => 'Admin\UserWalletController'
        ]);
        Route::post('deleteReviews','Admin\ProductController@deleteReviews');
        Route::get('product-reviews','Admin\ProductController@productReviews');
        Route::get('uploadPincode','Admin\PincodeController@uploadPincode');
        Route::post('bulkuploadPincode','Admin\PincodeController@bulkuploadPincode');
        Route::get('order','Admin\OrderController@orderDetail');
        Route::get('orders','Admin\OrderController@orders');
        Route::post('changeOrderStatus','Admin\OrderController@changeOrderStatus');
    	Route::get('home','Admin\HomeController@index')->name('adminHome');
    	Route::post('logout','Admin\LoginController@logout')->name('adminLogout');
        Route::get('contacts','Admin\HomeController@contacts');
        Route::post('deleteContacts','Admin\HomeController@deleteContacts');
        Route::group(['prefix'=>'products'], function(){ 
            Route::post('addMoreImages','Admin\ProductController@addMoreImages');
            Route::post('makeFeatureImage','Admin\ProductController@makeFeatureImage');
            Route::post('delete-multiple-image','Admin\ProductController@deleteMultipleImages');
        });
	});
});
