

<?php $__env->startSection('content'); ?>
  <!--=============================================
  =            cart page content         =
  =============================================-->

  <div class="shopping-cart-area mb-130 pt-100">
    <div class="container">
      <?php if(Session::has('flash_success')): ?>
          <div class="alert alert-success">
          <?php echo e(Session::get('flash_success')); ?>

          </div>
      <?php endif; ?>
      <?php if(count($carts)): ?>
      <div class="row">
        <div class="col-lg-9 mb-70">
          <!--=======  cart table  =======-->

          <div class="cart-table-container">
            <table class="cart-table">
              <thead>
                <tr>
                  <th class="product-name" colspan="2">Product</th>
                  <th class="product-price">Price</th>
                  <th class="product-quantity">Quantity</th>
                  <th class="product-subtotal">Total</th>
                  <th class="product-remove">&nbsp;</th>
                </tr>
              </thead>

              <tbody>
                <?php $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php 
                 $subtotal[] = $cart->product->selling_price*$cart->quantity;
                 $productimage = \App\Models\ProductImage::where('product_id',$cart->product->id)->where('is_featured',1)->first(); 
                 ?>
                <tr>
                  <td class="product-thumbnail">
                    <a href="<?php echo e(url('/p')); ?>/<?php echo e($cart->product->slug); ?>">
                      <img src="<?php echo e(url('/')); ?>/public/uploads/images/<?php echo e($productimage->image); ?>" class="img-fluid" alt="">
                    </a>
                  </td>
                  <td class="product-name">
                    <a href="<?php echo e(url('/p')); ?>/<?php echo e($cart->product->slug); ?>"><?php echo e($cart->product->name); ?></a>
                    <span class="product-variation">Color: <?php echo e($cart->color->name); ?></span>
                    <span class="product-variation">Size: <?php echo e($cart->size->name); ?></span>
                  </td>

                  <td class="product-price"><span class="price">&#x20B9;<?php echo e($cart->product->selling_price); ?></span></td>

                  <td class="product-quantity">
                    <div class="pro-qty1 d-inline-block mx-0">
                      <a href="<?php echo e(url('dec/')); ?>/<?php echo e($cart->id); ?>/session_id/<?php echo e($cart->session_id); ?>" class="dec">-</a>
                        <input type="text" value="<?php echo e($cart->quantity); ?>">
                      <a href="<?php echo e(url('inc/')); ?>/<?php echo e($cart->id); ?>/session_id/<?php echo e($cart->session_id); ?>" class="inc">+</a></div>
                  </td>

                  <td class="total-price"><span class="price">&#x20B9; <?php echo e($cart->product->selling_price * $cart->quantity); ?></span></td>

                  <td class="product-remove">
                    <a href="<?php echo e(url('del/')); ?>/<?php echo e($cart->id); ?>/session_id/<?php echo e($cart->session_id); ?>">
                      <i class="ion-android-close"></i>
                    </a>
                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>

          <!--=======  End of cart table  =======-->
        </div>
        <div class="col-lg-3 mb-30">
          <div class="cart-calculation-area">
            <table class="cart-calculation-table mb-30">
              <tr>
                <th>Cart Total</th>
                <td class="subtotal">&#x20B9;<?php echo e(array_sum($subtotal)); ?></td>
              </tr>
              <?php if($isCoupon == 1): ?>
              <tr>
                <th>Coupon Discount</th>
                <td class="subtotal">&#x20B9;<?php echo e(\App\Http\Controllers\CartController::getCouponDiscount(@array_sum(@$subtotal))); ?></td>
              </tr>
              <?php endif; ?>

              <?php if($isPincode == 1): ?>
              <tr>
                <th>Shipping</th>
                <td class="subtotal">&#x20B9;<?php echo e($pincode->delivery_charge); ?></td>
              </tr>
              <?php endif; ?>
              <?php 
              $total_payable_amount = @array_sum(@$subtotal) - \App\Http\Controllers\CartController::getCouponDiscount(@array_sum(@$subtotal)) + @$pincode->delivery_charge;
             ?>
              <tr>
                <th>TOTAL</th>
                <td class="subtotal">&#x20B9;<?php echo e($total_payable_amount); ?></td>
              </tr>
            </table>

            <div class="cart-calculation-button text-center">
              <a href="<?php echo e(url('checkout')); ?>"><button class="lezada-button lezada-button--medium">proceed to checkout</button></a>
            </div>
          </div>
        </div>
        <div class="col-lg-12 mb-80">
          <!--=======  coupon area  =======-->

          <div class="cart-coupon-area pb-30">
            <div class="row align-items-center">
              <div class="container">
                <?php if($errors->has('couponcode')): ?>
                <span class="required">
                    <strong><?php echo e($errors->first('couponcode')); ?></strong>
                </span>
                <?php endif; ?> 
                <?php if(Session::has('coupon_danger')): ?>
                <p style="color: red;"><?php echo e(Session::get('coupon_danger')); ?></p>
                <?php endif; ?>
                <?php if(Session::has('coupon_removed')): ?>
                <p style="color: red;"><?php echo e(Session::get('coupon_removed')); ?></p>
                <?php endif; ?>  
                <?php if(Session::has('pinode_not_filled')): ?>
                  <p style="color: red;"><?php echo e(Session::get('pinode_not_filled')); ?></p>
                <?php endif; ?> 
                <?php if($errors->has('pincode')): ?>
                    <span class="required">
                        <strong><?php echo e($errors->first('pincode')); ?></strong>
                    </span>
                <?php endif; ?> 
                <?php if(Session::has('pincode_found')): ?>
                    <p style="color: blue;"><?php echo e(Session::get('pincode_found')); ?></p>
                <?php endif; ?>
                <?php if(Session::has('pincode_notfound')): ?>
                    <p style="color: red;"><?php echo e(Session::get('pincode_notfound')); ?></p>
                <?php endif; ?> 
              </div>
              <div class="col-lg-6 mb-md-30 mb-sm-30">
                <!--=======  coupon form  =======-->
                <div class="lezada-form coupon-form">
                  <form action="<?php echo e(url('applyCoupon')); ?>" method="post">
                    <?php echo csrf_field(); ?>   
                    <div class="row">
                      <div class="col-md-7 mb-sm-10">
                        <input type="text" name="couponcode" class="<?php $__errorArgs = ['couponcode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Enter your coupon code" <?php if($isCoupon == 1): ?> value="<?php echo e(@$coupon->coupon_code); ?>" <?php else: ?> value="<?php echo e(old('couponcode')); ?>" <?php endif; ?>>
                      </div>
                      <div class="col-md-5">
                        <button class="lezada-button lezada-button--medium"><?php if($isCoupon == 1): ?> Applied <?php else: ?> Apply Coupon <?php endif; ?></button>
                      </div>
                    </div>
                  </form>
                  <?php if($isCoupon == 1): ?>
                      <span style="letter-spacing: 1px;">Coupon Applied !! &#8377;
                          <?php echo e(\App\Http\Controllers\CartController::getCouponDiscount(@array_sum(@$subtotal))); ?> off <a class="required" href="<?php echo e(url('delCoupon/')); ?>/<?php echo e($cart->session_id); ?>" title="Remove Coupon">Remove Coupon<i class="fa fa-trash-o"></i></a>
                      </span>
                  <?php endif; ?>
                </div>
                <!--=======  End of coupon form  =======-->
                <div class="lezada-form coupon-form">
                 <form action="<?php echo e(url('checkPincode')); ?>" method="post">
                  <?php echo csrf_field(); ?>
                    <div class="row">
                      <div class="col-md-7 mb-sm-10">
                        <input type="text" name="pincode" class="<?php $__errorArgs = ['couponcode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Enter your Pincode" <?php if($isPincode == 1): ?> value="<?php echo e($pincode->pincode); ?>" <?php else: ?> value="<?php echo e(old('pincode')); ?>" <?php endif; ?>>
                      </div>
                      <div class="col-md-5">
                        <button class="lezada-button lezada-button--medium">Check Pincode</button>
                      </div>
                    </div>
                  </form>
                  <?php if($isPincode == 1): ?>
                    <a class="required" href="<?php echo e(url('delPincode/')); ?>/<?php echo e($cart->session_id); ?>" title="Remove Coupon">Remove Pincode <i class="fa fa-trash-o"></i></a><br>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>

          <!--=======  End of coupon area  =======-->
        </div>
      </div>
      <?php else: ?>
       <div class="text-center">
         <img src="https://cdn.dribbble.com/users/844846/screenshots/2981974/empty_cart_800x600_dribbble.png">
       </div>
       <?php endif; ?>
    </div>
  </div>

  <!--=====  End of cart page content  ======-->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tera/resources/views/cart.blade.php ENDPATH**/ ?>