<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>MDR - Mobile Accessories</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(url('/')); ?>/public/assets/img/favicon.ico">
    <!-- CSS 
    ========================= -->
    <!-- Plugins CSS -->
    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/public/assets/css/plugins.css">
    <!-- Main Style CSS -->
    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/public/assets/css/style.css">
    <link href="//cdn.jsdelivr.net/npm/@sweetalert2/theme-dark@3/dark.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    
</head>

<body>
<?php $categories = \App\Models\Category::whereNull('parent_id')->where('status','Active')->orderBy('id','ASC')->get(); ?>
    <!--header area start-->
    
    <!--Offcanvas menu area start-->
    <div class="off_canvars_overlay">
                
    </div>
    <div class="Offcanvas_menu">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="canvas_open">
                        <a href="javascript:void(0)"><i class="ion-navicon"></i></a>
                    </div>
                    <div class="Offcanvas_menu_wrapper">
                        <div class="canvas_logo">
                              <a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(url('/')); ?>/public/assets/img/logo/MXD-logo.png" alt=""></a>  
                        </div>
                        <div class="canvas_close">
                              <a href="javascript:void(0)"><i class="ion-android-close"></i></a>  
                        </div>
                        <div class="support_info">
                            <p>Telephone Enquiry: <a href="tel:+9029363912">(+91) 90 2936 3912</a></p>
                        </div>
                        <div class="top_right text-right">
                            <ul>
                            <?php if(auth()->guard()->guest()): ?>
                               <li><a href="<?php echo e(url('login')); ?>"> Login </a></li> 
                               <li><a href="<?php echo e(url('register')); ?>"> Register </a></li> 
                            <?php else: ?>
                               <li><a href="<?php echo e(url('account')); ?>"> My Account </a></li> 
                               <li><a onclick="event.preventDefault();
                                 document.getElementById('logout-form').submit();" href="<?php echo e(url('logout')); ?>"> Logout</a>
                                <form id="logout-form" action="<?php echo e(url('logout')); ?>" method="POST" style="display: none;">
                                    <?php echo e(csrf_field()); ?>

                                </form>
                                </li>
                            <?php endif; ?>
                            </ul>
                        </div> 
                        <div class="search_container">
                           <form action="#">
                               <div class="hover_category">
                                    <select class="select_option" name="select" id="categori">
                                        <option>All Categories</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option><?php echo e($category->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>                        
                               </div>
                                <div class="search_box">
                                    <input placeholder="Search product..." type="text" autocomplete="off">
                                </div>
                            </form>
                        </div> 
                        
                        <div class="middel_right_info">
                           <?php echo $__env->make('includes.minicart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div id="menu" class="text-left ">
                            <ul class="offcanvas_main_menu">
                                <li class="menu-item-has-children active">
                                    <a href="<?php echo e(url('/')); ?>"><img src="https://img.icons8.com/android/20/000000/home.png"/><span>Home</span></a>
                                </li>
                                <li class="menu-item-has-children">
                                    <a href="<?php echo e(url('shop')); ?>"><img src="https://img.icons8.com/pastel-glyph/20/000000/shop.png"/><span>Shop</span></a>
                                </li>
                                <li class="menu-item-has-children">
                                    <a href="<?php echo e(url('login')); ?>"><img src="https://img.icons8.com/ios-glyphs/20/000000/guest-male.png"/><span>Login/Register</span></a>
                                </li>
                                <li class="menu-item-has-children">
                                    <a href="<?php echo e(url('about')); ?>"><img src="https://img.icons8.com/metro/20/000000/about.png"/><span>about Us</span></a>
                                </li>
                                <li class="menu-item-has-children">
                                    <a href="<?php echo e(url('contact')); ?>"><img src="https://img.icons8.com/metro/20/000000/phone.png"/><span>Contact Us</span></a> 
                                </li>
                            </ul>
                        </div>

                        <div class="Offcanvas_footer">
                            <span><a href="#"><i class="fa fa-envelope-o"></i> info@yourdomain.com</a></span>
                            <ul>
                                <li class="facebook"><a href="#"><i class="fa fa-facebook"></i></a></li>
                                <li class="twitter"><a href="#"><i class="fa fa-twitter"></i></a></li>
                                <li class="pinterest"><a href="#"><i class="fa fa-pinterest-p"></i></a></li>
                                <li class="google-plus"><a href="#"><i class="fa fa-google-plus"></i></a></li>
                                <li class="linkedin"><a href="#"><i class="fa fa-linkedin"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Offcanvas menu area end-->
    
    <header>
        <div class="main_header">
            <!--header top start-->
            <div class="header_top">
                <div class="container">  
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-6">
                            <div class="support_info">
                                <p>Telephone Enquiry: <a href="tel:+9029363912">(+91) 90 2936 3912</a></p>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="top_right text-right">
                                <ul>
                                   <?php if(auth()->guard()->guest()): ?>
                                       <li><a href="<?php echo e(url('login')); ?>"> Login </a></li> 
                                       <li><a href="<?php echo e(url('register')); ?>"> Register </a></li> 
                                    <?php else: ?>
                                    <li><a href="<?php echo e(url('account')); ?>"> My Account </a></li> 
                                       <li><a onclick="event.preventDefault();
                                         document.getElementById('logout-form').submit();" href="<?php echo e(url('logout')); ?>"> Logout</a>
                                        <form id="logout-form" action="<?php echo e(url('logout')); ?>" method="POST" style="display: none;">
                                            <?php echo e(csrf_field()); ?>

                                        </form>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>   
                        </div>
                    </div>
                </div>
            </div>
            <!--header top start-->
            <!--header middel start-->
            <div class="header_middle">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-3 col-md-6">
                            <div class="logo">
                                <a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(url('/')); ?>/public/assets/img/logo/MXD-logo.png" alt=""></a>
                                <!--<h2 style="font-weight: 600;font-family: PlayfairDisplay-Regular;color: #f37801;">MDR</h2>-->
                            </div>
                        </div>
                        <div class="col-lg-9 col-md-6">
                            <div class="middel_right">
                                <div class="search_container">
                                   <form action="#">
                                        <div class="search_box">
                                            <input id="search_product_name" placeholder="Search product..." type="text" autocomplete="off">
                                            <div id="productLists">
                                            </div>
                                            <button type="submit">Search</button> 
                                        </div>
                                    </form>
                                </div>
                                <div class="middel_right_info">
                                    <?php echo $__env->make('includes.minicart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--header middel end-->
            <!--header bottom satrt-->
            <div class="main_menu_area">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-3 col-md-12">
                            <div class="categories_menu">
                                <div class="categories_title">
                                    <h2 class="categori_toggle"><img src="<?php echo e(url('/')); ?>/public/assets/img/icon/category.png" alt="" style="width: 30px;margin-right: 10px;">ALL CATEGORIES</h2>
                                </div>
                                <div class="categories_menu_toggle">
                                    <ul>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="menu_item_children">
                                            <a href="<?php echo e(url('/category')); ?>/<?php echo e($category->slug); ?>">
                                                <img src="<?php echo e(url('/')); ?>/public/uploads/images/<?php echo e($category->logo); ?>" alt="<?php echo e($category->name); ?>" style="width: 25px;margin-right: 10px;"><?php echo e($category->name); ?>

                                            </a>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-9 col-md-12">
                            <div class="main_menu menu_position"> 
                                <nav>  
                                    <ul>
                                        <li><a class="active"  href="<?php echo e(url('/')); ?>">home</a>
                                        </li>
                                        <li class="mega_items"><a href="<?php echo e(url('shop')); ?>">shop</a> 
                                        </li>
                                        <li><a href="<?php echo e(url('/about')); ?>">about Us</a></li>
                                        <li><a href="<?php echo e(url('/contact')); ?>"> Contact Us</a></li>
                                    </ul>  
                                </nav> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--header bottom end-->
        </div> 
    </header>
    <!--header area end-->
    <!--sticky header area start-->
    <div class="sticky_header_area sticky-header">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-3">
                    <div class="logo">
                        <a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(url('/')); ?>/public/assets/img/logo/MXD-logo.png" alt=""></a>
                        <!--<h2 style="font-weight: 600;font-family: PlayfairDisplay-Regular;color: #f37801;">MDR</h2>-->
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="sticky_header_right menu_position">
                        <div class="main_menu"> 
                            <nav>  
                                <ul>
                                    <li><a class="active"  href="<?php echo e(url('/')); ?>">home</a>
                                    </li>
                                    <li class="mega_items"><a href="<?php echo e(url('shop')); ?>">shop</a> 
                                    </li>
                                    <li><a href="<?php echo e(url('about')); ?>">about Us</a></li>
                                    <li><a href="<?php echo e(url('contact')); ?>"> Contact Us</a></li>
                                </ul>  
                            </nav> 
                        </div>
                        <div class="middel_right_info">
                            <?php echo $__env->make('includes.minicart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--sticky header area end-->
    <?php echo $__env->yieldContent('content'); ?>
    <!--footer area start-->
    <footer class="footer_widgets">
        <div class="footer_top">
            <div class="container">
                <div class="row">
                <div class="col-lg-4 col-md-6">
                    <div class="widgets_container contact_us">
                        <div class="footer_logo">
                            <a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(url('/')); ?>/public/assets/img/logo/MXD-logo.png" alt=""></a>
                            <!--<h2 style="font-weight: 600;font-family: PlayfairDisplay-Regular;color: #f37801;">MDR</h2>-->
                        </div>
                        <div class="footer_contact">
                            <p>We sell different mobile accessories. All that you need for a mobile, you get it here.</p>
                            <p><span>Address</span> Nathani market, Shop number 110, Fast floor, Opp Best bus depot, Mumbai Central (E),Bellasis Road, Maharashtra, Mumbai, 400008</p>
                            <p><span>Mobile: </span><a href="tel:+91-9029363912">+91-9029363912</a></p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-6">
                    <div class="widgets_container widget_menu">
                        <h3>Information</h3>
                        <div class="footer_menu">
                            <ul>
                                <li><a href="<?php echo e(url('about')); ?>">About Us</a></li>
                                <li><a href="<?php echo e(url('shop')); ?>">Shop</a></li>
                                <li><a href="<?php echo e(url('privacy-policy')); ?>">Privacy Policy</a></li>
                                <li><a href="<?php echo e(url('terms-condition')); ?>">Terms & Conditions</a></li>
                                <li><a href="<?php echo e(url('contact')); ?>">Contact Us</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                   <div class="widgets_container newsletter">
                        <h3>Follow Us</h3>
                        <div class="footer_social_link">
                            <ul>
                                <li><a class="facebook" href="#" title="Facebook"><i class="fa fa-facebook"></i></a></li>
                                <li><a class="twitter" href="#" title="Twitter"><i class="fa fa-twitter"></i></a></li>
                                <li><a class="instagram" href="#" title="instagram"><i class="fa fa-instagram"></i></a></li>
                                <li><a class="linkedin" href="#" title="linkedin"><i class="fa fa-linkedin"></i></a></li>
                                <li><a class="rss" href="#" title="rss"><i class="fa fa-rss"></i></a></li>
                            </ul>
                        </div>
                        <div class="subscribe_form">
                             <?php if(Session::has('flash_success_news')): ?>
                              <div class="alert alert-success">
                              <?php echo e(Session::get('flash_success_news')); ?>

                              </div>
                          <?php endif; ?>
                           <h3>Join Our Newsletter Now</h3>
                            <form method="post" action="<?php echo e(url('subscribeNewsLetter')); ?>">
                                <?php echo csrf_field(); ?>
                                <input id="email" name="email" type="email" autocomplete="off" placeholder="Your email address..." required="" />
                                <button type="submit">Subscribe!</button>
                            </form>
                            <!-- mailchimp-alerts Start -->
                            <div class="mailchimp-alerts text-centre">
                                <div class="mailchimp-submitting"></div><!-- mailchimp-submitting end -->
                                <div class="mailchimp-success"></div><!-- mailchimp-success end -->
                                <div class="mailchimp-error"></div><!-- mailchimp-error end -->
                            </div><!-- mailchimp-alerts end -->
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
        <div class="footer_bottom">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-6">
                        <div class="copyright_area">
                            <p>Copyright &copy; 2020 <a href="#">MDR</a>  All Right Reserved.</p>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <div class="footer_payment text-right">
                            <a href="#"><img src="<?php echo e(url('/')); ?>/public/assets/img/icon/payment.png" alt=""></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>   
    </footer>
    <!--footer area end-->

<script src="<?php echo e(url('/')); ?>/public/assets/js/plugins.js"></script>
<script src="<?php echo e(url('/')); ?>/public/assets/js/main.js"></script>
<script src="<?php echo e(url('/')); ?>/public/assets/js/jquery.min.js"></script>
<script>
    $('#search_product_name').keyup(function(){ 
        var query = $(this).val();
        if(query != '')
        {
         var _token = "<?php echo e(@csrf_token()); ?>";
         $.ajax({
          url:"<?php echo e(url('fetchProducts')); ?>",
          method:"POST",
          data:{query:query, _token:_token},
          success:function(data){
            $('#productLists').show();
            $('#productLists').html(data);
            $("#productLists").css("position","absolute");
            $("#productLists").css("height","300px");
            $("#productLists").css("overflow","scroll");
            $("#productLists").css("z-index","99999");
            $("#productLists").css("background","#fff");
            $("#productLists").css("min-width","300px");
            $("#search_product_name").css("background","#FFF");
          }
         });
        }
        else{
            $('#productLists').hide();
        }
    });
</script>
<script type="text/javascript">
String.prototype.getDecimals || (String.prototype.getDecimals = function() {
    var a = this,
        b = ("" + a).match(/(?:\.(\d+))?(?:[eE]([+-]?\d+))?$/);
    return b ? Math.max(0, (b[1] ? b[1].length : 0) - (b[2] ? +b[2] : 0)) : 0
}), jQuery(document).ready(function() {
}), jQuery(document).on("updated_wc_div", function() {
}), jQuery(document).on("click", ".plus, .minus", function() {
    var a = jQuery(this).closest(".quantity").find(".qty"),
        b = parseFloat(a.val()),
        c = parseFloat(a.attr("max")),
        d = parseFloat(a.attr("min")),
        e = a.attr("step");
    b && "" !== b && "NaN" !== b || (b = 0), "" !== c && "NaN" !== c || (c = ""), "" !== d && "NaN" !== d || (d = 0), "any" !== e && "" !== e && void 0 !== e && "NaN" !== parseFloat(e) || (e = 1), jQuery(this).is(".plus") ? c && b >= c ? a.val(c) : a.val((b + parseFloat(e)).toFixed(e.getDecimals())) : d && b <= d ? a.val(d) : b > 0 && a.val((b - parseFloat(e)).toFixed(e.getDecimals())), a.trigger("change")
});
</script>
</body>
</html><?php /**PATH /var/www/html/mxd/resources/views/layouts/app.blade.php ENDPATH**/ ?>