<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
       <div class="row">
        <div class="col-md-12">
          <div class="card">
              <div class="card-header">
                <h3 class="card-title">Coupons</h3>
                <a href="<?php echo e(route('coupons.create')); ?>" class="btn btn-primary float-right">Create</a>
              </div>
              <?php if(Session::has('flash_success')): ?>
                  <div class="alert alert-success">
                      <button type="button" class="close" data-dismiss="alert">×</button>
                  <?php echo e(Session::get('flash_success')); ?>

                  </div>
              <?php endif; ?>
              <!-- /.card-header -->
              <div class="card-body">
                <table class="table table-bordered">
                  <thead>                  
                    <tr>
                      <th>Coupon Code</th>
                      <th>Discount Type</th>
                      <th>Discount Amount</th>
                      <th>Minimum Order</th>
                      <th>Valid Till</th>
                      <th>Status</th>
                      <th>Action</th>
                    </tr> 
                  </thead>
                  <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td><?php echo e(@$row->coupon_code); ?></td>
                      <th><?php echo e(@$row->discount_type); ?></th>
                      <td>&#8377; <?php echo e(@$row->discount_amount); ?></td>
                      <td>&#8377; <?php echo e(@$row->minimum_order); ?></td>
                      <td><?php echo e(@$row->validity_till); ?></td>
                      <td><?php echo e(@$row->status); ?></td>
                      <td>
                        <a href="<?php echo e(route('coupons.edit', $row->id)); ?>" class="btn"><i class="fas fa-edit" style="color: blue;"></i></a>
                        <button form="resource-delete-<?php echo e($row->id); ?>"><i style="color: red;" class="fas fa-trash-alt"></i></button>
                        <form id="resource-delete-<?php echo e($row->id); ?>" action="<?php echo e(route('coupons.destroy', $row->id)); ?>" style="display: inline-block;" onSubmit="return confirm('Are you sure you want to delete this item?');" method="post">
                          <?php echo csrf_field(); ?>
                          <?php echo method_field('DELETE'); ?>
                        </form>
                      </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                </table>
                <br>
                <?php echo $data->links(); ?>

              </div>
              <!-- /.card-body -->
              
        </div>
        <!-- /.card -->
        </div>
       </div>
      </div><!-- /.container-fluid -->
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nakoda/resources/views/admin/coupons/index.blade.php ENDPATH**/ ?>