<!-- checkout-area start -->
  <div class="checkout-area">
    <div class="container">
        <form action="#">
          <div class="row">
          <div class="col-lg-6 col-md-12">
            <div class="checkbox-form">           
              <h3>Shipping Details</h3>
              <div class="row">
                <div class="col-md-12">
                  <div class="checkout-form-list">
                    <label>Full Name <span class="required">*</span></label>                   
                    <input id="shipping_name" name="name" value="<?php echo e(Auth::user()->name); ?>" type="text" placeholder="" required />
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="checkout-form-list">
                    <label>Email Address <span class="required">*</span></label>                    
                    <input id="shipping_email" name="email" type="email" value="<?php echo e(Auth::user()->email); ?>" placeholder="" required/>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="checkout-form-list">
                    <label>Phone  <span class="required">*</span></label>                   
                    <input id="shipping_phone" type="text" name="phone" value="<?php echo e(Auth::user()->phone); ?>" placeholder="Phone" required/>
                  </div>
                </div>   
                <div class="col-md-12">
                  <div class="checkout-form-list">
                    <label>Address <span class="required">*</span></label>
                    <textarea id="shipping_address" name="address" class="form-control" placeholder="Street address" required><?php echo e(Auth::user()->address); ?></textarea>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="checkout-form-list">
                    <label>State <span class="required">*</span></label>    
                    <select class="form-control" id="shipping_state" name="state_id">
                      <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($state->name); ?>"><?php echo e($state->name); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>               
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="checkout-form-list">
                    <label>City <span class="required">*</span></label>
                    <input id="shipping_city" name="city" type="text" value="<?php echo e(Auth::user()->city); ?>" placeholder="City" required/>
                  </div>
                </div>
                
                <div class="col-md-12">
                  <div class="checkout-form-list">
                    <label>Pincode <span class="required">*</span></label>                   
                    <input id="shipping_pincode" name="pincode" value="<?php echo e($pincode->pincode); ?>" type="text" placeholder="Pincode" readonly required/>
                  </div>
                </div>
                           
              </div>                      
            </div>
          </div>  
          <div class="col-lg-6 col-md-12">
            <div class="your-order">
              <h3>Your order</h3>
              <div class="your-order-table table-responsive">
                <table>
                  <thead>
                    <tr>
                      <th class="product-name">Product</th>
                      <th class="product-total">Total</th>
                    </tr>             
                  </thead>
                  <tbody>
                    <?php $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php 
                     $subtotal[] = $cart->product->selling_price*$cart->quantity;
                    ?>
                    <tr class="cart_item">
                      <td class="product-name">
                        <?php echo e($cart->product->name); ?> <strong class="product-quantity"> × <?php echo e($cart->quantity); ?></strong>
                      </td>
                      <td class="product-total">
                        <span class="amount">Rs <?php echo e($cart->product->selling_price * $cart->quantity); ?></span>
                      </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                  <tfoot>
                    <tr class="cart-subtotal">
                      <th>Cart Subtotal</th>
                      <td><span class="amount"> Rs <?php echo e(array_sum($subtotal)); ?></span></td>
                    </tr>
                    <tr class="shipping">
                      <th>Shipping</th>
                      <td><span class="amount">
                        <?php if(array_sum($subtotal) > 500): ?> 
                        <input type="hidden" id="delivery_charge" name="delivery_charge" value="0">
                        FREE 
                        <?php else: ?>
                        <input type="hidden" id="delivery_charge" name="delivery_charge" value="<?php echo e($pincode->delivery_charge); ?>">
                         + Rs <?php echo e($pincode->delivery_charge); ?> 
                        <?php endif; ?></span></td>
                    </tr>
                    <?php if($isCoupon == 1): ?>
                    <input type="hidden" id="coupon_amount" name="coupon_amount" value="<?php echo e(\App\Http\Controllers\CartController::getCouponDiscount(@array_sum(@$subtotal))); ?>">
                    <tr class="shipping">
                      <th>Coupon Discount</th>
                      <td><span class="amount">- Rs <?php echo e(\App\Http\Controllers\CartController::getCouponDiscount(@array_sum(@$subtotal))); ?></span></td>
                    </tr>
                    <?php else: ?>
                    <input type="hidden" id="coupon_amount" name="coupon_amount" value="0">
                    <?php endif; ?>
                    <?php if(auth()->guard()->guest()): ?> 
                    <input type="hidden" id="wallet_amount" name="wallet_amount" value="0">
                    <?php else: ?>
                    <?php if($wallet > 0): ?>
                    <input type="hidden" id="wallet_amount" name="wallet_amount" value="<?php echo e($wallet); ?>">
                    <tr>
                      <th>Wallet</th>
                      <td><span class="amount">- RS <?php echo e($wallet); ?></span></td>
                    </tr>
                    <?php else: ?>
                    <input type="hidden" id="wallet_amount" name="wallet_amount" value="0">
                    <?php endif; ?>
                    <?php endif; ?>
                    <tr class="order-total">
                      <th>Order Total</th>
                      <td><strong><span class="amount">Rs <?php echo e($total_payable_amount); ?></span></strong>
                      </td>
                    </tr>               
                  </tfoot>
                </table>
              </div>
              <div class="payment-method">
                <div class="order-button-payment">
                  <input type="submit" class="submit" value="Place order" />
                </div>
              </div>
            </div>
            </div>
                </div>
                
            </form>
    </div>
  </div>
  <!-- checkout-area end -->  
  <script src="<?php echo e(asset('public/assets')); ?>/js/vendor/jquery-1.12.4.min.js"></script>
  <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
  <script type="text/javascript">
    $('.submit').on('click', function(e){
      e.preventDefault();
      $('.submit').html('Processing Please Wait');
      $('.submit').attr('disabled', true);
      var shipping_name = $('#shipping_name').val();
      var shipping_email = $('#shipping_email').val();
      var shipping_phone = $('#shipping_phone').val();
      var shipping_state = $('#shipping_state').val();
      var shipping_city = $('#shipping_city').val();
      var shipping_pincode = $('#shipping_pincode').val();
      var shipping_address = $('#shipping_address').val();
      var delivery_charge = $('#delivery_charge').val();
      var coupon_amount = $('#coupon_amount').val();
      var wallet_amount = $('#wallet_amount').val();
      var options = {
         "key": "<?php echo env('RAZOR_KEY'); ?>",
         "amount":<?php echo @$total_payable_amount; ?>*100, // 2000 paise = INR 20
         "name": "Nakoda",
         "description": "Payment",
         "image": "<?php echo e(url('public/assets/img/logo/nalogo.jpg')); ?>",
         "handler": function (response){
              $.ajax({
                 url: "<?php echo e(url('oldPlaceOrder')); ?>",
                 type: 'post',
                 dataType: 'json',
                  data: {
                  amount: <?php echo @$total_payable_amount; ?>*100,
                  razorpay_payment_id: response.razorpay_payment_id ,
                   shipping_name : shipping_name,
                   shipping_email : shipping_email,
                   shipping_phone : shipping_phone,
                   shipping_state : shipping_state,
                   shipping_city : shipping_city,
                   shipping_pincode : shipping_pincode,
                   shipping_address : shipping_address,
                   delivery_charge : delivery_charge,
                   coupon_amount : coupon_amount,
                   wallet_amount : wallet_amount,
                   _token: "<?php echo e(@csrf_token()); ?>",
                 }, 
                 success: function (msg) {
                      window.location.href = "<?php echo e(url('thankyou')); ?>"
                 }
             });
          },
         "prefill": {
             "contact": shipping_phone,
             "email": shipping_email,
          },
         "theme": {
             "color": "#528FF0"
         }
      };
      var rzp1 = new Razorpay(options);
      rzp1.open();
      e.preventDefault();
    });
  </script><?php /**PATH /var/www/html/nakoda/resources/views/includes/old-user-checkout.blade.php ENDPATH**/ ?>