<!-- checkout-area start -->
  <div class="checkout-area">
    <div class="container">
		<?php if(session('flash_failure')): ?>
            <div class="alert alert-danger" role="alert">
                <?php echo e(session('flash_failure')); ?>

            </div>
        <?php endif; ?>
        <form action="<?php echo e(route('new.payment.form')); ?>" method="post"><?php echo csrf_field(); ?>
          <div class="row">
          <div class="col-lg-6 col-md-12">
            <div class="checkbox-form">
              <h3>Shipping / Account Details</h3>
              <div class="row">
                <div class="col-md-6">
                  <div class="checkout-form-list">
                    <label>Full Name <span class="required">*</span></label>
                    <input id="shipping_name" name="name" type="text" placeholder="" />
                    <span class="shipping_name required"></span>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="checkout-form-list">
                    <label>Email Address <span class="required">*</span></label>
                    <input id="shipping_email" name="email" type="email" placeholder="" required/>
                    <span class="shipping_email required"></span>
                    <span class="email_message required"></span>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="checkout-form-list">
                    <label>Password <span class="required">*</span></label>
                    <input id="password" name="password" type="password" placeholder="" required/>
                    <span class="password required"></span>
                   
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="checkout-form-list">
                    <label>Confirm Password <span class="required">*</span></label>
                    <input id="confirm_password" name="confirm_password" type="password" placeholder="" required/>
                    <span class="confirm_password required"></span>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="checkout-form-list">
                    <label>Phone  <span class="required">*</span></label>
                    <input id="shipping_phone" type="text" name="phone" placeholder="Phone" required/>
                    <span class="shipping_phone required"></span>
					   <span class="email_phone required"></span>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="checkout-form-list">
                    <label>Address <span class="required">*</span></label>
                    <textarea id="shipping_address" name="address" class="form-control" placeholder="Street address" required></textarea>
                    <span class="shipping_address required"></span>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="checkout-form-list">
                    <label>State <span class="required">*</span></label>
                    <select class="form-control" id="shipping_state" name="state">
                      <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($state->id); ?>"><?php echo e($state->name); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="checkout-form-list">
                    <label>City <span class="required">*</span></label>
                    <input id="shipping_city" name="city" type="text" placeholder="City" required/>
                    <span class="shipping_city required"></span>
                  </div>
                </div>

                <div class="col-md-12">
                  <div class="checkout-form-list">
                    <label>Pincode <span class="required">*</span></label>
                    <input id="shipping_pincode" name="pincode" value="<?php echo e($pincode->pincode); ?>" type="text" placeholder="Pincode" readonly required/>
                    <span class="shipping_pincode required"></span>
                  </div>
                </div>

              </div>
            </div>
          </div>
          <div class="col-lg-6 col-md-12">
            <div class="your-order">
              <h3>Your order</h3>
              <div class="your-order-table table-responsive">
                <table>
                  <thead>
                    <tr>
                      <th class="product-name">Product</th>
                      <th class="product-total">Total</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                     $subtotal[] = $cart->product->selling_price*$cart->quantity;
                    ?>
                    <tr class="cart_item">
                      <td class="product-name">
                        <?php echo e($cart->product->name); ?> <strong class="product-quantity"> × <?php echo e($cart->quantity); ?></strong>
                      </td>
                      <td class="product-total">
                        <span class="amount">Rs <?php echo e($cart->product->selling_price * $cart->quantity); ?></span>
                      </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                  <tfoot>
                    <tr class="cart-subtotal">
                      <th>Cart Subtotal</th>
                      <td><span class="amount"> Rs <?php echo e(array_sum($subtotal)); ?></span></td>
                    </tr>
                    <tr class="shipping">
                      <th>Shipping</th>
                      <td><span class="amount">
                        <?php if(array_sum($subtotal) > 500): ?>
                        <input type="hidden" id="delivery_charge" name="delivery_charge" value="0">
                        FREE
                        <?php else: ?>
                        <input type="hidden" id="delivery_charge" name="delivery_charge" value="<?php echo e($pincode->delivery_charge); ?>">
                         + Rs <?php echo e($pincode->delivery_charge); ?>

                        <?php endif; ?></span></td>
                    </tr>
                    <?php if($isCoupon == 1): ?>
                    <input type="hidden" id="coupon_amount" name="coupon_amount" value="<?php echo e(\App\Http\Controllers\CartController::getCouponDiscount(@array_sum(@$subtotal))); ?>">
                    <tr class="shipping">
                      <th>Coupon Discount</th>
                      <td><span class="amount">- Rs <?php echo e(\App\Http\Controllers\CartController::getCouponDiscount(@array_sum(@$subtotal))); ?></span></td>
                    </tr>
                    <?php else: ?>
                    <input type="hidden" id="coupon_amount" name="coupon_amount" value="0">
                    <?php endif; ?>
                    <?php if(auth()->guard()->guest()): ?>
                    <input type="hidden" id="wallet_amount" name="wallet_amount" value="0">
                    <?php else: ?>
                    <?php if($wallet > 0): ?>
                    <input type="hidden" id="wallet_amount" name="wallet_amount" value="<?php echo e($wallet); ?>">
                    <tr>
                      <th>Wallet</th>
                      <td><span class="amount">- RS <?php echo e($wallet); ?></span></td>
                    </tr>
                    <?php else: ?>
                    <input type="hidden" id="wallet_amount" name="wallet_amount" value="0">
                    <?php endif; ?>
                    <?php endif; ?>
                    <tr class="order-total">
                      <th>Order Total</th>
                      <td><strong><span class="amount">Rs <?php echo e($total_payable_amount); ?></span></strong>
                      </td>
                    </tr>
                  </tfoot>
                </table>
              </div>
				 <?php if($total_payable_amount==0): ?>
                    <div class="order-button-payment">
                        <input type="submit" class="submit" value="Place order" />
                    </div>
                <?php else: ?>
              <div class="payment_method">
                 <div class="">
                      <input name="check_method" type="radio" value="Cod" />
                      <label >Cash on Delivery</label>
                  </div>
                 <div class="">
                      <input name="check_method" type="radio" value="Online" checked/>
                      <label >Pay Online</label>
                  </div>
                  <div class="order-button-payment">
                    <input type="submit" class="submit" value="Place order" />
                  </div>
              </div>
				 <?php endif; ?>
            </div>
            </div>
                </div>

            </form>
    </div>
  </div>
{ <!-- checkout-area end -->  --}}
 <script src="<?php echo e(asset('public/assets')); ?>/js/vendor/jquery-1.12.4.min.js"></script>
  <script type="text/javascript">
  required_status = 1;
    $("#shipping_email").keyup(function(){
       var shipping_email = $('#shipping_email').val();
       var _token = "<?php echo e(@csrf_token()); ?>";
       $.ajax({
           url: "<?php echo e(url('checkEmail')); ?>",
           type: 'post',
         dataType: 'json',
           data: {
            email : shipping_email,
            _token: _token,
           },
           success: function (response) {
              if (response.email_message == 1) {
             $('.submit').attr('disabled', false);
               $('.email_message').html('');
               required_status = 0;
             }
              else{
               $('.submit').attr('disabled', true);
               $('.email_message').html(response.email_message);
               required_status = 1;
            }
           }
      });
   });


    $("#shipping_phone").keyup(function(){
    var shipping_phone = $('#shipping_phone').val();
    var _token = "<?php echo e(@csrf_token()); ?>";
    $.ajax({
    url: "<?php echo e(url('checkPhone')); ?>",
               type: 'post',
    dataType: 'json',
    data: {
                  phone : shipping_phone,
                  _token: _token,
                 },
               success: function (res) {
                   if (res.email_phone == 1) {
                     $('.submit').attr('disabled', false);
                     $('.email_phone').html('');
                      required_status = 0;
                  }
                  else{
                      $('.submit').attr('disabled', true);
                     $('.email_phone').html(res.email_phone);
                      required_status = 1;
                  }
                }
             });
          });


    </script>


























































































































































<?php /**PATH /var/www/vhosts/nakodaherbals.in/httpdocs/resources/views/includes/new-user-checkout.blade.php ENDPATH**/ ?>