<?php $__env->startSection('content'); ?>
<!--slider area start-->
<section class="slider_section mb-70">
    <div class="slider_area owl-carousel">
        <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="single_slider d-flex align-items-center" data-bgimg="<?php echo e(url('/')); ?>/public/uploads/images/<?php echo e($banner->image); ?>">
           <div class="container">
               <div class="row">
                   <div class="col-12">
                   </div>
               </div>
           </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</section>
<!--slider area end-->
<!--product area start-->
<section class="product_area mb-46">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="section_title">
                    <h2>Recent Products</h2>
                </div>
            </div>
        </div>  
        <div class="product_carousel product_column5 owl-carousel">
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $productimage = \App\Models\ProductImage::where('product_id',$product->id)->where('is_featured',1)->first(); ?>
            
            <article class="single_product">
                <figure>
                    <div class="product_thumb">
                        <a class="primary_img" href="<?php echo e(url('/')); ?>/p/<?php echo e($product->slug); ?>"><img src="<?php echo e(url('/')); ?>/public/uploads/images/<?php echo e($productimage->image); ?>" alt="<?php echo e($product->name); ?>"></a>
                        <div class="add_to_cart">
                            <a href="#" class="add-to-cart<?php echo $product->id; ?>" title="add to cart">Add to cart</a>
                        </div>
                    </div>
                    <figcaption class="product_content">
                       <div class="price_box">
                            <span class="old_price">&#8377;<?php echo e($product->mrp_price); ?></span>  
                            <span class="current_price">&#8377;<?php echo e($product->selling_price); ?></span>  
                        </div>
                        <h3 class="product_name"><a href="<?php echo e(url('/')); ?>/p/<?php echo e($product->slug); ?>"><?php echo e($product->name); ?></a></h3>
                    </figcaption>
                </figure>
            </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>   
    </div>
</section>
<!--product area end-->

     <!--our services area-->
<div class="our_services">
    <div class="container">   
        <div class="row">
            <div class="col-12">
                <div class="services_title">
                    <h2>OUR CATEGORIES</h2>
                </div>
            </div>
        </div>
        <div class="row">
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4 col-md-6 categ">
                <div class="services_item">
                     <div class="services_icone">
                         <a href="<?php echo e(url('/category')); ?>/<?php echo e($category->slug); ?>">
                            <img src="<?php echo e(url('/')); ?>/public/uploads/images/<?php echo e($category->logo); ?>" alt="<?php echo e($category->name); ?>">
                        </a> 
                    </div>
                    <div class="services_desc">
                        <h3><?php echo e($category->name); ?></h3>
                        <p><?php echo e($category->description); ?></p>
                        <a class="shop" href="<?php echo e(url('/category')); ?>/<?php echo e($category->slug); ?>">shop now</a>
                    </div>
                    <div class="services_arrow">
                         <a class="rightarrow" href="<?php echo e(url('/category')); ?>/<?php echo e($category->slug); ?>"><i class="arrow right"></i></a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>    
</div>

<!--shipping area end-->
<script src="<?php echo e(url('/')); ?>/public/assets/js/jquery.min.js"></script>
<?php foreach ($products as $product) { ?>
    <input type="hidden" class="product_id<?php echo e($product->id); ?>" value="<?php echo e($product->id); ?>">
    <script>
    $(document).ready(function(){
        $('.add-to-cart<?php echo $product->id; ?>').click(function(e){
            e.preventDefault();
            var product_id = $('.product_id<?php echo $product->id; ?>').val();
            $.ajax({
                url: '<?php echo e(url('add-to-cart')); ?>',
                method: "POST",
                data: {_token: '<?php echo e(csrf_token()); ?>', "product_id":product_id},
                dataType: "json",
                success: function (response) {
                    $(".mini_cart_wrapper").html(response.data);
                    Swal.fire(
                      'Added!',
                      'Product Added to Cart',
                      'success'
                    )
                }
            });
        });
    });
    </script>
<?php } ?>
<?php $__env->stopSection(); ?>
    
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/mxd/resources/views/welcome.blade.php ENDPATH**/ ?>