

<?php $__env->startSection('content'); ?>

<!--=============================================
    =            shop page content         =
    =============================================-->
<div class="shopping-cart-area mb-130 pt-100">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <!--=======  shop product content  =======-->
                <div class="shop-product">
                    <div class="row pb-100">
                        <div class="col-lg-6 mb-md-70 mb-sm-70">
                            <!--=======  shop product big image gallery  =======-->
                            <div class="shop-product__big-image-gallery-wrapper mb-30">
                                <!--=======  shop product gallery icons  =======-->
                                <div class="single-product__floating-badges">
                                    <span class="onsale"><?php echo e(round(100 - ($product->selling_price/$product->mrp_price)*100)); ?>%</span>
                                </div>
                                <div class="shop-product-rightside-icons">  <span class="wishlist-icon">
                                            <a onclick="addToWishList(<?php echo $product->id; ?>)" data-tippy="Add to wishlist" data-tippy-placement="left" data-tippy-inertia="true"
                                                data-tippy-animation="shift-away" data-tippy-delay="50" data-tippy-arrow="true"
                                                data-tippy-theme="sharpborder"><i class="ion-android-favorite-outline"></i></a>
                                        </span>
                                    <span class="enlarge-icon">
                                            <a class="btn-zoom-popup" href="#" data-tippy="Click to enlarge" data-tippy-placement="left"
                                                data-tippy-inertia="true" data-tippy-animation="shift-away" data-tippy-delay="50"
                                                data-tippy-arrow="true" data-tippy-theme="sharpborder"><i class="ion-android-expand"></i></a>
                                        </span>
                                </div>
                                <!--=======  End of shop product gallery icons  =======-->
                                <div class="shop-product__big-image-gallery-slider">
                                    <?php $__currentLoopData = $productImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productImage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="single-image">
                                        <img src="<?php echo e(url('/')); ?>/public/uploads/images/<?php echo e($productImage->image); ?>" class="img-fluid" alt="">
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <!--=======  End of shop product big image gallery  =======-->
                            <!--=======  shop product small image gallery  =======-->
                            <div class="shop-product__small-image-gallery-wrapper">
                                <div class="shop-product__small-image-gallery-slider">
                                    <?php $__currentLoopData = $productImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productImage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="single-image">
                                        <img src="<?php echo e(url('/')); ?>/public/uploads/images/<?php echo e($productImage->image); ?>" class="img-fluid" alt="">
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <!--=======  End of shop product small image gallery  =======-->
                        </div>
                        <div class="col-lg-6">
                            <!--=======  shop product description  =======-->
                            <div class="shop-product__description">
                                <!--=======  shop product navigation  =======-->
                                <!--=======  shop product title  =======-->
                                <div class="shop-product__title mb-15">
                                    <h2><?php echo e($product->name); ?></h2>
                                    <span class="style"> (<?php echo e($product->SKU); ?>)</span>
                                </div>
                                <!--=======  End of shop product title  =======-->
                                <!--=======  shop product price  =======-->
                                <div class="shop-product__price mb-30"> <span class="main-price discounted">&#x20B9; <?php echo e($product->mrp_price); ?></span>
                                    <span class="discounted-price">&#x20B9; <?php echo e($product->selling_price); ?></span>
                                </div>
                                <?php
                                    $product->description = preg_replace("/^<p.*?>/", "",$product->description);
                                    $product->description = preg_replace("|</p>$|", "",$product->description);
                                ?>
                                <!--=======  End of shop product price  =======-->
                                <!--=======  shop product short description  =======-->
                                <div class="shop-product__short-desc mb-50"><?php echo e($product->description); ?></div>
                                <!--=======  End of shop product short description  =======-->
                                <!--=======  shop product size block  =======-->
                                <div class="shop-product__block shop-product__block--size mb-20">
                                    <div class="shop-product__block__title">Size:</div>
                                    <div class="shop-product__block__value">
                                        <div class="shop-product-size-list">    
                                            <select class="form-control size_id" name="time">
                                                <?php $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(@in_array(@$size->id,@$size_id)): ?>
                                                      <option value="<?php echo e($size->id); ?>"><?php echo e($size->name); ?></option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <!--=======  End of shop product size block  =======-->
                                <!--=======  shop product color block  =======-->
                                <div class="shop-product__block shop-product__block--color mb-20">
                                    <div class="shop-product__block__title">Color:</div>
                                    <div class="shop-product__block__value">
                                        <div class="shop-product-color-list">
                                            <select class="form-control color_id" name="time">
                                                <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(@in_array(@$color->id,@$color_id)): ?>
                                                      <option value="<?php echo e($color->id); ?>"><?php echo e($color->name); ?></option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <!--=======  End of shop product color block  =======-->
                                <!--=======  shop product quantity block  =======-->
                                <div class="shop-product__block shop-product__block--quantity mb-40">
                                    <div class="shop-product__block__title">Quantity:</div>
                                    <div class="shop-product__block__value">
                                        <div class="pro-qty d-inline-block mx-0 pt-0">
                                            <input type="text" id="quantity" value="1">
                                        </div>
                                    </div>
                                </div>
                                <!--=======  End of shop product quantity block  =======-->
                                <!--=======  shop product buttons  =======-->
                                <div class="shop-product__buttons mb-40">   <a class="lezada-button lezada-button--medium" onclick="addToCart(<?php echo $product->id; ?>)">add to cart</a>
                                </div>
                                <!--=======  End of shop product buttons  =======-->
                                <!--=======  shop product brands  =======-->
                                <div class="shop-product__brands mb-20">
                                    <a href="#">
                                        <img src="<?php echo e(url('/')); ?>/public/assets/images/brands/brand-1.png" class="img-fluid" alt="">
                                    </a>
                                    <a href="#">
                                        <img src="<?php echo e(url('/')); ?>/public/assets/images/brands/brand-2.png" class="img-fluid" alt="">
                                    </a>
                                </div>
                                <!--=======  End of shop product brands  =======-->
                                <!--=======  other info table  =======-->
                                <div class="quick-view-other-info pb-0">
                                    <table>
                                        <tr class="single-info">
                                            <td class="quickview-title">SKU:</td>
                                            <td class="quickview-value"><?php echo e($product->SKU); ?></td>
                                        </tr>
                                        <tr class="single-info">
                                            <td class="quickview-title">Category:</td>
                                            <td class="quickview-value">
                                                <a href=""><?php echo e($product->category->name); ?></a>
                                            </td>
                                        </tr>
                                        <tr class="single-info">
                                            <td class="quickview-title">Share on:</td>
                                            <td class="quickview-value">
                                                <ul class="quickview-social-icons">
                                                    <li><a href="#"><i class="fa fa-facebook"></i></a>
                                                    </li>
                                                    <li><a href="#"><i class="fa fa-twitter"></i></a>
                                                    </li>
                                                    <li><a href="#"><i class="fa fa-google-plus"></i></a>
                                                    </li>
                                                    <li><a href="#"><i class="fa fa-pinterest"></i></a>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <!--=======  End of other info table  =======-->
                            </div>
                            <!--=======  End of shop product description  =======-->
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <!--=======  shop product description tab  =======-->
                            <div class="shop-product__description-tab pt-100">
                                <!--=======  tab navigation  =======-->
                                <div class="tab-product-navigation tab-product-navigation--product-desc mb-50">
                                    <div class="nav nav-tabs justify-content-center" id="nav-tab2" role="tablist">  <a class="nav-item nav-link active" id="product-tab-1" data-toggle="tab" href="#product-series-1" role="tab" aria-selected="true">Description</a>
                                        <a class="nav-item nav-link" id="product-tab-2" data-toggle="tab" href="#product-series-2" role="tab" aria-selected="false">Additional information</a>
                                    </div>
                                </div>
                                <!--=======  End of tab navigation  =======-->
                                <!--=======  tab content  =======-->
                                <div class="tab-content" id="nav-tabContent2">
                                    <div class="tab-pane fade show active" id="product-series-1" role="tabpanel" aria-labelledby="product-tab-1">
                                        <!--=======  shop product long description  =======-->
                                        <div class="shop-product__long-desc mb-30">
                                            <p><?php echo e($product->description); ?></p>
                                        </div>
                                        <!--=======  End of shop product long description  =======-->
                                    </div>
                                    <div class="tab-pane fade" id="product-series-2" role="tabpanel" aria-labelledby="product-tab-2">
                                        <!--=======  shop product additional information  =======-->
                                        <div class="shop-product__additional-info">
                                            <table class="shop-attributes">
                                                <tbody>
                                                    <tr>
                                                        <th>Size</th>
                                                        <td>
                                                            <p><?php $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(@in_array(@$size->id,@$size_id)): ?>
                                                      <?php echo e($size->name); ?>,
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Color</th>
                                                        <td>
                                                            <p><?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(@in_array(@$color->id,@$color_id)): ?>
                                                      <?php echo e($color->name); ?>, 
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></p>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <!--=======  End of shop product additional information  =======-->
                                    </div>
                                </div>
                                <!--=======  End of tab content  =======-->
                            </div>
                            <!--=======  End of shop product description tab  =======-->
                        </div>
                    </div>
                </div>
                <!--=======  End of shop product content  =======-->
            </div>
        </div>
    </div>
</div>
<!--=====  End of shop page content  ======-->
<div class="banner-with-product-area">
    <div class="container wide">
        <h2 class="text-left pb-4" style="font-weight: bold;">Similar Products</h2>
        <div class="row">
          <?php $__currentLoopData = $similar_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $similar_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php $productImage = \App\Models\ProductImage::where('product_id',$similar_product->id)->where('is_featured',1)->first();?>
            <div class="col-12 col-lg-3 col-md-6 col-sm-6 mb-45">
                <div class="single-product">
                    <!--=======  single product image  =======-->
                    <div class="single-product__image">
                        <a class="image-wrap" href="<?php echo e(url('p')); ?>/<?php echo e($similar_product->slug); ?>">
                            <img src="<?php echo e(url('/')); ?>/public/uploads/images/<?php echo e($productImage->image); ?>" class="img-fluid" alt="<?php echo e($similar_product->name); ?>">
                             <img src="<?php echo e(url('/')); ?>/public/uploads/images/<?php echo e($productImage->image); ?>" class="img-fluid" alt="<?php echo e($similar_product->name); ?>">
                        </a>
                        <div class="single-product__floating-badges"></div>
                        <div class="single-product__floating-icons"> <span class="wishlist">
                          <a href="#" data-tippy="Add to wishlist" data-tippy-inertia="true"
                            data-tippy-animation="shift-away" data-tippy-delay="50" data-tippy-arrow="true"
                            data-tippy-theme="sharpborder" data-tippy-placement="left"><i
                              class="ion-android-favorite-outline"></i>
                            </a></span>
                            <span class="quickview"><a class="cd-trigger" href="#qv-<?php echo e($similar_product->id); ?>" data-tippy="Quick View"
                            data-tippy-inertia="true" data-tippy-animation="shift-away" data-tippy-delay="50"
                            data-tippy-arrow="true" data-tippy-theme="sharpborder" data-tippy-placement="left"><i
                              class="ion-ios-search-strong"></i></a></span>
                        </div>
                    </div>
                    <!--=======  End of single product image  =======-->
                    <!--=======  single product content  =======-->
                    <div class="single-product__content">
                        <div class="title">
                            <h3> <a href="<?php echo e(url('p')); ?>/<?php echo e($similar_product->slug); ?>"><?php echo e(@$similar_product->name); ?></a></h3>
                            <a href="#">Add to cart</a>
                        </div>
                        <div class="price"> <span class="main-price discounted">&#x20B9; <?php echo e(@$similar_product->mrp_price); ?></span>
                            <span class="discounted-price">&#x20B9; <?php echo e(@$similar_product->selling_price); ?></span>
                        </div>
                    </div>
                    <!--=======  End of single product content  =======-->
                </div>
            </div>
            <!--=======  End of single product  =======-->
          <!--=====  Product Modal  ======-->
            <div id="qv-<?php echo e($similar_product->id); ?>" class="cd-quick-view">
                <div class="cd-slider-wrapper">
                    <ul class="cd-slider">

                        <li class="selected">
                            <img src="<?php echo e(url('/')); ?>/public/uploads/images/<?php echo e($productImage->image); ?>" alt="<?php echo e($similar_product->name); ?>">
                        </li>
                        <li>
                            <img src="<?php echo e(url('/')); ?>/public/uploads/images/<?php echo e($productImage->image); ?>" alt="<?php echo e($similar_product->name); ?>">
                        </li>
                    </ul>
                    <!-- cd-slider -->
                    <ul class="cd-slider-pagination">
                        <li class="active"><a href="#0">1</a>
                        </li>
                        <li><a href="#1">2</a>
                        </li>
                    </ul>
                    <!-- cd-slider-pagination -->
                    <ul class="cd-slider-navigation">
                        <li><a class="cd-prev" href="#0">Prev</a>
                        </li>
                        <li><a class="cd-next" href="#0">Next</a>
                        </li>
                    </ul>
                    <!-- cd-slider-navigation -->
                </div>
                <!-- cd-slider-wrapper -->
                <div class="lezada-item-info cd-item-info ps-scroll">
                    <h2 class="item-title"><?php echo e($similar_product->name); ?></h2>
                    <p class="price"> <span class="main-price discounted">&#x20B9; <?php echo e($similar_product->mrp_price); ?></span>
                        <span class="discounted-price">&#x20B9; <?php echo e($similar_product->selling_price); ?></span>
                    </p>
                    <p class="description"><?php echo $similar_product->description = preg_replace("|</p>$|", "",$similar_product->description); ?></p> <span class="quickview-title">Quantity:</span>
                    <div class="pro-qty d-inline-block mb-40">
                        <input type="text" value="1">
                    </div>
                    <div class="add-to-cart-btn mb-25">
                        <button class="lezada-button lezada-button--medium">add to cart</button>
                    </div>
                    <div class="quick-view-other-info">
                        <table>
                            <tr class="single-info">
                                <td class="quickview-title">SKU:</td>
                                <td class="quickview-value"><?php echo e($similar_product->SKU); ?></td>
                            </tr>
                            <tr class="single-info">
                                <td class="quickview-title">Categories:</td>
                                <td class="quickview-value"> <a href="<?php echo e(url('/category')); ?>/<?php echo e($similar_product->category->slug); ?>"><?php echo e($similar_product->category->name); ?></a>
                                </td>
                            </tr>
                            <tr class="single-info">
                                <td class="quickview-title">Share on:</td>
                                <td class="quickview-value">
                                    <ul class="quickview-social-icons">
                                        <li><a href="https://facebook.com/sharer/sharer.php?u=<?php echo e(url('/p')); ?>/<?php echo e($similar_product->slug); ?>"><i class="fa fa-facebook"></i></a>
                                        </li>
                                        <li><a href="https://twitter.com/intent/tweet/?url=<?php echo e(url('/p')); ?>/<?php echo e($similar_product->slug); ?>"><i class="fa fa-twitter"></i></a>
                                        </li>
                                    </ul>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
                <!-- cd-item-info --> <a href="#<?php echo e($similar_product->id); ?>" class="cd-close">Close</a>
            </div>
            <!--=====  Product Modal  ======-->
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<!--=====  End of banner with product area  ======-->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tera/resources/views/listing/product-details.blade.php ENDPATH**/ ?>