<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
       <div class="row">
        <div class="col-md-12">
          <div class="card">
              <div class="card-header">
                <h3 class="card-title">Products</h3>
                <a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary float-right">Create</a>
              </div>
              <?php if(Session::has('flash_success')): ?>
                  <div class="alert alert-success">
                      <button type="button" class="close" data-dismiss="alert">×</button>
                  <?php echo e(Session::get('flash_success')); ?>

                  </div>
              <?php endif; ?>
              <!-- /.card-header -->
              <div class="card-body">
                <table class="table table-bordered">
                  <thead>                  
                    <tr>
                      <th>Image</th>
                      <th>Name</th>
                      <th>SKU</th>
                      <th>Color</th>
                      <th>Size</th>
                      <th>Status</th>
                      <th>Mrp Price</th>
                      <th>Selling Price</th>
                      <th>Category</th>
                      <th>Subategory</th>
                      <th>Action</th>
                    </tr> 
                  </thead>
                  <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php 
                    $productImage = \App\Models\ProductImage::where('product_id',$row->id)->where('is_featured',1)->first(); 
                    $category = \App\Models\Category::where('id',$row->category_id)->first();
                    $subcategory = \App\Models\Category::where('id',$row->subcategory_id)->first();
                    ?>
                    <tr>
                      <td>
                        <img src="<?php echo e(URL::to('/')); ?>/public/uploads/images/<?php echo e(@$productImage->image); ?>" style="width: 100px;" />
                      </td>
                      <td><?php echo e(@$row->name); ?></td>
                      <td><?php echo e(@$row->SKU); ?></td>
                      <td>
                      <?php @$color_id = explode(',', $row->color_id); ?>
                        <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(@in_array(@$color->id,@$color_id)): ?>
                              <?php echo e($color->name); ?>, 
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </td>
                      <td>
                      <?php @$size_id = explode(',', $row->size_id); ?>
                        <?php $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(@in_array(@$size->id,@$size_id)): ?>
                              <?php echo e($size->name); ?>, 
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </td>
                      <td><?php echo e(@$row->status); ?></td>
                      <td>&#x20B9;<?php echo e(@$row->mrp_price); ?></td>
                      <td>&#x20B9;<?php echo e(@$row->selling_price); ?></td>
                      <td><?php echo e(@$category->name); ?></td>
                      <td>
                          <?php echo e(@$subcategory->name); ?>

                      </td>
                      <td>
                        <a href="<?php echo e(route('products.edit', $row->id)); ?>" class="btn"><i class="fas fa-edit" style="color: blue;"></i></a>
                        <button form="resource-delete-<?php echo e($row->id); ?>"><i style="color: red;" class="fas fa-trash-alt"></i></button>
                        <form id="resource-delete-<?php echo e($row->id); ?>" action="<?php echo e(route('products.destroy', $row->id)); ?>" style="display: inline-block;" onSubmit="return confirm('Are you sure you want to delete this item?');" method="post">
                          <?php echo csrf_field(); ?>
                          <?php echo method_field('DELETE'); ?>
                        </form>
                      </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                </table>
                <br>
                <?php echo $data->links(); ?>

              </div>
              <!-- /.card-body -->
              
        </div>
        <!-- /.card -->
        </div>
       </div>
      </div><!-- /.container-fluid -->
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/tera/resources/views/admin/products/index.blade.php ENDPATH**/ ?>