<?php $__env->startSection('content'); ?>
<script src="https://code.jquery.com/jquery-1.12.4.js"></script>
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
       <div class="row">
        <div class="col-md-12">
          <div class="card">
            <?php if(Session::has('flash_success')): ?>
                  <div class="alert alert-success">
                      <button type="button" class="close" data-dismiss="alert">×</button>
                  <?php echo e(Session::get('flash_success')); ?>

                  </div>
              <?php endif; ?>
              <!-- /.card-header -->
              <div class="card-body">
                <table class="table table-bordered">
                  <thead>                  
                    <tr>
                      <th>Order id</th>
                      <th>Payable Price</th>
                      <th>Name</th>
                      <th>Email</th>
                      <th>Phone</th>
                      <th>Order Status</th>
                      <th>Ordered Date</th>
                      <th>Delivered Date</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td><a href="<?php echo e(url('admin/order')); ?>/?order_id=<?php echo e($row->order_id); ?>"><?php echo e($row->order_id); ?></a></td>
                      <td>&#8377;<?php echo e(@$row->payable_price); ?></td>
                      <td><?php echo e(@$row->name); ?></td>
                      <td><?php echo e(@$row->email); ?></td>
                      <td><?php echo e(@$row->phone); ?></td>
                      <td><?php echo e(@$row->status); ?>

                         <?php if($row->status != "OrderDelivered"): ?>
                        <button type="button" class="btn btn-info" data-toggle="modal" data-target="#modal">
                        Change Status
                      </button><?php endif; ?></td>
                      <td><?php echo e(\Carbon\Carbon::parse($row->created_at)->format('jS M Y')); ?></td>
                      <td><?php echo e($row->delivered_date); ?></td>
                    </tr>
                    <div class="modal fade" id="modal">
                        <div class="modal-dialog modal-sm">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h4 class="modal-title">Change Status</h4>
                              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                              </button>
                            </div>
                            <div class="modal-body">
                              <div class="col-sm-12">
                                <form method="post" action="<?php echo e(url('/admin/changeOrderStatus')); ?>">
                                  <?php echo csrf_field(); ?>
                                  <div class="form-group">
                                    <label>Select Status</label>
                                    <select class="form-control" name="order_status">
                                      <option <?php if($row->status == "OrderPlaced"): ?> selected <?php endif; ?> value="OrderPlaced">OrderPlaced</option>
                                      <option <?php if($row->status == "OrderPacked"): ?> selected <?php endif; ?> value="OrderPacked">OrderPacked</option>
                                      <option <?php if($row->status == "OrderShipped"): ?> selected <?php endif; ?> value="OrderShipped">OrderShipped</option>
                                      <option <?php if($row->status == "OrderDelivered"): ?> selected <?php endif; ?> value="OrderDelivered">OrderDelivered</option>
                                    </select>
                                    <input type="hidden" name="order_id" value="<?php echo e(@$row->order_id); ?>">
                                  </div>
                                  <div class="text-center"> 
                                   <button type="submit" class="btn btn-primary">Submit</button>
                                  </div>
                                </form>
                              </div>
                            </div>
                          </div>
                          <!-- /.modal-content -->
                        </div>
                    </div>
                  <!-- /.modal -->
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
              <?php echo $orders->links(); ?>

        </div>
        <!-- /.card -->
        </div>
       </div>
      </div><!-- /.container-fluid -->
    </section>
<script>
  $( function() {
    $( "#txtFromDate" ).datepicker();
    $( "#txtToDate" ).datepicker();
  } );
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nakoda/resources/views/admin/orders/index.blade.php ENDPATH**/ ?>