<!DOCTYPE html>
<html lang="en">
<head>
    <title><?php echo e(@$title); ?></title>
    <meta charset="UTF-8">
     <meta name="description" content= "<?php echo e(@$desc); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
<!--===============================================================================================-->  
    <link rel="icon" type="image/png" href="<?php echo e(asset('public/assets/images/icons/favicon.png')); ?>"/>
<!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/vendor/bootstrap/css/bootstrap.min.css')); ?>">
<!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/fonts/font-awesome-4.7.0/css/font-awesome.min.css')); ?>">
<!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/fonts/iconic/css/material-design-iconic-font.min.css')); ?>">
<!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/fonts/linearicons-v1.0.0/icon-font.min.css')); ?>">
<!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/vendor/animate/animate.css')); ?>">
<!--===============================================================================================-->  
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/vendor/css-hamburgers/hamburgers.min.css')); ?>">
<!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/vendor/animsition/css/animsition.min.css')); ?>">
<!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/vendor/select2/select2.min.css')); ?>">
<!--===============================================================================================-->  
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/vendor/daterangepicker/daterangepicker.css')); ?>">
<!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/vendor/slick/slick.css')); ?>">
<!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/vendor/MagnificPopup/magnific-popup.css')); ?>">
<!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/vendor/perfect-scrollbar/perfect-scrollbar.css')); ?>">
<!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/css/util.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('public/assets/css/main.css')); ?>">
    <script src="<?php echo e(asset('public/assets/vendor/jquery/jquery-3.2.1.min.js')); ?>"></script>

<!--===============================================================================================-->
</head>
<body class="animsition">
    
    <!--- Header Code Start -->
      <!-- Header -->
    <header class="header-v3">
        <!-- Header desktop -->
        <div class="container-menu-desktop trans-03">
            <div class="wrap-menu-desktop">
                <nav class="limiter-menu-desktop p-l-45">
                    
                    <!-- Logo desktop -->       
                    <a href="<?php echo e(url('/')); ?>" class="logo">
                        <img src="<?php echo e(url('/')); ?>/public/assets/images/icons/naari-logo.png" alt="IMG-LOGO">
                    </a>

                    <!-- Menu desktop -->
                    <div class="menu-desktop">
                        <ul class="main-menu">
                            <li>
                                <a href="<?php echo e(url('/')); ?>">Home</a>
                            <li>
                                <a href="#">Shop</a>
                                <ul class="sub-menu">
                                    <?php $categories = \App\Models\Category::whereNull('parent_id')->where('status','Active')->orderBy('id','ASC')->get(); ?>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e(url('/category')); ?>/<?php echo e($category->slug); ?>"><?php echo e($category->name); ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </li>

                            <li>
                                <a href="<?php echo e(url('about')); ?>">About</a>
                            </li>

                            <li>
                                <a href="<?php echo e(url('contact')); ?>">Contact</a>
                            </li>
                        </ul>
                    </div>  
                    <?php $falsh = \App\Models\Flash::first(); ?>
                    <!-- Icon header -->
                    <div class="wrap-icon-header flex-w flex-r-m h-full">   
                        <div class="flex-c-m h-full p-r-25 bor6">
                            <div class="blink_me"><?php echo e(@$falsh->name); ?></div>
                        </div>
                         
                        <div class="flex-c-m h-full p-r-25 bor6">
                            <?php echo $__env->make('includes.cart-home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                            
                        <div class="flex-c-m h-full p-lr-19">
                            <div class="icon-header-item cl0 hov-cl1 trans-04 p-lr-11 js-show-sidebar">
                                <i class="zmdi zmdi-menu"></i>
                            </div>
                        </div>
                    </div>
                </nav>
            </div>  
        </div>

        <!-- Header Mobile -->
        <div class="wrap-header-mobile">
            <!-- Logo moblie -->        
            <div class="logo-mobile">
                <a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(url('/')); ?>/public/assets/images/icons/naari-logo.png" alt="IMG-LOGO"></a>
                <!--<a href="index.php"><h3 style="color: #fff;font-family: PlayfairDisplay-Regular;">NAARI</h3></a>-->
            </div>

            <!-- Icon header -->
            <div class="wrap-icon-header flex-w flex-r-m h-full m-r-15">
                <div class="flex-c-m h-full p-r-5">
                    <?php echo $__env->make('includes.cart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>

            <!-- Button show menu -->
            <div class="btn-show-menu-mobile hamburger hamburger--squeeze">
                <span class="hamburger-box">
                    <span class="hamburger-inner"></span>
                </span>
            </div>
        </div>


        <!-- Menu Mobile -->
        <div class="menu-mobile">
            <ul class="main-menu-m">
                <li>
                    <a href="<?php echo e(url('/')); ?>">Home</a>
                </li>
                <li>
                    <a href="#">Shop</a>
                    <ul class="sub-menu-m">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><a href="<?php echo e(url('/category')); ?>/<?php echo e($category->slug); ?>"><?php echo e($category->name); ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <span class="arrow-main-menu-m">
                        <i class="fa fa-angle-right" aria-hidden="true"></i>
                    </span>
                </li>
                <li>
                    <a href="<?php echo e(url('about')); ?>">About</a>
                </li>

                <li>
                    <a href="<?php echo e(url('contact')); ?>">Contact</a>
                </li>
            </ul>
        </div>

        <!-- Modal Search -->
        <div class="modal-search-header flex-c-m trans-04 js-hide-modal-search">
            <button class="flex-c-m btn-hide-modal-search trans-04">
                <i class="zmdi zmdi-close"></i>
            </button>

            <form class="container-search-header">
                <div class="wrap-search-header">
                    <input class="plh0" type="text" name="search" placeholder="Search...">

                    <button class="flex-c-m trans-04">
                        <i class="zmdi zmdi-search"></i>
                    </button>
                </div>
            </form>
        </div>
    </header>


    <!-- Sidebar -->
    <aside class="wrap-sidebar js-sidebar">
        <div class="s-full js-hide-sidebar"></div>

        <div class="sidebar flex-col-l p-t-22 p-b-25">
            <div class="flex-r w-full p-b-30 p-r-27">
                <div class="fs-35 lh-10 cl2 p-lr-5 pointer hov-cl1 trans-04 js-hide-sidebar">
                    <i class="zmdi zmdi-close"></i>
                </div>
            </div>

            <div class="sidebar-content flex-w w-full p-lr-65 js-pscroll">
                <ul class="sidebar-link w-full">
                    <li class="p-b-13">
                        <a href="<?php echo e(url('/')); ?>" class="stext-102 cl2 hov-cl1 trans-04">
                            Home
                        </a>
                    </li>

                    <li class="p-b-13">
                        <a href="<?php echo e(url('wishlist')); ?>" class="stext-102 cl2 hov-cl1 trans-04">
                            My Wishlist
                        </a>
                    </li>
                    <?php if(auth()->guard()->guest()): ?>
                    <li class="p-b-13">
                        <a href="<?php echo e(url('login')); ?>" class="stext-102 cl2 hov-cl1 trans-04">
                            Login
                        </a>
                    </li>
                    <li class="p-b-13">
                        <a href="<?php echo e(url('register')); ?>" class="stext-102 cl2 hov-cl1 trans-04">
                            Register
                        </a>
                    </li>
                    <?php else: ?>
                    <li class="p-b-13">
                        <a href="<?php echo e(url('account')); ?>" class="stext-102 cl2 hov-cl1 trans-04">
                            My Account
                        </a>
                    </li>
                    <li class="p-b-13">
                        <a class="stext-102 cl2 hov-cl1 trans-04" onclick="event.preventDefault();
                         document.getElementById('logout-form').submit();" href="<?php echo e(url('logout')); ?>"> Logout</a>
                        <form id="logout-form" action="<?php echo e(url('logout')); ?>" method="POST" style="display: none;">
                            <?php echo e(csrf_field()); ?>

                        </form>
                    </li>
                    <?php endif; ?>
                    

                    <li class="p-b-13">
                        <a href="<?php echo e(url('faq')); ?>" class="stext-102 cl2 hov-cl1 trans-04">
                            Help & FAQs
                        </a>
                    </li>
                </ul>

                <div class="sidebar-gallery w-full">
                    <span class="mtext-101 cl5">
                        About Us
                    </span>

                    <p class="stext-108 cl6 p-t-27">
                        Naari is an online boutique offering wide variety of clothing for women's. Naari establishes in year 2017, started with offline store and now moving into online.
                    </p>
                </div>
            </div>
        </div>
    </aside>


    <!-- Cart -->
    <div class="wrap-header-cart js-panel-cart">
        <div class="s-full js-hide-cart"></div>

        <div class="header-cart flex-col-l p-l-65 p-r-25">
            <div class="header-cart-title flex-w flex-sb-m p-b-8">
                <span class="mtext-103 cl2">
                    Your Cart
                </span>

                <div class="fs-35 lh-10 cl2 p-lr-5 pointer hov-cl1 trans-04 js-hide-cart">
                    <i class="zmdi zmdi-close"></i>
                </div>
            </div>
            <?php  
            $carts = \App\Models\Cart::where('session_id',\Session::getId())->get(); 
            foreach ($carts as $cart) {
                $subtotal_min[] = $cart->product->selling_price*$cart->quantity;
            }
            ?>
            <div class="header-cart-content flex-w js-pscroll">
                <ul class="header-cart-wrapitem w-full">
                    <?php $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $productimage = \App\Models\ProductImage::where('product_id',$cart->product_id)->where('is_featured',1)->first(); ?>
                    <li class="header-cart-item flex-w flex-t m-b-12">
                        <div class="header-cart-item-img">
                            <img src="<?php echo e(url('/')); ?>/public/uploads/images/<?php echo e($productimage->image); ?>" alt="<?php echo e($cart->product->name); ?>">
                        </div>

                        <div class="header-cart-item-txt p-t-8">
                            <a href="lehengas.php" class="header-cart-item-name m-b-18 hov-cl1 trans-04">
                                <?php echo e($cart->product->name); ?>

                            </a>

                            <span class="header-cart-item-info">
                                <?php echo e($cart->quantity); ?> x <?php echo e($cart->product->selling_price); ?>

                            </span>
                        </div>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                
                <div class="w-full">
                    <div class="header-cart-total w-full p-tb-40">
                        Total: <?php echo e(@array_sum($subtotal_min)); ?>

                    </div>

                    <div class="header-cart-buttons flex-w w-full">
                        <a href="<?php echo e(url('cart')); ?>" class="flex-c-m stext-101 cl0 size-107 bg3 bor2 hov-btn3 p-lr-15 trans-04 m-r-8 m-b-10">
                            View Cart
                        </a>

                        <a href="<?php echo e(url('checkout')); ?>" class="flex-c-m stext-101 cl0 size-107 bg3 bor2 hov-btn3 p-lr-15 trans-04 m-b-10">
                            Check Out
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--- Header Code End -->
    <?php echo $__env->yieldContent('content'); ?>
    <!--/ footer start -->
     <!-- Footer -->
    <footer class="bg3 p-t-75 p-b-32">
        <div class="container">
            <div class="row">
                <div class="col-sm-6 col-lg-3 p-b-50">
                    <h4 class="stext-301 cl0 p-b-30">
                        Categories
                    </h4>                        
                    <ul>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="p-b-10">
                            <a href="<?php echo e(url('/category')); ?>/<?php echo e($category->slug); ?>" class="stext-107 cl7 hov-cl1 trans-04">
                                <?php echo e($category->name); ?>

                            </a>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>

                <div class="col-sm-6 col-lg-3 p-b-50">
                    <h4 class="stext-301 cl0 p-b-30">
                        Help
                    </h4>

                    <ul>
                        <li class="p-b-10">
                            <a href="#" class="stext-107 cl7 hov-cl1 trans-04">
                                Track Order
                            </a>
                        </li>

                        <li class="p-b-10">
                            <a href="#" class="stext-107 cl7 hov-cl1 trans-04">
                                Returns 
                            </a>
                        </li>

                        <li class="p-b-10">
                            <a href="#" class="stext-107 cl7 hov-cl1 trans-04">
                                Shipping
                            </a>
                        </li>

                        <li class="p-b-10">
                            <a href="#" class="stext-107 cl7 hov-cl1 trans-04">
                                FAQs
                            </a>
                        </li>
                    </ul>
                </div>

                <div class="col-sm-6 col-lg-3 p-b-50">
                    <h4 class="stext-301 cl0 p-b-30">
                        GET IN TOUCH
                    </h4>

                    <p class="stext-107 cl7 size-201">
                        Any questions? Let us know in store at 143/6, 4th Cross, 6th Main, 3rd A Cross, Gauravnagar, J P Nagar 7th Phase, Bangalore 560078 or call us on <br/>
                        (+91) 73 3856 8804
                    </p>

                    <div class="p-t-27">
                        <a href="#" class="fs-18 cl7 hov-cl1 trans-04 m-r-16">
                            <i class="fa fa-facebook"></i>
                        </a>

                        <a href="#" class="fs-18 cl7 hov-cl1 trans-04 m-r-16">
                            <i class="fa fa-instagram"></i>
                        </a>

                        <a href="#" class="fs-18 cl7 hov-cl1 trans-04 m-r-16">
                            <i class="fa fa-pinterest-p"></i>
                        </a>
                    </div>
                </div>

                <div class="col-sm-6 col-lg-3 p-b-50">
                    <h4 class="stext-301 cl0 p-b-30">
                        Newsletter
                    </h4>

                    <form method="post" action="<?php echo e(url('subscribeNewsLetter')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="wrap-input1 w-full p-b-4">
                            <input class="input1 bg-none plh1 stext-107 cl7" type="email" name="email" placeholder="email@example.com" required="">
                            <div class="focus-input1 trans-04"></div>
                        </div>

                        <div class="p-t-18">
                            <button class="flex-c-m stext-101 cl0 size-103 bg1 bor1 hov-btn2 p-lr-15 trans-04">
                                Subscribe
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <div class="p-t-40">
                <div class="flex-c-m flex-w p-b-18">
                    <a href="#" class="m-all-1">
                        <img src="<?php echo e(url('/')); ?>/public/assets/images/icons/icon-pay-01.png" alt="ICON-PAY">
                    </a>

                    <a href="#" class="m-all-1">
                        <img src="<?php echo e(url('/')); ?>/public/assets/images/icons/icon-pay-02.png" alt="ICON-PAY">
                    </a>

                    <a href="#" class="m-all-1">
                        <img src="<?php echo e(url('/')); ?>/public/assets/images/icons/icon-pay-03.png" alt="ICON-PAY">
                    </a>

                    <a href="#" class="m-all-1">
                        <img src="<?php echo e(url('/')); ?>/public/assets/images/icons/icon-pay-04.png" alt="ICON-PAY">
                    </a>

                    <a href="#" class="m-all-1">
                        <img src="<?php echo e(url('/')); ?>/public/assets/images/icons/icon-pay-05.png" alt="ICON-PAY">
                    </a>
                </div>

                <p class="stext-107 cl6 txt-center">
                    <!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. -->
                        Copyright &copy;<script>document.write(new Date().getFullYear());</script> All rights reserved | This template is made with <i class="fa fa-heart-o" aria-hidden="true"></i> by <a href="https://webdigitalmantra.in" target="_blank">Web Digital Mantra</a>
                    <!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. -->

                </p>
            </div>
        </div>
    </footer>
    <!--/ footer end  -->
    
    <!-- Back to top -->
    <div class="btn-back-to-top" id="myBtn">
        <span class="symbol-btn-back-to-top">
            <i class="zmdi zmdi-chevron-up"></i>
        </span>
    </div>
<!--===============================================================================================-->
    <script src="<?php echo e(asset('public/assets/vendor/animsition/js/animsition.min.js')); ?>"></script>
<!--===============================================================================================-->
    <script src="<?php echo e(asset('public/assets/vendor/bootstrap/js/popper.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/vendor/bootstrap/js/bootstrap.min.js')); ?>"></script>
<!--===============================================================================================-->
    <script src="<?php echo e(asset('public/assets/vendor/select2/select2.min.js')); ?>"></script>
    <script>
        $(".js-select2").each(function(){
            $(this).select2({
                minimumResultsForSearch: 20,
                dropdownParent: $(this).next('.dropDownSelect2')
            });
        })
    </script>
<!--===============================================================================================-->
    <script src="<?php echo e(asset('public/assets/vendor/daterangepicker/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/vendor/daterangepicker/daterangepicker.js')); ?>"></script>
<!--===============================================================================================-->
    <script src="<?php echo e(asset('public/assets/vendor/slick/slick.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/slick-custom.js')); ?>"></script>
<!--===============================================================================================-->
    <script src="<?php echo e(asset('public/assets/vendor/parallax100/parallax100.js')); ?>"></script>
    <script>
        $('.parallax100').parallax100();
    </script>
<!--===============================================================================================-->
    <script src="<?php echo e(asset('public/assets/vendor/MagnificPopup/jquery.magnific-popup.min.js')); ?>"></script>
    <script>
        $('.gallery-lb').each(function() { // the containers for all your galleries
            $(this).magnificPopup({
                delegate: 'a', // the selector for gallery item
                type: 'image',
                gallery: {
                    enabled:true
                },
                mainClass: 'mfp-fade'
            });
        });
    </script>
<!--===============================================================================================-->
    <script src="<?php echo e(asset('public/assets/vendor/isotope/isotope.pkgd.min.js')); ?>"></script>
<!--===============================================================================================-->
<!--===============================================================================================-->
    <script src="<?php echo e(asset('public/assets/vendor/perfect-scrollbar/perfect-scrollbar.min.js')); ?>"></script>
    <script>
        $('.js-pscroll').each(function(){
            $(this).css('position','relative');
            $(this).css('overflow','hidden');
            var ps = new PerfectScrollbar(this, {
                wheelSpeed: 1,
                scrollingThreshold: 1000,
                wheelPropagation: false,
            });

            $(window).on('resize', function(){
                ps.update();
            })
        });
    </script>
    <script src="<?php echo e(asset('public/assets/js/main.js')); ?>"></script>
<!--===============================================================================================-->
    
</body>
</html><?php /**PATH /var/www/vhosts/naaridesignerboutique.in/httpdocs/resources/views/layouts/welcome.blade.php ENDPATH**/ ?>