<!DOCTYPE php>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo e(@$title); ?></title>
    <meta name="description" content="<?php echo e(@$desc); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(url('/')); ?>/public/assets/images/favicon.ico">
    <!-- CSS
  ============================================ -->
    <!-- Bootstrap CSS -->
    <link href="<?php echo e(url('/')); ?>/public/assets/css/bootstrap.min.css" rel="stylesheet">
    <!-- FontAwesome CSS -->
    <link href="<?php echo e(url('/')); ?>/public/assets/css/font-awesome.min.css" rel="stylesheet">
    <!-- Ionicons CSS -->
    <link href="<?php echo e(url('/')); ?>/public/assets/css/ionicons.min.css" rel="stylesheet">
    <!-- Themify CSS -->
    <link href="<?php echo e(url('/')); ?>/public/assets/css/themify-icons.css" rel="stylesheet">
    <!-- Plugins CSS -->
    <link href="<?php echo e(url('/')); ?>/public/assets/css/plugins.css" rel="stylesheet">
    <!-- Helper CSS -->
    <link href="<?php echo e(url('/')); ?>/public/assets/css/helper.css" rel="stylesheet">
    <!-- Main CSS -->
    <link href="<?php echo e(url('/')); ?>/public/assets/css/main.css" rel="stylesheet">
    <link href="<?php echo e(url('/')); ?>/public/assets/css/new.css" rel="stylesheet">
    <!-- Revolution Slider CSS -->
    <link href="<?php echo e(url('/')); ?>/public/assets/revolution/css/settings.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" />
    <link href="<?php echo e(url('/')); ?>/public/assets/revolution/css/navigation.css" rel="stylesheet">
    <link href="<?php echo e(url('/')); ?>/public/assets/revolution/custom-setting.css" rel="stylesheet">
    <!-- Modernizer JS -->
    <script src="<?php echo e(url('/')); ?>/public/assets/js/vendor/modernizr-2.8.3.min.js"></script>
</head>

<body>
    <!--=============================================
  =            Header overlay menu         =
  =============================================-->
    <!--=======  overlay-navigation-menu  =======-->
    <div class="overlay-navigation-menu overlay-navigation-inactive" id="overlay-navigation-menu">
        <!--=======  close icon  =======--> <span class="close-icon overlay-menu-close-icon">
      <a href="javascript:void(0)" id="overlay-menu-close-icon">
        <i class="ti-close"></i>
      </a>
    </span>
        <!--=======  End of close icon  =======-->
        <!--=======  overlay navigation menu  =======-->
        <div class="overlay-navigation-menu-container">
            <nav>
                <ul id="vertical-collapsible-menu">
                    <li class="has-children"><a href="index.php">Home</a>
                    </li>
                    <li class="has-children"><a href="<?php echo e(url('/category')); ?>">Collections</a>
                    </li>
                    <li class="has-children"><a href="<?php echo e(url('shop')); ?>">Shop</a>
                    </li>
                    <li class="has-children"><a href="<?php echo e(url('contact')); ?>">Contact Us</a>
                    </li>
                    <li class="has-children"><a href="<?php echo e(url('login')); ?>">Login</a>
                    </li>
                    <li class="has-children"><a href="<?php echo e(url('register')); ?>">Register</a>
                    </li>
                </ul>
            </nav>
        </div>
        <!--=======  End of overlay navigation menu  =======-->
    </div>
    <!--=======  End of overlay-navigation-menu  =======-->
    <!--=======  about overlay  =======-->
    <div class="header-offcanvas about-overlay" id="about-overlay">
        <div class="overlay-close inactive"></div>
        <div class="overlay-content">
            <!--=======  close icon  =======--> <span class="close-icon" id="about-close-icon">
        <a href="javascript:void(0)">
          <i class="ti-close"></i>
        </a>
      </span>
            <!--=======  End of close icon  =======-->
            <!--=======  overlay content container  =======-->
        </div>
    </div>
    <!--=======  End of about overlay  =======-->
    <?php echo $__env->make('includes.wishlist', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('includes.cart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--=======  search overlay  =======-->
    <div class="search-overlay shadow" id="search-overlay">
        <!--=======  close icon  =======--> <span class="close-icon search-close-icon">
      <a href="javascript:void(0)" id="search-close-icon">
        <i class="ti-close"></i>
      </a>
    </span>
        <!--=======  End of close icon  =======-->
        <!--=======  search overlay content  =======-->
        <div class="search-overlay-content">
            <div class="input-box">
                <form action="https://live.hasthemes.com/php/3/lezada-preview/lezada/index.php">
                    <input id="search_product_name" type="search" placeholder="Search Products...">
                    <div id="productLists"></div>
                </form>
            </div>
            <div class="search-hint"> <span># Hit enter to search or ESC to close</span>
            </div>
        </div>
        <!--=======  End of search overlay content  =======-->
    </div>
    <!--=======  End of search overlay  =======-->
    <!--=====  End of overlay items  ======-->
    <header class="header header-nontransparent-overlay-menu border-bottom-0 header-sticky">
        <!--=======  header bottom  =======-->
        <div class="header-bottom">
            <div class="container wide">
                <!--=======  header bottom container  =======-->
                <div class="header-bottom-container">
                    <!--=======  logo with off canvas  =======-->
                    <div class="logo-with-offcanvas d-flex">
                        <!--=======  overlay menu icon  =======-->
                        <div class="overlay-menu-icon mr-20 d-none d-lg-block">
                            <a href="javascript:void(0)" id="overlay-menu-icon"> <i class="ion-navicon"></i>
                            </a>
                        </div>
                        <!--=======  End of overlay menu icon  =======-->
                        <!-- Navigation -->
<a id="menu-toggle" href="#" class="btn btn-dark btn-lg toggle"><i class="fa fa-bars"></i></a>
                        <nav id="sidebar-wrapper" class="shadow">
                            <ul class="sidebar-nav"> <a id="menu-close" href="#" class="btn btn-close pull-right hidden-md hidden-lg toggle"><i class="fa fa-times"></i></a>
                                <li> <a href="<?php echo e(url('/')); ?>">Home</a>
                                </li>
                                <li> <a href="<?php echo e(url('shop')); ?>">Shop</a>
                                </li>
                                <li> <a href="<?php echo e(url('/category')); ?>" title="Navigate to Jonathan Adcox IT Resume">Collections</a>
                                </li>
                                <?php if(auth()->guard()->guest()): ?>
                                <li> <a href="<?php echo e(url('login')); ?>" title="Navigate to 'Our Services' section">Login</a>
                                </li>
                                <li> <a href="<?php echo e(url('register')); ?>" title="Navigate to 'Our Services' section">Register</a>
                                </li>
                                <?php else: ?>
                                <li> <a href="<?php echo e(url('account')); ?>" title="Navigate to 'Our Services' section">My Profile</a>
                                 <li> <a onclick="event.preventDefault();
                         document.getElementById('logout-form').submit();" href="<?php echo e(url('logout')); ?>" title="Navigate to 'Our Services' section">Logout</a>
                                </li>
                                <form id="logout-form" action="<?php echo e(url('logout')); ?>" method="POST" style="display: none;">
                                    <?php echo e(csrf_field()); ?>

                                </form>
                                <?php endif; ?>
                            </ul>
                        </nav>
                    </div>
                    <!--=======  End of logo with off canvas  =======-->
                    <!--=======  logo   =======-->
                    <div class="logo">
                        <a href="<?php echo e(url('/')); ?>">
                            <h3>TERRA KOTTA</h3>
                        </a>
                    </div>
                    <!--=======  End of logo   =======-->
                    <!--=======  headeer right container  =======-->
                    <div class="header-right-container">
                        <!--=======  header right icons  =======-->
                        <div class="header-right-icons d-flex  align-items-center h-100 justify-content-center">
                            <!--=======  single-icon  =======-->
                            <div class="single-icon search">
                                <a href="javascript:void(0)" id="search-icon"> <i class="ion-ios-search-strong"></i>
                                </a>
                            </div>
                            <!--=======  End of single-icon  =======-->
                            <!--=======  single-icon  =======-->
                            <div class="single-icon user-login">
                                <a href="<?php echo e(url('account')); ?>"> <i class="ion-android-person"></i>
                                </a>
                            </div>
                            <?php 
                                $cart_counter1 = \App\Models\Cart::where('session_id',Session::getId())->count('id'); 
                                $wishlist_counter1 = \App\Models\Wishlist::where('session_id',Session::getId())->count('id');
                            ?>
                            <div class="single-icon cart">
                                <a href="javascript:void(0)" id="offcanvas-cart-icon"> <i class="ion-ios-cart"></i>
                                    <span class="count"><?php echo e($cart_counter1); ?></span>
                                </a>
                            </div>
                            <!--=======  End of single-icon  =======-->
                            <!--=======  End of single-icon  =======-->
                            <!--=======  single-icon  =======-->
                            <div class="single-icon wishlist">
                                <a href="javascript:void(0)" id="offcanvas-wishlist-icon"> <i class="ion-android-favorite-outline"></i>
                                    <span class="count"><?php echo e($wishlist_counter1); ?></span>
                                </a>
                            </div>
                            <!--=======  End of single-icon  =======-->
                            <!--=======  single-icon  =======-->
                        </div>
                        <!--=======  End of header right icons  =======-->
                    </div>
                    <!--=======  End of headeer right container  =======-->
                </div>
                <!--=======  End of header bottom container  =======-->
                <!-- Mobile Navigation Start Here -->
                <div class="site-mobile-navigation d-block d-lg-none">
                    <div id="dl-menu" class="dl-menuwrapper site-mobile-nav">
                        <!--Site Mobile Menu Toggle Start-->
                        <button class="dl-trigger hamburger hamburger--spin"> <span class="hamburger-box">
                <span class="hamburger-inner"></span>
                            </span>
                        </button>
                        <!--Site Mobile Menu Toggle End-->
                        <ul class="dl-menu dl-menu-toggle">
                            <li class="has-children"><a href="index.php">Home</a>
                            </li>
                            <li class="has-children"><a href="<?php echo e(url('/category')); ?>">Collections</a>
                            </li>
                            <li class="has-children"><a href="<?php echo e(url('shop')); ?>">Shop</a>
                            </li>
                            <li class="has-children"><a href="<?php echo e(url('contact')); ?>">Contact Us</a>
                            </li>
                            <li class="has-children"><a href="<?php echo e(url('wishlist')); ?>">Wishlists</a>
                            </li>
                            <li class="has-children"><a href="<?php echo e(url('login')); ?>">Login</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <!-- Mobile Navigation End Here -->
            </div>
        </div>
        <!--=======  End of header bottom  =======-->
    </header>
    <!--===== End of Header overlay menu ======-->

   <?php echo $__env->yieldContent('content'); ?>

    <!--=            footer area     
  =============================================-->
    <div class="footer-container footer-one pt-50 ">
        <div class="container wide">
            <div class="row">
                <div class="col footer-single-widget">
                    <!--=======  copyright text  =======-->
                    <!--=======  logo  =======-->
                    <div class="logo">
                        <h3 class="text-white">TERRA KOTTA</h3>
                    </div>
                    <!--=======  End of logo  =======-->
                    <!--=======  copyright text  =======-->
                    <div class="copyright-text">
                        <p style="color: #fff;">&copy; 2020 TERRA KOTTA. <span>All Rights Reserved</span>
                        </p>
                    </div>
                    <!--=======  End of copyright text  =======-->
                    <!--=======  End of copyright text  =======-->
                </div>
                <div class="col footer-single-widget">
                    <!--=======  single widget  =======-->
                    <h5 class="widget-title">ABOUT</h5>
                    <!--=======  footer navigation container  =======-->
                    <div class="footer-nav-container">
                        <nav>
                            <ul>
                                <li><a href="<?php echo e(url('about')); ?>">About us</a>
                                </li>
                                <li><a href="<?php echo e(url('contact')); ?>">Contact Us</a>
                                </li>
								
								 <li><a href="<?php echo e(url('corporate-enquiry')); ?>">Corporate Enquiry</a>
                                </li>
								 <li><a href="<?php echo e(url('dealership-booking')); ?>">Dealership Booking</a>
                                </li>
								
                            </ul>
                        </nav>
                    </div>
                    <!--=======  End of footer navigation container  =======-->
                    <!--=======  single widget  =======-->
                </div>
                <div class="col footer-single-widget">
                    <!--=======  single widget  =======-->
                    <h5 class="widget-title">USEFUL LINKS</h5>
                    <!--=======  footer navigation container  =======-->
                    <div class="footer-nav-container">
                        <nav>
                            <ul>
                                <li><a href="<?php echo e(url('terms-condition')); ?>">Terms & Conditions</a>
                                </li>
                                <li><a href="<?php echo e(url('privacy-policy')); ?>">Privacy Policy</a>
                                </li>
                                <li><a href="<?php echo e(url('faq')); ?>">FAQs</a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                    <!--=======  End of footer navigation container  =======-->
                    <!--=======  single widget  =======-->
                </div>
                <div class="col footer-single-widget">
                    <!--=======  single widget  =======-->
                    <h5 class="widget-title">FOLLOW US ON</h5>
                    <!--=======  footer navigation container  =======-->
                    <div class="footer-nav-container footer-social-links">
                        <nav>
                            <ul>
                                <li><a href="http://twitter.com/"><i class="fa fa-twitter"></i> Twitter</a>
                                </li>
                                <li>
                                    <a href="http://facebook.com/"> <i class="fa fa-facebook"></i> Facebook</a>
                                </li>
                                <li><a href="http://instagram.com/"><i class="fa fa-instagram"></i> Instagram</a>
                                </li>
                                <li>
                                    <a href="http://youtube.com/"> <i class="fa fa-youtube"></i> Youtube</a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                    <!--=======  End of footer navigation container  =======-->
                    <!--=======  single widget  =======-->
                </div>
                <div class="col footer-single-widget">
                    <!--=======  single widget  =======-->
                    <div class="footer-subscription-widget">
                        <h2 class="footer-subscription-title">Subscribe.</h2>
                        <p class="subscription-subtitle">Subscribe to our newsletter to receive news on update.</p>
                        <!--=======  subscription form  =======-->
                        <div class="subscription-form">
                            <?php if(Session::has('flash_success_news')): ?>
                      <div class="alert alert-success">
                      <?php echo e(Session::get('flash_success_news')); ?>

                      </div>
                  <?php endif; ?>
                            <form class="mc-form" method="post" action="<?php echo e(url('subscribeNewsLetter')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="email" name="email" placeholder="Your email address" required>
                                <button type="submit">
                                    <i class="ion-ios-arrow-thin-right"></i>
                                </button>
                            </form>
                        </div>
                        <!--=======  End of subscription form  =======-->
                        <!-- mailchimp-alerts Start -->
                        <div class="mailchimp-alerts">
                            <div class="mailchimp-submitting"></div>
                            <!-- mailchimp-submitting end -->
                            <div class="mailchimp-success"></div>
                            <!-- mailchimp-success end -->
                            <div class="mailchimp-error"></div>
                            <!-- mailchimp-error end -->
                        </div>
                        <!-- mailchimp-alerts end -->
                    </div>
                    <!--=======  End of single widget  =======-->
                </div>
            </div>
        </div>
    </div>
    <!--=====  End of footer area  ======-->
    <!--=====  End of quick view  ======-->
    <!-- scroll to top  -->
    <a href="#" class="scroll-top"></a>
    <!-- end of scroll to top -->
    <!-- JS
  ============================================ -->
    <!-- jQuery JS -->
    <script src="<?php echo e(url('/')); ?>/public/assets/js/vendor/jquery.min.js"></script>
    <script type="text/javascript">
        function addToWishList(product_id){
            var size_id = $('.size_id').val();
            var color_id = $('.color_id').val();
               $.ajax({
                   url: '<?php echo e(url('add-to-wishlist')); ?>',
                   method: "POST",
                   data: {_token: '<?php echo e(csrf_token()); ?>', "product_id":product_id,"color_id":color_id,"size_id":size_id},
                   dataType: "json",
                   success: function (response) {
                       location.reload();
                   }
               });
         }

         function addToCart(product_id){
            var quantity = $('#quantity').val();
            var size_id = $('.size_id').val();
            var color_id = $('.color_id').val();
            $.ajax({
                url: '<?php echo e(url('add-to-cart')); ?>',
                method: "POST",
                data: {_token: '<?php echo e(csrf_token()); ?>', "product_id":product_id,"quantity":quantity,"size_id":size_id,"color_id":color_id},
                dataType: "json",
                success: function (response) {
                  location.reload();
                }
            });
         }

         function addToCartListing(product_id){
            var quantity = $('#quantity'+product_id).val();
            var size_id = $('.size_id'+product_id).val();
            var color_id = $('.color_id'+product_id).val();
            $.ajax({
                url: '<?php echo e(url('add-to-cart')); ?>',
                method: "POST",
                data: {_token: '<?php echo e(csrf_token()); ?>', "product_id":product_id,"quantity":quantity,"size_id":size_id,"color_id":color_id},
                dataType: "json",
                success: function (response) {
                  location.reload();
                }
            });
         }
      </script>
    <script src="<?php echo e(url('/')); ?>/public/assets/js/popper.min.js"></script>
    <script src="<?php echo e(url('/')); ?>/public/assets/js/bootstrap.min.js"></script>
    <script src="<?php echo e(url('/')); ?>/public/assets/js/plugins.js"></script>
    <script src="<?php echo e(url('/')); ?>/public/assets/js/main.js"></script>
    <script src="<?php echo e(url('/')); ?>/public/assets/revolution/js/jquery.themepunch.revolution.min.js"></script>
    <script src="<?php echo e(url('/')); ?>/public/assets/revolution/js/jquery.themepunch.tools.min.js"></script>
    <script src="<?php echo e(url('/')); ?>/public/assets/revolution/revolution-active.js"></script>
    <script src="<?php echo e(url('/')); ?>/public/assets/revolution/js/extensions/revolution.extension.kenburn.min.js"></script>
    <script src="<?php echo e(url('/')); ?>/public/assets/revolution/js/extensions/revolution.extension.slideanims.min.js"></script>
    <script src="<?php echo e(url('/')); ?>/public/assets/revolution/js/extensions/revolution.extension.actions.min.js"></script>
    <script src="<?php echo e(url('/')); ?>/public/assets/revolution/js/extensions/revolution.extension.layeranimation.min.js"></script>
    <script src="<?php echo e(url('/')); ?>/public/assets/revolution/js/extensions/revolution.extension.navigation.min.js"></script>
    <script src="<?php echo e(url('/')); ?>/public/assets/revolution/js/extensions/revolution.extension.parallax.min.js"></script>
    <script>
        $(document).ready(function()
                {
                  
                  // Closes the sidebar menu on menu-close button click event
                  $("#menu-close").click(function(e)              //declare the element event ...'(e)' = event (shorthand)
                  {
                                                // - will not work otherwise")
                    $("#sidebar-wrapper").toggleClass("active");      //instead on click event toggle active CSS element
                    e.preventDefault();                   //prevent the default action ("Do not remove as the code
                    
                    /*!
                    ======================= Notes ===============================
                    * see: .sidebar-wrapper.active in: style.css
                    ==================== END Notes ==============================
                    */
                  });                             //Close 'function()'
                
                  // Open the Sidebar-wrapper on Hover
                  $("#menu-toggle").hover(function(e)             //declare the element event ...'(e)' = event (shorthand)
                  {
                    $("#sidebar-wrapper").toggleClass("active",true);   //instead on click event toggle active CSS element
                    e.preventDefault();                   //prevent the default action ("Do not remove as the code
                  });
                
                  $("#menu-toggle").bind('click',function(e)          //declare the element event ...'(e)' = event (shorthand)
                  {
                    $("#sidebar-wrapper").toggleClass("active",true);   //instead on click event toggle active CSS element
                    e.preventDefault();                   //prevent the default action ("Do not remove as the code
                  });                             //Close 'function()'
                
                  $('#sidebar-wrapper').mouseleave(function(e)        //declare the jQuery: mouseleave() event 
                                                // - see: ('//api.jquery.com/mouseleave/' for details)
                  {
                    /*! .toggleClass( className, state ) */
                    $('#sidebar-wrapper').toggleClass('active',false);    /* toggleClass: Add or remove one or more classes from each element
                                                in the set of matched elements, depending on either the class's
                                                presence or the value of the state argument */
                    e.stopPropagation();                  //Prevents the event from bubbling up the DOM tree
                                                // - see: ('//api.jquery.com/event.stopPropagation/' for details)
                                                
                    e.preventDefault();                   // Prevent the default action of the event will not be triggered
                                                // - see: ('//api.jquery.com/event.preventDefault/' for details)
                  });
                });
                  $('#to-top').bind('click', function()
                  {
                    $('body,html').animate({
                      scrollTop: 0}, 
                      2500);
                  });
                
                  //Easing Scroll replace Anchor name in URL and Offset Position
         $('#search_product_name').keyup(function(){ 
            var query = $(this).val();
            if(query != '')
            {
             var _token = "<?php echo e(@csrf_token()); ?>";
             $.ajax({
              url:"<?php echo e(url('fetchProducts')); ?>",
              method:"POST",
              data:{query:query, _token:_token},
              success:function(data){
                $('#productLists').show();
                $('#productLists').html(data);
                $("#productLists").css("position","absolute");
                $("#productLists").css("height","300px");
                $("#productLists").css("overflow","scroll");
                $("#productLists").css("z-index","99999");
                $("#productLists").css("background","#fff");
                $("#productLists").css("min-width","476px");
                $("#search_product_name").css("background","#FFF");
              }
             });
            }
            else{
                $('#productLists').hide();
            }
        });    

        $('#search_product_search').keyup(function(){ 
            var query = $(this).val();
            if(query != '')
            {
             var _token = "<?php echo e(@csrf_token()); ?>";
             $.ajax({
              url:"<?php echo e(url('fetchProducts')); ?>",
              method:"POST",
              data:{query:query, _token:_token},
              success:function(data){
                $('#productListShop').show();
                $('#productListShop').html(data);
                $("#productListShop").css("position","absolute");
                $("#productListShop").css("height","300px");
                $("#productListShop").css("overflow","scroll");
                $("#productListShop").css("z-index","99999");
                $("#productListShop").css("background","#fff");
                $("#productListShop").css("min-width","120px");
                $("#search_product_search").css("background","#FFF");
              }
             });
            }
            else{
                $('#productListShop').hide();
            }
        });
        
         
    </script>
</body>

</html><?php /**PATH /var/www/html/tera/resources/views/layouts/app.blade.php ENDPATH**/ ?>