<?php $__env->startSection('content'); ?>
<div class="container">
  <h3 class="head-title pb-3 text-center" style="padding-top: 100px; padding-bottom: 100px;">My Order Summary</h3>
  <table class="table">
    <thead>
      <tr>
        <th>Order Id</th>
        <th><?php echo e($order->order_id); ?></th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>Amount Paid</td>
        <td>&#8377; <?php echo e($order->payable_price); ?></td>
      </tr>
      <tr>
        <td>Status</td>
        <td><?php echo e($order->status); ?></td>
      </tr>
      <tr>
        <td>Delivery Charge</td>
        <td>&#8377; <?php echo e($order->delivery_charge); ?></td>
      </tr>
      <?php if($order->wallet_amount > 0): ?>
      <tr>
        <td>Wallet Used</td>
        <td>&#8377; <?php echo e($order->wallet_amount); ?></td>
      </tr>
      <?php endif; ?>
      <?php if($order->coupon_amount > 0): ?>
      <tr>
        <td>Coupon Discount</td>
        <td>&#8377; <?php echo e($order->coupon_amount); ?></td>
      </tr>
      <?php endif; ?>
    </tbody>
  </table>


  <div class="card">
      <!-- /.card-header -->
      <div class="card-body">
        <table class="table table-bordered">
          <thead>                  
            <tr>
              <th>Image</th>
              <th>Product Name</th>
              <th>Price</th>
              <th>Quantity</th>
              <th>Color</th>
              <th>Size</th>
              <th>Total</th>
            </tr>
          </thead> 
          <tbody>
            <?php $__currentLoopData = $orderitems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
            $product = \App\Models\Product::where('id',$row->product_id)->first();
            $product_image = \App\Models\ProductImage::where('product_id',$row->product_id)->first(); 
            ?> 
            <tr>
            	<td>
                  <img style="width:100%" src="<?php echo e(URL::to('/')); ?>/uploads/images/<?php echo e(@$product_image->image); ?>"> 
              	</td>
              	<td><?php echo e(@$product->name); ?></td>
              	<td>&#8377;<?php echo e(@$row->selling_price); ?></td>
              	<td><?php echo e(@$row->quantity); ?></td>
              	<td><?php echo e(@$row->color->name); ?></td>
              	<td><?php echo e(@$row->size->name); ?></td>
              	<td>&#8377;<?php echo e(@$row->selling_price * $row->quantity); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
  </div>

  <h3 class="head-title pb-3 text-center" style="padding-top: 100px; padding-bottom: 100px;">Shipping Address</h3>
  <table class="table">
    <tbody>
      <tr>
        <td>Name</td>
        <td><?php echo e($order->name); ?></td>
      </tr>
      <tr>
        <td>Email</td>
        <td><?php echo e($order->email); ?></td>
      </tr>
      <tr>
        <td>Phone</td>
        <td><?php echo e($order->phone); ?></td>
      </tr>
      <tr>
        <td>Street</td>
        <td><?php echo e($order->street); ?></td>
      </tr>
      <tr>
        <td>Country</td>
        <td><?php echo e($order->country); ?></td>
      </tr>
      <tr>
        <td>state</td>
        <td><?php echo e($order->state); ?></td>
      </tr>
       <tr>
        <td>City</td>
        <td><?php echo e($order->city); ?></td>
      </tr>
       <tr>
        <td>Pincode</td>
        <td><?php echo e($order->pincode); ?></td>
      </tr>
    </tbody>
  </table>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/naribotique/resources/views/user/order-details.blade.php ENDPATH**/ ?>